/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.visualwords;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.enums.OutsideSBFeature;
import at.hannibal2.skyhanni.config.features.gui.ModifyWordsConfig;
import at.hannibal2.skyhanni.features.misc.visualwords.VisualWord;
import at.hannibal2.skyhanni.mixins.transformers.AccessorMixinGuiNewChat;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u0019\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0019R\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u0019R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\"\u0010$\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010#\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/misc/visualwords/ModifyVisualWords;", "", "<init>", "()V", "", "update", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "toggleDebug", "", "originalText", "modifyText", "(Ljava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/features/gui/ModifyWordsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/gui/ModifyWordsConfig;", "config", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "textCache", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "", "Lat/hannibal2/skyhanni/features/misc/visualwords/VisualWord;", "userModifiedWords", "Ljava/util/List;", "getUserModifiedWords", "()Ljava/util/List;", "setUserModifiedWords", "(Ljava/util/List;)V", "modModifiedWords", "", "finalWordsList", "", "debug", "Z", "changeWords", "getChangeWords", "()Z", "setChangeWords", "(Z)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nModifyVisualWords.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifyVisualWords.kt\nat/hannibal2/skyhanni/features/misc/visualwords/ModifyVisualWords\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,91:1\n381#2,7:92\n*S KotlinDebug\n*F\n+ 1 ModifyVisualWords.kt\nat/hannibal2/skyhanni/features/misc/visualwords/ModifyVisualWords\n*L\n66#1:92,7\n*E\n"})
public final class ModifyVisualWords {
    @NotNull
    public static final ModifyVisualWords INSTANCE = new ModifyVisualWords();
    @NotNull
    private static final TimeLimitedCache<String, String> textCache = new TimeLimitedCache(DurationKt.toDuration(5, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static List<VisualWord> userModifiedWords = new ArrayList();
    @NotNull
    private static final List<VisualWord> modModifiedWords = new ArrayList();
    @NotNull
    private static List<VisualWord> finalWordsList = CollectionsKt.emptyList();
    private static boolean debug;
    private static boolean changeWords;

    private ModifyVisualWords() {
    }

    private final ModifyWordsConfig getConfig() {
        return SkyHanniMod.feature.gui.getModifyWords();
    }

    @NotNull
    public final List<VisualWord> getUserModifiedWords() {
        return userModifiedWords;
    }

    public final void setUserModifiedWords(@NotNull List<VisualWord> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        userModifiedWords = list;
    }

    public final void update() {
        finalWordsList = CollectionsKt.plus((Collection)modModifiedWords, (Iterable)userModifiedWords);
        textCache.clear();
        SkyHanniMod.INSTANCE.getVisualWordsData().setModifiedWords(userModifiedWords);
        GuiNewChat guiNewChat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        Intrinsics.checkNotNull(guiNewChat, "null cannot be cast to non-null type kotlin.Any");
        ((AccessorMixinGuiNewChat)guiNewChat).refreshChat_skyhanni();
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.register("shdebugvisualwords", ModifyVisualWords::onCommandRegistration$lambda$1);
    }

    private final void toggleDebug() {
        debug = !debug;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Visual Words debug " + (debug ? "enabled" : "disabled"), false, null, false, false, null, 62, null);
        if (debug) {
            this.update();
        }
    }

    public final boolean getChangeWords() {
        return changeWords;
    }

    public final void setChangeWords(boolean bl) {
        changeWords = bl;
    }

    @Nullable
    public final String modifyText(@Nullable String originalText) {
        Object object;
        String modifiedText = null;
        String string = originalText;
        if (string == null) {
            return null;
        }
        modifiedText = string;
        if (!SkyBlockUtils.INSTANCE.getOnHypixel()) {
            return originalText;
        }
        if (!this.getConfig().getEnabled()) {
            return originalText;
        }
        if (!SkyBlockUtils.INSTANCE.getInSkyBlock() && !OutsideSBFeature.MODIFY_VISUAL_WORDS.isSelected()) {
            return originalText;
        }
        if (!changeWords) {
            return originalText;
        }
        if (userModifiedWords.isEmpty() && !((Collection)SkyHanniMod.INSTANCE.getVisualWordsData().getModifiedWords()).isEmpty()) {
            userModifiedWords.addAll((Collection<VisualWord>)SkyHanniMod.INSTANCE.getVisualWordsData().getModifiedWords());
            this.update();
        }
        Map $this$getOrPut$iv = textCache;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(originalText);
        if (value$iv == null) {
            boolean bl = false;
            if (StringsKt.startsWith$default(originalText, "\u00a7\u00a7", false, 2, null)) {
                modifiedText = StringsKt.removePrefix(modifiedText, (CharSequence)"\u00a7\u00a7");
            } else {
                for (VisualWord modifiedWord : finalWordsList) {
                    String phrase;
                    if (!modifiedWord.getEnabled() || ((CharSequence)(phrase = StringUtils.INSTANCE.convertToFormatted(modifiedWord.getPhrase()))).length() == 0) continue;
                    String original = modifiedText;
                    String replacement = StringUtils.INSTANCE.convertToFormatted(modifiedWord.getReplacement());
                    modifiedText = StringsKt.replace(modifiedText, phrase, replacement, modifiedWord.isCaseSensitive());
                    if (!debug || Intrinsics.areEqual(original, modifiedText)) continue;
                    System.out.println((Object)("Visual words Change debug: '" + original + "' -> `" + modifiedText + "` (`" + phrase + "` -> `" + replacement + "`)"));
                }
            }
            String answer$iv = modifiedText;
            $this$getOrPut$iv.put(originalText, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (String)object;
    }

    private static final Unit onCommandRegistration$lambda$1$lambda$0(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.toggleDebug();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$1(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Prints in the console all replaced words by /shwords");
        $this$register.callback(ModifyVisualWords::onCommandRegistration$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    static {
        changeWords = true;
    }
}

