/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.crimsonisle.ReputationHelperConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ReputationQuest;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.combat.damageindicator.DamageIndicatorManager;
import at.hannibal2.skyhanni.features.nether.reputationhelper.CrimsonIsleReputationHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.DailyQuestHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.MiniBossQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.Quest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.QuestState;
import at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss.CrimsonMiniBoss;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.RenderableUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010 \u001a\u00020\u00062\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\"\u0010\u001bJ\u0019\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b&\u0010'R\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u00138\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010/\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;", "miniBoss", "", "needMiniBossQuest", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;)Z", "finished", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;)V", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "addDailyMiniBoss", "(Ljava/util/List;)V", "reset", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;", "storage", "saveConfig", "(Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;)V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ReputationQuest;", "data", "onRepoReload", "(Ljava/util/Map;)V", "loadData", "name", "getByDisplayName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/CrimsonMiniBoss;", "isEnabled", "()Z", "miniBosses", "Ljava/util/List;", "getMiniBosses", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ReputationHelperConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDailyMiniBossHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyMiniBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 DailyQuestHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n8#2:128\n1#3:129\n194#4:130\n808#5,11:131\n1782#5,4:142\n774#5:146\n865#5,2:147\n1863#5,2:149\n295#5,2:151\n*S KotlinDebug\n*F\n+ 1 DailyMiniBossHelper.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/miniboss/DailyMiniBossHelper\n*L\n39#1:128\n39#1:129\n62#1:130\n62#1:131,11\n73#1:142,4\n103#1:146\n103#1:147,2\n104#1:149,2\n124#1:151,2\n*E\n"})
public final class DailyMiniBossHelper {
    @NotNull
    public static final DailyMiniBossHelper INSTANCE = new DailyMiniBossHelper();
    @NotNull
    private static final List<CrimsonMiniBoss> miniBosses = new ArrayList();

    private DailyMiniBossHelper() {
    }

    @NotNull
    public final List<CrimsonMiniBoss> getMiniBosses() {
        return miniBosses;
    }

    private final ReputationHelperConfig getConfig() {
        return SkyHanniMod.feature.getCrimsonIsle().getReputationHelper();
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        String message = event2.getMessage();
        for (CrimsonMiniBoss miniBoss : miniBosses) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = miniBoss.getPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(message);
            boolean bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            INSTANCE.finished(miniBoss);
        }
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!CrimsonIsleReputationHelper.INSTANCE.showLocations()) {
            return;
        }
        LorenzVec playerLocation = LocationUtils.INSTANCE.playerLocation();
        for (CrimsonMiniBoss miniBoss : miniBosses) {
            LorenzVec location;
            if (miniBoss.getDoneToday() && !this.needMiniBossQuest(miniBoss) || miniBoss.getLocation() == null || DamageIndicatorManager.INSTANCE.getNearestDistanceTo(location) < 40.0 && playerLocation.distance(location) < 40.0) continue;
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, location, LorenzColor.WHITE.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, location, miniBoss.getDisplayName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean needMiniBossQuest(CrimsonMiniBoss miniBoss) {
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv$iv;
        DailyQuestHelper this_$iv = DailyQuestHelper.INSTANCE;
        boolean $i$f$getQuest = false;
        Iterable $this$filterIsInstance$iv$iv = this_$iv.getQuests();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof MiniBossQuest)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        MiniBossQuest miniBossQuest = (MiniBossQuest)((Quest)CollectionsKt.firstOrNull((List)destination$iv$iv$iv));
        if (miniBossQuest != null) {
            MiniBossQuest it = miniBossQuest;
            boolean bl2 = false;
            bl = Intrinsics.areEqual(it.getMiniBoss(), miniBoss) && it.getState() == QuestState.ACCEPTED;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void finished(CrimsonMiniBoss miniBoss) {
        DailyQuestHelper.INSTANCE.finishMiniBoss(miniBoss);
        miniBoss.setDoneToday(true);
        CrimsonIsleReputationHelper.INSTANCE.update();
    }

    public final void addDailyMiniBoss(@NotNull List<Renderable> $this$addDailyMiniBoss) {
        int n;
        Intrinsics.checkNotNullParameter($this$addDailyMiniBoss, "<this>");
        Iterable $this$count$iv = miniBosses;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv;
                boolean bl = false;
                if (!it.getDoneToday() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int done = n;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addDailyMiniBoss, "", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addDailyMiniBoss, "\u00a77Daily Bosses (\u00a7e" + done + "\u00a78/\u00a7e5 killed\u00a77)", 0.0, null, null, 14, null);
        if (done != 5) {
            for (CrimsonMiniBoss miniBoss : miniBosses) {
                if (((Boolean)this.getConfig().getHideComplete().get()).booleanValue() && miniBoss.getDoneToday()) continue;
                String result2 = miniBoss.getDoneToday() ? "\u00a7aDone" : "\u00a7bTodo";
                String displayName = miniBoss.getDisplayName();
                NeuInternalName displayItem = miniBoss.getDisplayItem();
                RenderableUtilsKt.addLine($this$addDailyMiniBoss, arg_0 -> DailyMiniBossHelper.addDailyMiniBoss$lambda$3(displayItem, displayName, result2, arg_0));
            }
        }
    }

    public final void reset() {
        for (CrimsonMiniBoss miniBoss : miniBosses) {
            miniBoss.setDoneToday(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveConfig(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(storage2, "storage");
        storage2.getMiniBossesDoneToday().clear();
        Iterable $this$filter$iv = miniBosses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv$iv;
            boolean bl = false;
            if (!it.getDoneToday()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv;
            boolean bl = false;
            storage2.getMiniBossesDoneToday().add(it.getDisplayName());
        }
    }

    public final void onRepoReload(@NotNull Map<String, ReputationQuest> data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        miniBosses.clear();
        for (Map.Entry<String, ReputationQuest> entry : data2.entrySet()) {
            Pattern pattern;
            String displayName = entry.getKey();
            ReputationQuest quest = entry.getValue();
            NeuInternalName displayItem = quest.getItem();
            StringBuilder stringBuilder = new StringBuilder().append("\u00a7f *\u00a7r\u00a76\u00a7l");
            String string = displayName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            String string2 = stringBuilder.append(string).append(" DOWN!").toString();
            int n = 0;
            Intrinsics.checkNotNullExpressionValue(Pattern.compile(string2, n), "compile(...)");
            LorenzVec location = CrimsonIsleReputationHelper.INSTANCE.readLocationData(quest.getLocation());
            miniBosses.add(new CrimsonMiniBoss(displayName, displayItem, location, pattern, false, 16, null));
        }
    }

    public final void loadData(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        Intrinsics.checkNotNullParameter(storage2, "storage");
        if (miniBosses.isEmpty()) {
            return;
        }
        for (String name2 : storage2.getMiniBossesDoneToday()) {
            CrimsonMiniBoss crimsonMiniBoss = this.getByDisplayName(name2);
            Intrinsics.checkNotNull(crimsonMiniBoss);
            crimsonMiniBoss.setDoneToday(true);
        }
    }

    private final CrimsonMiniBoss getByDisplayName(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = miniBosses;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CrimsonMiniBoss it = (CrimsonMiniBoss)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getDisplayName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isEnabled() {
        return IslandType.CRIMSON_ISLE.isCurrent() && (Boolean)this.getConfig().getEnabled().get() != false;
    }

    private static final Unit addDailyMiniBoss$lambda$3(NeuInternalName $displayItem, String $displayName, String $result, List $this$addLine) {
        Intrinsics.checkNotNullParameter($displayItem, "$displayItem");
        Intrinsics.checkNotNullParameter($displayName, "$displayName");
        Intrinsics.checkNotNullParameter($result, "$result");
        Intrinsics.checkNotNullParameter($this$addLine, "$this$addLine");
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, " ", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$addLine, NeuItems.INSTANCE.getItemStack($displayItem), false, 0.0, 6, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$addLine, "\u00a75" + $displayName + "\u00a77: " + $result, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }
}

