/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.area.colosseum;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.rift.area.colosseum.ColosseumConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.features.rift.area.colosseum.BacteApi;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.DamageSourceCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000f0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/rift/area/colosseum/TentacleWaypoint;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$Special;", "event", "", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$Special;)V", "Lat/hannibal2/skyhanni/events/MobEvent$Hurt$Special;", "onEntityDamage", "(Lat/hannibal2/skyhanni/events/MobEvent$Hurt$Special;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRender", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "", "hits", "", "getText", "(I)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;", "onWorldSwitch", "(Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/rift/area/colosseum/ColosseumConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/area/colosseum/ColosseumConfig;", "config", "", "Lnet/minecraft/entity/EntityLivingBase;", "tentacleHits", "Ljava/util/Map;", "Lkotlin/ranges/IntRange;", "VALID_SLIME_SIZES", "Lkotlin/ranges/IntRange;", "TENTACLE_FLOOR_Y", "I", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTentacleWaypoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TentacleWaypoint.kt\nat/hannibal2/skyhanni/features/rift/area/colosseum/TentacleWaypoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class TentacleWaypoint {
    @NotNull
    public static final TentacleWaypoint INSTANCE = new TentacleWaypoint();
    @NotNull
    private static final Map<EntityLivingBase, Integer> tentacleHits = new LinkedHashMap();
    @NotNull
    private static final IntRange VALID_SLIME_SIZES = new IntRange(4, 8);
    private static final int TENTACLE_FLOOR_Y = 68;

    private TentacleWaypoint() {
    }

    private final ColosseumConfig getConfig() {
        return SkyHanniMod.feature.getRift().getArea().getColosseum();
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onEntityHealthUpdate(@NotNull MobEvent.Spawn.Special event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        EntityLivingBase entityLivingBase = event2.getMob().getBaseEntity();
        EntitySlime entitySlime = entityLivingBase instanceof EntitySlime ? (EntitySlime)entityLivingBase : null;
        if (entitySlime == null) {
            return;
        }
        EntitySlime entity = entitySlime;
        if (!Intrinsics.areEqual(event2.getMob().getName(), "Bacte Tentacle")) {
            return;
        }
        if ((int)Math.ceil(entity.field_70163_u) != 68) {
            return;
        }
        Object object = VALID_SLIME_SIZES;
        int n = ((IntProgression)object).getFirst();
        int n2 = ((IntProgression)object).getLast();
        int n3 = entity.func_70809_q();
        if (!(n <= n3 ? n3 <= n2 : false)) {
            return;
        }
        if (tentacleHits.containsKey(entity)) {
            return;
        }
        object = tentacleHits;
        EntityLivingBase entityLivingBase2 = event2.getMob().getBaseEntity();
        Intrinsics.checkNotNull(entityLivingBase2, "null cannot be cast to non-null type net.minecraft.entity.monster.EntitySlime");
        Pair<EntitySlime, Integer> pair = TuplesKt.to((EntitySlime)entityLivingBase2, 0);
        object.put(pair.getFirst(), pair.getSecond());
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onEntityDamage(@NotNull MobEvent.Hurt.Special event2) {
        block3: {
            Intrinsics.checkNotNullParameter(event2, "event");
            if (!this.isEnabled()) {
                return;
            }
            EntityLivingBase entityLivingBase = event2.getMob().getBaseEntity();
            EntitySlime entitySlime = entityLivingBase instanceof EntitySlime ? (EntitySlime)entityLivingBase : null;
            if (entitySlime == null) {
                return;
            }
            EntitySlime entity = entitySlime;
            if (!Intrinsics.areEqual(event2.getSource().field_76373_n, DamageSourceCompat.INSTANCE.getGeneric().field_76373_n)) {
                return;
            }
            Integer n = tentacleHits.get(entity);
            if (n == null) break block3;
            int it = ((Number)n).intValue();
            boolean bl = false;
            tentacleHits.put((EntityLivingBase)entity, it + 1);
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onRender(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        CollectionUtils.INSTANCE.removeIfKey(tentacleHits, TentacleWaypoint::onRender$lambda$1);
        for (Map.Entry<EntityLivingBase, Integer> entry : tentacleHits.entrySet()) {
            EntityLivingBase tentacle = entry.getKey();
            int hits = ((Number)entry.getValue()).intValue();
            LorenzVec location = LorenzVecKt.getLorenzVec((Entity)tentacle);
            LorenzVec lorenzVec = location.add(-0.5, 0.0, -0.5);
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, lorenzVec, color, true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, location.add(-0.5, 1.0, -0.5), this.getText(hits), 1.2, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    private final String getText(int hits) {
        String string;
        if (BacteApi.INSTANCE.getCurrentPhase() == BacteApi.Phase.PHASE_5) {
            string = "\u00a7a" + StringUtils.pluralize$default(StringUtils.INSTANCE, hits, "Hit", null, true, 4, null);
        } else {
            int maxHp = WhenMappings.$EnumSwitchMapping$0[BacteApi.INSTANCE.getCurrentPhase().ordinal()] == 1 ? 3 : 4;
            String hpColor = hits > 0 ? "\u00a7c" : "\u00a7a";
            string = hpColor + (maxHp - hits) + "\u00a7a/" + maxHp + "\u00a7c\u2764";
        }
        return string;
    }

    @HandleEvent
    public final void onWorldSwitch(@NotNull WorldChangeEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        tentacleHits.clear();
    }

    private final boolean isEnabled() {
        return RiftApi.INSTANCE.inColosseum() && this.getConfig().getTentacleWaypoints();
    }

    private static final boolean onRender$lambda$1(EntityLivingBase it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.field_70128_L || it.func_110143_aJ() == 0.0f;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BacteApi.Phase.values().length];
            try {
                nArray[BacteApi.Phase.PHASE_4.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

