/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.area.westvillage.kloon;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.rift.area.westvillage.KloonHackingConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipTextEvent;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.features.rift.area.westvillage.kloon.KloonTerminal;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0011\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001b\u0010.\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00101R\u0016\u00103\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00101R\u001a\u00106\u001a\b\u0012\u0004\u0012\u000205048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0018\u00108\u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lat/hannibal2/skyhanni/features/rift/area/westvillage/kloon/KloonHacking;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkHelmet", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipTextEvent;", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipTextEvent;)V", "Lat/hannibal2/skyhanni/features/rift/area/westvillage/kloon/KloonTerminal;", "getNearestTerminal", "()Lat/hannibal2/skyhanni/features/rift/area/westvillage/kloon/KloonTerminal;", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/rift/area/westvillage/KloonHackingConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/area/westvillage/KloonHackingConfig;", "config", "Ljava/util/regex/Pattern;", "colorPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getColorPattern", "()Ljava/util/regex/Pattern;", "colorPattern", "", "wearingHelmet", "Z", "inTerminalInventory", "inColorInventory", "", "", "correctButtons", "Ljava/util/List;", "nearestTerminal", "Lat/hannibal2/skyhanni/features/rift/area/westvillage/kloon/KloonTerminal;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "RETRO_ENCABULATING_VISOR", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nKloonHacking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KloonHacking.kt\nat/hannibal2/skyhanni/features/rift/area/westvillage/kloon/KloonHacking\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1755#2,3:183\n295#2,2:188\n8#3:186\n1#4:187\n*S KotlinDebug\n*F\n+ 1 KloonHacking.kt\nat/hannibal2/skyhanni/features/rift/area/westvillage/kloon/KloonHacking\n*L\n109#1:183,3\n140#1:188,2\n137#1:186\n137#1:187\n*E\n"})
public final class KloonHacking {
    @NotNull
    public static final KloonHacking INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern colorPattern$delegate;
    private static boolean wearingHelmet;
    private static boolean inTerminalInventory;
    private static boolean inColorInventory;
    @NotNull
    private static final List<String> correctButtons;
    @Nullable
    private static KloonTerminal nearestTerminal;
    @NotNull
    private static final NeuInternalName RETRO_ENCABULATING_VISOR;

    private KloonHacking() {
    }

    private final KloonHackingConfig getConfig() {
        return RiftApi.INSTANCE.getConfig().getArea().getWestVillage().getHacking();
    }

    private final Pattern getColorPattern() {
        return (Pattern)colorPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        this.checkHelmet();
    }

    private final void checkHelmet() {
        ItemStack itemStack = InventoryUtils.INSTANCE.getHelmet();
        wearingHelmet = Intrinsics.areEqual(itemStack != null ? ItemUtils.INSTANCE.getInternalName(itemStack) : null, RETRO_ENCABULATING_VISOR);
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        inTerminalInventory = false;
        inColorInventory = false;
        nearestTerminal = null;
        if (!this.getConfig().getSolver()) {
            return;
        }
        if (Intrinsics.areEqual(event2.getInventoryName(), "Hacking") || Intrinsics.areEqual(event2.getInventoryName(), "Hacking (As seen on CSI)")) {
            inTerminalInventory = true;
            correctButtons.clear();
            for (Map.Entry<Integer, ItemStack> entry : event2.getInventoryItems().entrySet()) {
                int slot = ((Number)entry.getKey()).intValue();
                ItemStack stack = entry.getValue();
                boolean bl = 2 <= slot ? slot < 7 : false;
                if (!bl) continue;
                String string = stack.func_82833_r();
                Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
                correctButtons.add(StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null));
            }
        }
        if (Intrinsics.areEqual(event2.getInventoryName(), "Hacked Terminal Color Picker")) {
            inColorInventory = true;
        }
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        inTerminalInventory = false;
        inColorInventory = false;
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (inTerminalInventory) {
            if (!this.getConfig().getSolver()) {
                return;
            }
            int i2 = 0;
            for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
                if (slot.getSlotIndex() == 11 + 10 * i2) {
                    String string = slot.func_75211_c().func_82833_r();
                    Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
                    boolean correctButton = Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null), correctButtons.get(i2));
                    RenderUtils.INSTANCE.highlight(slot, correctButton ? LorenzColor.GREEN : LorenzColor.RED);
                    continue;
                }
                if (slot.getSlotIndex() > i2 * 9 + 8 && slot.getSlotIndex() < i2 * 9 + 18) {
                    String string = slot.func_75211_c().func_82833_r();
                    Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
                    if (Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null), correctButtons.get(i2))) {
                        RenderUtils.INSTANCE.highlight(slot, LorenzColor.YELLOW);
                    }
                }
                if (slot.getSlotIndex() != i2 * 9 + 17) continue;
                ++i2;
            }
        }
        if (inColorInventory) {
            if (!this.getConfig().getColor()) {
                return;
            }
            KloonTerminal kloonTerminal = nearestTerminal;
            if (kloonTerminal == null) {
                kloonTerminal = this.getNearestTerminal();
            }
            KloonTerminal targetColor = kloonTerminal;
            for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
                boolean bl;
                block14: {
                    ItemStack itemStack = slot.func_75211_c();
                    Intrinsics.checkNotNullExpressionValue(itemStack, "getStack(...)");
                    Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(itemStack);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            CharSequence charSequence = it;
                            KloonTerminal kloonTerminal2 = targetColor;
                            String string = kloonTerminal2 != null ? kloonTerminal2.name() : null;
                            if (string == null) {
                                string = "";
                            }
                            if (!StringsKt.contains$default(charSequence, string, false, 2, null)) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                RenderUtils.INSTANCE.highlight(slot, LorenzColor.GREEN);
            }
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT, priority=-1)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!inTerminalInventory) {
            return;
        }
        event2.makePickblock();
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.getConfig().getWaypoints()) {
            return;
        }
        if (!wearingHelmet) {
            return;
        }
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (object == null || (object = ((ProfileSpecificStorage)object).getRift()) == null) {
            return;
        }
        Object storage2 = object;
        for (KloonTerminal terminal : KloonTerminal.getEntries()) {
            if (((ProfileSpecificStorage.RiftStorage)storage2).getCompletedKloonTerminals().contains((Object)terminal)) continue;
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, terminal.getLocation(), LorenzColor.DARK_RED.toColor(), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!wearingHelmet) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getColorPattern();
        String text$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, event2.getMessage(), false, 1, null);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Object v1;
            Object storage2;
            block6: {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$onChat_u24lambda_u242 = it$iv;
                boolean bl2 = false;
                Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
                if (object == null || (object = ((ProfileSpecificStorage)object).getRift()) == null) {
                    return;
                }
                storage2 = object;
                String color = $this$onChat_u24lambda_u242.group("color");
                Iterable $this$firstOrNull$iv = KloonTerminal.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KloonTerminal it = (KloonTerminal)((Object)element$iv);
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.name(), color)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            KloonTerminal kloonTerminal = v1;
            if (kloonTerminal == null) {
                return;
            }
            KloonTerminal completedTerminal = kloonTerminal;
            if (completedTerminal != nearestTerminal) {
                return;
            }
            ((ProfileSpecificStorage.RiftStorage)storage2).getCompletedKloonTerminals().add(completedTerminal);
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onToolTip(@NotNull ToolTipTextEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (event2.getSlot() == null) {
            return;
        }
        if (!inTerminalInventory) {
            return;
        }
        if (!this.getConfig().getSolver()) {
            return;
        }
        Integer[] integerArray = new Integer[]{0, 2, 3, 4, 5, 6, 8, 9, 26, 27, 44, 45};
        List<Integer> neededTooltips = CollectionsKt.listOf(integerArray);
        if (!neededTooltips.contains(event2.getSlot().getSlotIndex())) {
            event2.cancel();
        }
    }

    private final KloonTerminal getNearestTerminal() {
        KloonTerminal closestTerminal = null;
        double closestDistance = 8.0;
        for (KloonTerminal terminal : KloonTerminal.getEntries()) {
            double distance = LocationUtils.INSTANCE.distanceToPlayer(terminal.getLocation());
            if (!(distance < closestDistance)) continue;
            closestTerminal = terminal;
            closestDistance = distance;
        }
        nearestTerminal = closestTerminal;
        return closestTerminal;
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 9, "rift.area.westVillageConfig", "rift.area.westVillage", null, 8, null);
        String basePath = "rift.area.westVillage";
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 82, basePath + ".hacking.colour", basePath + ".hacking.color", null, 8, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(KloonHacking.class, "colorPattern", "getColorPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new KloonHacking();
        colorPattern$delegate = RepoPattern.Companion.pattern("rift.area.westvillage.kloon.color", "You've set the color of this terminal to (?<color>.*)!");
        correctButtons = new ArrayList();
        RETRO_ENCABULATING_VISOR = NeuInternalName.Companion.toInternalName("RETRO_ENCABULATING_VISOR");
    }
}

