/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.mixins.transformers;

import net.minecraft.client.gui.FontRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FontRenderer.class})
public abstract class ExtendedColorPatch {
    @Shadow
    private int field_78304_r;
    @Shadow
    private float field_78305_q;
    @Unique
    private int skyhanni$colorSR;
    @Unique
    private int skyhanni$colorState;
    @Unique
    private static boolean skyhanni$isSpecial = false;

    @Shadow(remap=false)
    protected abstract void setColor(float var1, float var2, float var3, float var4);

    @Inject(method={"renderStringAtPos"}, at={@At(value="HEAD")})
    private void resetStateWhenRendering(String text, boolean shadow, CallbackInfo ci) {
        this.skyhanni$colorSR = 0;
        this.skyhanni$colorState = -1;
    }

    @Inject(method={"isFormatSpecial"}, at={@At(value="HEAD")}, cancellable=true)
    private static void protectFormatCodesSpecial(char formatChar, CallbackInfoReturnable<Boolean> cir) {
        if (formatChar == '/') {
            skyhanni$isSpecial = false;
            cir.setReturnValue(true);
        } else if (skyhanni$isSpecial) {
            cir.setReturnValue(true);
        }
    }

    @Inject(method={"isFormatColor"}, at={@At(value="HEAD")}, cancellable=true)
    private static void protectFormatCodesSimple(char formatChar, CallbackInfoReturnable<Boolean> cir) {
        if (formatChar == '#') {
            skyhanni$isSpecial = true;
            cir.setReturnValue(true);
        } else if (skyhanni$isSpecial) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"getFormatFromString"}, at={@At(value="TAIL")})
    private static void resetState(String text, CallbackInfoReturnable<String> cir) {
        skyhanni$isSpecial = false;
    }

    @Inject(method={"getFormatFromString"}, at={@At(value="HEAD")})
    private static void resetStateAtHead(String text, CallbackInfoReturnable<String> cir) {
        skyhanni$isSpecial = false;
    }

    @Inject(method={"renderStringAtPos"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/FontRenderer;setColor(FFFF)V", ordinal=0, shift=At.Shift.AFTER, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onChooseColor(String text, boolean shadow, CallbackInfo ci, int i2, char c0, int i1) {
        char c = text.charAt(i2 + 1);
        int hexCode = "0123456789abcdef".indexOf(c);
        if (c == '#') {
            if (this.skyhanni$colorState != -1) {
                throw new IllegalStateException("Encountered \u00a7# while inside push sequence");
            }
            this.skyhanni$colorState = 0;
            this.skyhanni$colorSR = 0;
        } else if (c == '/') {
            if (this.skyhanni$colorState != 8 && this.skyhanni$colorState != 6) {
                throw new IllegalStateException("Encountered \u00a7/ without encountering enough pushes: " + this.skyhanni$colorState);
            }
            this.field_78304_r = this.skyhanni$colorSR;
            int shadowDivisor = shadow ? 4 : 1;
            this.setColor((float)(this.skyhanni$colorSR >> 16 & 0xFF) / 255.0f / (float)shadowDivisor, (float)(this.skyhanni$colorSR >> 8 & 0xFF) / 255.0f / (float)shadowDivisor, (float)(this.skyhanni$colorSR & 0xFF) / 255.0f / (float)shadowDivisor, this.skyhanni$colorState == 8 ? (float)(this.skyhanni$colorSR >> 24 & 0xFF) / 255.0f : this.field_78305_q);
            this.skyhanni$colorState = -1;
        } else if (0 <= hexCode && this.skyhanni$colorState != -1) {
            ++this.skyhanni$colorState;
            if (this.skyhanni$colorState > 8) {
                throw new IllegalStateException("Encountered too many pushes inside of \u00a7#\u00a7/ sequence");
            }
            this.skyhanni$colorSR = this.skyhanni$colorSR << 4 | hexCode;
        }
    }
}

