/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketSentEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.ReflectionUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.compat.PacketCompatKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C00PacketKeepAlive;
import net.minecraft.network.play.client.C03PacketPlayer;
import net.minecraft.network.play.client.C09PacketHeldItemChange;
import net.minecraft.network.play.client.C0BPacketEntityAction;
import net.minecraft.network.play.client.C0FPacketConfirmTransaction;
import net.minecraft.network.play.server.S00PacketKeepAlive;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.network.play.server.S03PacketTimeUpdate;
import net.minecraft.network.play.server.S04PacketEntityEquipment;
import net.minecraft.network.play.server.S06PacketUpdateHealth;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.network.play.server.S0CPacketSpawnPlayer;
import net.minecraft.network.play.server.S0EPacketSpawnObject;
import net.minecraft.network.play.server.S0FPacketSpawnMob;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.network.play.server.S13PacketDestroyEntities;
import net.minecraft.network.play.server.S14PacketEntity;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.network.play.server.S19PacketEntityHeadLook;
import net.minecraft.network.play.server.S19PacketEntityStatus;
import net.minecraft.network.play.server.S1BPacketEntityAttach;
import net.minecraft.network.play.server.S1CPacketEntityMetadata;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.network.play.server.S20PacketEntityProperties;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.network.play.server.S22PacketMultiBlockChange;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.network.play.server.S28PacketEffect;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.network.play.server.S32PacketConfirmTransaction;
import net.minecraft.network.play.server.S33PacketUpdateSign;
import net.minecraft.network.play.server.S38PacketPlayerListItem;
import net.minecraft.network.play.server.S3BPacketScoreboardObjective;
import net.minecraft.network.play.server.S3CPacketUpdateScore;
import net.minecraft.network.play.server.S3EPacketTeams;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010!\u001a\u0004\u0018\u00010\u00192\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00162\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J'\u0010#\u001a\u0004\u0018\u00010\u001f2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010%\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u0016H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020'H\u0007\u00a2\u0006\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0016\u0010-\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010,R*\u00100\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160/0.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/test/PacketTest;", "", "<init>", "()V", "", "", "args", "", "command", "([Ljava/lang/String;)V", "", "id", "sendEntityPacketData", "(I)V", "toggle", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;", "event", "onSendPacket", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketSentEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onPacketReceive", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lnet/minecraft/network/Packet;", "print", "(Lnet/minecraft/network/Packet;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "getDistance", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "packet", "Lnet/minecraft/entity/Entity;", "entity", "getLocation", "(Lnet/minecraft/network/Packet;Lnet/minecraft/entity/Entity;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "getEntity", "(Lnet/minecraft/network/Packet;Ljava/lang/Integer;)Lnet/minecraft/entity/Entity;", "getEntityId", "(Lnet/minecraft/network/Packet;)Ljava/lang/Integer;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "enabled", "Z", "full", "", "", "entityMap", "Ljava/util/Map;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPacketTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketTest.kt\nat/hannibal2/skyhanni/test/PacketTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1863#2,2:340\n13367#3,2:342\n1#4:344\n*S KotlinDebug\n*F\n+ 1 PacketTest.kt\nat/hannibal2/skyhanni/test/PacketTest\n*L\n95#1:340,2\n136#1:342,2\n*E\n"})
public final class PacketTest {
    @NotNull
    public static final PacketTest INSTANCE = new PacketTest();
    private static boolean enabled;
    private static boolean full;
    @NotNull
    private static final Map<Integer, List<Packet<?>>> entityMap;

    private PacketTest() {
    }

    private final void command(String[] args2) {
        if (args2.length == 1 && NumberUtil.INSTANCE.isInt(args2[0])) {
            this.sendEntityPacketData(Integer.parseInt(args2[0]));
            return;
        }
        if (args2.length == 1 && (Intrinsics.areEqual(args2[0], "full") || Intrinsics.areEqual(args2[0], "all"))) {
            full = !full;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Packet test full: " + full, false, null, false, false, null, 62, null);
            return;
        }
        this.toggle();
    }

    private final void sendEntityPacketData(int id) {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Packet Entity Data: " + id, false, null, false, false, null, 62, null);
        List<Packet<?>> list = entityMap.get(id);
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Packet it = (Packet)element$iv;
                boolean bl = false;
                INSTANCE.print(it);
            }
        }
        System.out.println((Object)"End of Data");
    }

    private final void toggle() {
        enabled = !enabled;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Packet test: " + enabled, false, null, false, false, null, 62, null);
    }

    @HandleEvent
    public final void onSendPacket(@NotNull PacketSentEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!enabled) {
            return;
        }
        Packet<?> packet = event2.getPacket();
        String packetName = packet.getClass().getSimpleName();
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C00PacketKeepAlive.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C0FPacketConfirmTransaction.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C03PacketPlayer.C04PacketPlayerPosition.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C09PacketHeldItemChange.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C03PacketPlayer.C06PacketPlayerPosLook.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C0BPacketEntityAction.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C03PacketPlayer.C05PacketPlayerLook.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C03PacketPlayer.class).getSimpleName())) {
            return;
        }
        System.out.println((Object)("Send: [" + packetName + ']'));
    }

    @HandleEvent(priority=1, receiveCancelled=true)
    public final void onPacketReceive(@NotNull PacketReceivedEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!enabled) {
            return;
        }
        Packet<?> packet = event2.getPacket();
        this.print(packet);
        if (packet instanceof S13PacketDestroyEntities) {
            int[] nArray = ((S13PacketDestroyEntities)packet).func_149098_c();
            Intrinsics.checkNotNullExpressionValue(nArray, "getEntityIDs(...)");
            int[] $this$forEach$iv = nArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                entityMap.getOrDefault(it, new ArrayList()).add(packet);
            }
        } else {
            Integer n = this.getEntityId(packet);
            if (n == null) {
                return;
            }
            int id = n;
            entityMap.getOrDefault(id, new ArrayList()).add(packet);
        }
    }

    private final void print(Packet<?> $this$print) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        String packetName = $this$print.getClass().getSimpleName();
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S00PacketKeepAlive.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(C00PacketKeepAlive.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S32PacketConfirmTransaction.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S3BPacketScoreboardObjective.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S3EPacketTeams.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S38PacketPlayerListItem.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S3CPacketUpdateScore.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S1FPacketSetExperience.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S06PacketUpdateHealth.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S33PacketUpdateSign.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S03PacketTimeUpdate.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S21PacketChunkData.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S22PacketMultiBlockChange.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S23PacketBlockChange.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S02PacketChat.class).getSimpleName())) {
            return;
        }
        if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S29PacketSoundEffect.class).getSimpleName())) {
            return;
        }
        if (!full && Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S2APacketParticles.class).getSimpleName())) {
            return;
        }
        if ($this$print instanceof S13PacketDestroyEntities) {
            StringBuilder stringBuilder3 = new StringBuilder().append("Receive: [").append(packetName).append("] with IDs: ");
            int[] nArray = ((S13PacketDestroyEntities)$this$print).func_149098_c();
            Intrinsics.checkNotNullExpressionValue(nArray, "getEntityIDs(...)");
            System.out.println((Object)stringBuilder3.append(ArraysKt.joinToString$default(nArray, (CharSequence)", ", null, null, 0, null, null, 62, null)).toString());
            return;
        }
        if (!full) {
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S18PacketEntityTeleport.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S04PacketEntityEquipment.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S14PacketEntity.S15PacketEntityRelMove.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S14PacketEntity.S17PacketEntityLookMove.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S19PacketEntityHeadLook.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S14PacketEntity.S16PacketEntityLook.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S12PacketEntityVelocity.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S1CPacketEntityMetadata.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S20PacketEntityProperties.class).getSimpleName())) {
                return;
            }
            if (Intrinsics.areEqual(packetName, Reflection.getOrCreateKotlinClass(S0BPacketAnimation.class).getSimpleName())) {
                return;
            }
        }
        StringBuilder $this$print_u24lambda_u242 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$print_u24lambda_u242.append("Receive: [" + packetName + ']');
        Integer id = INSTANCE.getEntityId($this$print);
        if (id != null) {
            $this$print_u24lambda_u242.append(" ID: " + id);
        }
        Entity entity = INSTANCE.getEntity($this$print, id);
        double distance = INSTANCE.getDistance(INSTANCE.getLocation($this$print, entity));
        if (entity != null) {
            if (MinecraftCompat.INSTANCE.isLocalPlayer(entity)) {
                $this$print_u24lambda_u242.append(" own");
            } else {
                stringBuilder = $this$print_u24lambda_u242.append(" distance: " + distance + " other");
            }
        } else if (id != null) {
            stringBuilder = $this$print_u24lambda_u242.append(" entity is null.");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String it = string;
        boolean bl2 = false;
        System.out.println((Object)it);
    }

    private final double getDistance(LorenzVec location) {
        double d;
        LorenzVec lorenzVec = location;
        if (lorenzVec != null) {
            double d2 = LocationUtils.INSTANCE.distanceToPlayer(lorenzVec);
            d = NumberUtil.INSTANCE.roundTo(d2, 1);
        } else {
            d = 0.0;
        }
        return d;
    }

    private final LorenzVec getLocation(Packet<?> packet, Entity entity) {
        if (packet instanceof S2APacketParticles) {
            return new LorenzVec(((S2APacketParticles)packet).func_149220_d(), ((S2APacketParticles)packet).func_149226_e(), ((S2APacketParticles)packet).func_149225_f());
        }
        if (packet instanceof S0CPacketSpawnPlayer) {
            return new LorenzVec(((S0CPacketSpawnPlayer)packet).func_148942_f(), ((S0CPacketSpawnPlayer)packet).func_148949_g(), ((S0CPacketSpawnPlayer)packet).func_148946_h());
        }
        if (packet instanceof S0EPacketSpawnObject) {
            return new LorenzVec(((S0EPacketSpawnObject)packet).func_148997_d(), ((S0EPacketSpawnObject)packet).func_148998_e(), ((S0EPacketSpawnObject)packet).func_148994_f());
        }
        if (packet instanceof S0FPacketSpawnMob) {
            return new LorenzVec(((S0FPacketSpawnMob)packet).func_149023_f(), ((S0FPacketSpawnMob)packet).func_149034_g(), ((S0FPacketSpawnMob)packet).func_149029_h());
        }
        if (packet instanceof C03PacketPlayer) {
            return PacketCompatKt.getLocation((C03PacketPlayer)packet);
        }
        if (packet instanceof S28PacketEffect) {
            BlockPos blockPos = ((S28PacketEffect)packet).func_179746_d();
            Intrinsics.checkNotNullExpressionValue(blockPos, "getSoundPos(...)");
            return LorenzVecKt.toLorenzVec(blockPos);
        }
        if (entity != null) {
            return LorenzVecKt.getLorenzVec(entity);
        }
        return null;
    }

    private final Entity getEntity(Packet<?> packet, Integer id) {
        WorldClient world = MinecraftCompat.INSTANCE.getLocalWorld();
        if (packet instanceof S14PacketEntity) {
            return ((S14PacketEntity)packet).func_149065_a((World)world);
        }
        if (packet instanceof S19PacketEntityHeadLook) {
            return ((S19PacketEntityHeadLook)packet).func_149381_a((World)world);
        }
        if (packet instanceof S19PacketEntityStatus) {
            return ((S19PacketEntityStatus)packet).func_149161_a((World)world);
        }
        if (id != null) {
            return EntityUtils.INSTANCE.getEntityByID(id);
        }
        return null;
    }

    private final Integer getEntityId(Packet<?> $this$getEntityId) {
        Object object;
        try {
            Integer n;
            object = $this$getEntityId;
            if (object instanceof S1CPacketEntityMetadata) {
                n = ((S1CPacketEntityMetadata)$this$getEntityId).func_149375_d();
            } else if (object instanceof S20PacketEntityProperties) {
                n = ((S20PacketEntityProperties)$this$getEntityId).func_149442_c();
            } else if (object instanceof S04PacketEntityEquipment) {
                n = ((S04PacketEntityEquipment)$this$getEntityId).func_149389_d();
            } else if (object instanceof S12PacketEntityVelocity) {
                n = ((S12PacketEntityVelocity)$this$getEntityId).func_149412_c();
            } else if (object instanceof S1BPacketEntityAttach) {
                n = ((S1BPacketEntityAttach)$this$getEntityId).func_149403_d();
            } else if (object instanceof S0BPacketAnimation) {
                n = ((S0BPacketAnimation)$this$getEntityId).func_148978_c();
            } else if (object instanceof S18PacketEntityTeleport) {
                n = ((S18PacketEntityTeleport)$this$getEntityId).func_149451_c();
            } else if (object instanceof S1DPacketEntityEffect) {
                n = ((S1DPacketEntityEffect)$this$getEntityId).func_149426_d();
            } else if (object instanceof S0CPacketSpawnPlayer) {
                n = ((S0CPacketSpawnPlayer)$this$getEntityId).func_148943_d();
            } else if (object instanceof S0FPacketSpawnMob) {
                n = ((S0FPacketSpawnMob)$this$getEntityId).func_149024_d();
            } else if (object instanceof S0EPacketSpawnObject) {
                n = ((S0EPacketSpawnObject)$this$getEntityId).func_149001_c();
            } else if (object instanceof S19PacketEntityHeadLook) {
                Field field = $this$getEntityId.getClass().getDeclaredField("entityId");
                Intrinsics.checkNotNullExpressionValue(field, "getDeclaredField(...)");
                Object object2 = ReflectionUtils.INSTANCE.makeAccessible(field).get($this$getEntityId);
                Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Int");
                n = (Integer)object2;
            } else if (object instanceof S19PacketEntityStatus) {
                Field field = $this$getEntityId.getClass().getDeclaredField("entityId");
                Intrinsics.checkNotNullExpressionValue(field, "getDeclaredField(...)");
                Object object3 = ReflectionUtils.INSTANCE.makeAccessible(field).get($this$getEntityId);
                Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Int");
                n = (Integer)object3;
            } else {
                n = null;
            }
            object = n;
        }
        catch (NoSuchFieldException e) {
            object = null;
        }
        return object;
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.register("shtestpacket", PacketTest::onCommandRegistration$lambda$5);
    }

    private static final Unit onCommandRegistration$lambda$5$lambda$4(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.command(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Logs incoming and outgoing packets to the console");
        $this$register.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$register.callback(PacketTest::onCommandRegistration$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    static {
        entityMap = new LinkedHashMap();
    }
}

