/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ%\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\bJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bJ\u0013\u0010\u0016\u001a\u00020\n*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\bJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/utils/ComputerEnvDebug;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "launcher", "", "firstStack", "Lkotlin/Pair;", "", "findLauncher", "(Ljava/lang/String;)Lkotlin/Pair;", "getFirstStack", "()Ljava/lang/String;", "java", "os", "ram", "", "formatGB", "(D)Ljava/lang/String;", "uptime", "Lkotlin/time/Duration;", "getUptime-UwyO8pc", "()J", "getUptime", "performanceMods", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nComputerEnvDebug.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputerEnvDebug.kt\nat/hannibal2/skyhanni/utils/ComputerEnvDebug\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n8#2:279\n1#3:280\n*S KotlinDebug\n*F\n+ 1 ComputerEnvDebug.kt\nat/hannibal2/skyhanni/utils/ComputerEnvDebug\n*L\n100#1:279\n100#1:280\n*E\n"})
public final class ComputerEnvDebug {
    @NotNull
    public static final ComputerEnvDebug INSTANCE = new ComputerEnvDebug();

    private ComputerEnvDebug() {
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        this.os(event2);
        this.java(event2);
        this.launcher(event2);
        this.ram(event2);
        this.uptime(event2);
        this.performanceMods(event2);
    }

    private final void launcher(DebugDataCollectEvent event2) {
        event2.title("Computer Minecraft Launcher");
        String string = this.getFirstStack();
        if (string == null) {
            ComputerEnvDebug $this$launcher_u24lambda_u240 = this;
            boolean bl = false;
            event2.addData("Could not load data!");
            return;
        }
        String firstStack = string;
        Pair<String, Boolean> pair = this.findLauncher(firstStack);
        String launcher = pair.component1();
        boolean relevant = pair.component2();
        if (launcher != null) {
            String it = launcher;
            boolean bl = false;
            if (relevant) {
                event2.addData(it);
            } else {
                event2.addIrrelevant(it);
            }
            return;
        }
        event2.addData(arg_0 -> ComputerEnvDebug.launcher$lambda$2(firstStack, arg_0));
    }

    private final Pair<String, Boolean> findLauncher(String firstStack) {
        if (StringsKt.contains$default((CharSequence)firstStack, "net.fabricmc.devlaunchinjector.Main.main", false, 2, null)) {
            return new Pair<String, Boolean>("Dev Env", false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, "net.minecraft.launchwrapper.Launch.main", false, 2, null)) {
            return new Pair<String, Boolean>("Vanilla Launcher", false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, "org.prismlauncher.EntryPoint.main", false, 2, null)) {
            return new Pair<String, Boolean>("Prism", false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, "org.multimc.EntryPoint.main", false, 2, null)) {
            return new Pair<String, Boolean>("MultiMC", false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, "net.digitalingot.vendor.", false, 2, null) || StringsKt.contains$default((CharSequence)firstStack, "net.digitalingot.rustextension.", false, 2, null)) {
            return new Pair<String, Boolean>("Feather Client", true);
        }
        return new Pair<Object, Boolean>(null, true);
    }

    private final String getFirstStack() {
        String string;
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
            string = ((StackTraceElement)ArraysKt.last((Object[])stackTraceElementArray)).toString();
        }
        catch (Exception e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Failed loading current thread stack trace info", new Pair[0], false, false, false, 56, null);
            string = null;
        }
        String firstStack = string;
        return firstStack;
    }

    /*
     * WARNING - void declaration
     */
    private final void java(DebugDataCollectEvent event2) {
        void $this$matchMatcher$iv;
        if (!PlatformUtils.INSTANCE.getIS_LEGACY()) {
            return;
        }
        event2.title("Computer Java Version");
        String version = System.getProperty("java.version");
        Object object = "1\\.8\\.0_(?<update>.*)";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        Pattern pattern2 = pattern;
        object = RegexUtils.INSTANCE;
        Pattern pattern3 = pattern2;
        Intrinsics.checkNotNull(version);
        String text$iv = version;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$java_u24lambda_u245 = it$iv;
            boolean bl2 = false;
            String string = $this$java_u24lambda_u245.group("update");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            Integer n2 = StringsKt.toIntOrNull(string);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                boolean devEnvironment = PlatformUtils.INSTANCE.isDevEnvironment();
                if (it < 300 && !devEnvironment) {
                    event2.addData(arg_0 -> ComputerEnvDebug.java$lambda$5$lambda$4$lambda$3(it, arg_0));
                } else if (devEnvironment) {
                    event2.addIrrelevant("Update version: " + it + " (dev env)");
                } else {
                    event2.addIrrelevant("New update: " + it);
                }
                return;
            }
        }
        event2.addData("Unknown java version: '" + version + '\'');
    }

    private final void os(DebugDataCollectEvent event2) {
        event2.title("Computer Operating System");
        OSUtils.OperatingSystem osType = OSUtils.INSTANCE.getOperatingSystem();
        String exactName = OSUtils.INSTANCE.getOperatingSystemRaw();
        if (osType != OSUtils.OperatingSystem.UNKNOWN) {
            event2.addIrrelevant(arg_0 -> ComputerEnvDebug.os$lambda$6(osType, exactName, arg_0));
        } else {
            event2.addData("Unknown OS: '" + exactName + '\'');
        }
    }

    private final void ram(DebugDataCollectEvent event2) {
        event2.title("Computer RAM");
        Runtime runtime = Runtime.getRuntime();
        List text = new ArrayList();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        int allocatedPercentage = (int)((double)totalMemory / (double)maxMemory * (double)100);
        int usedPercentage = (int)((double)usedMemory / (double)maxMemory * (double)100);
        double totalMemoryGB = (double)totalMemory / (double)0x40000000;
        double maxMemoryGB = (double)maxMemory / (double)0x40000000;
        double usedMemoryGB = (double)usedMemory / (double)0x40000000;
        text.add("Minecraft Memory: " + usedPercentage + "% " + this.formatGB(usedMemoryGB) + '/' + this.formatGB(maxMemoryGB) + " GB");
        text.add("Minecraft Allocated: " + allocatedPercentage + "% " + this.formatGB(totalMemoryGB) + " GB");
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        Intrinsics.checkNotNull(osBean, "null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        long totalPhysicalMemory = ((OperatingSystemMXBean)osBean).getTotalPhysicalMemorySize();
        long freePhysicalMemory = ((OperatingSystemMXBean)osBean).getFreePhysicalMemorySize();
        long usedPhysicalMemory = totalPhysicalMemory - freePhysicalMemory;
        double totalPhysicalGB = (double)totalPhysicalMemory / (double)0x40000000;
        double usedPhysicalGB = (double)usedPhysicalMemory / (double)0x40000000;
        int usedPhysicalPercentage = MathKt.roundToInt((double)usedPhysicalMemory / (double)totalPhysicalMemory * (double)100);
        text.add("System Memory: " + usedPhysicalPercentage + "% " + this.formatGB(usedPhysicalGB) + '/' + this.formatGB(totalPhysicalGB) + " GB");
        boolean important = false;
        if (maxMemoryGB < 3.5) {
            text.add("");
            text.add("Minecraft has less than 3.5 GB of RAM! Change this to 4-6 GB! (Currently at " + this.formatGB(maxMemoryGB) + " GB RAM)");
            important = true;
        } else if (maxMemoryGB > 6.0) {
            text.add("");
            text.add("Minecraft has more than 6 GB of RAM! Change this to 4-6 GB! (Currently at " + this.formatGB(maxMemoryGB) + " GB RAM)");
            important = true;
        }
        if (usedPhysicalPercentage > 90) {
            text.add("");
            text.add("The computer uses more than 90% of system memory. Maybe close background apps! (" + usedPhysicalPercentage + "% used)");
            important = true;
        }
        if (important) {
            event2.addData(text);
        } else {
            event2.addIrrelevant(text);
        }
    }

    private final String formatGB(double $this$formatGB) {
        return NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo($this$formatGB, 1));
    }

    private final void uptime(DebugDataCollectEvent event2) {
        event2.title("Minecraft Uptime");
        long uptime = this.getUptime-UwyO8pc();
        String info = "The game is running for " + TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, uptime, null, false, false, 0, false, false, 63, null);
        if (Duration.compareTo-LRDsOJo(uptime, DurationKt.toDuration(5, DurationUnit.HOURS)) > 0) {
            event2.addData(arg_0 -> ComputerEnvDebug.uptime$lambda$7(info, arg_0));
        } else {
            event2.addIrrelevant(info);
        }
    }

    private final long getUptime-UwyO8pc() {
        return DurationKt.toDuration(ManagementFactory.getRuntimeMXBean().getUptime(), DurationUnit.MILLISECONDS);
    }

    private final void performanceMods(DebugDataCollectEvent event2) {
        if (PlatformUtils.INSTANCE.isDevEnvironment()) {
            return;
        }
        event2.title("Performance Mods");
        boolean hasOptifine = FMLClientHandler.instance().hasOptifine();
        boolean hasPatcher = Loader.isModLoaded((String)"patcher");
        if (!hasOptifine || !hasPatcher) {
            event2.addData(arg_0 -> ComputerEnvDebug.performanceMods$lambda$8(hasOptifine, hasPatcher, arg_0));
        } else {
            event2.addIrrelevant(ComputerEnvDebug::performanceMods$lambda$9);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.register("shuptime", ComputerEnvDebug::onCommandRegistration$lambda$11);
    }

    private static final Unit launcher$lambda$2(String $firstStack, List $this$addData) {
        Intrinsics.checkNotNullParameter($firstStack, "$firstStack");
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Unknown launcher!");
        String launcherBrand = System.getProperty("minecraft.launcher.brand");
        $this$addData.add("System property of 'minecraft.launcher.brand': '" + launcherBrand + '\'');
        $this$addData.add("firstStack: '" + $firstStack + '\'');
        return Unit.INSTANCE;
    }

    private static final Unit java$lambda$5$lambda$4$lambda$3(int $it, List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Old java version: " + $it);
        $this$addData.add("Update to a newer version if you have performance issues.");
        $this$addData.add("For more infos: https://github.com/hannibal002/SkyHanni/blob/beta/docs/update_java.md");
        return Unit.INSTANCE;
    }

    private static final Unit os$lambda$6(OSUtils.OperatingSystem $osType, String $exactName, List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$osType, "$osType");
        Intrinsics.checkNotNullParameter($exactName, "$exactName");
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        $this$addIrrelevant.add("OS type: " + (Object)((Object)$osType));
        $this$addIrrelevant.add("Exact name: " + $exactName);
        return Unit.INSTANCE;
    }

    private static final Unit uptime$lambda$7(String $info, List $this$addData) {
        Intrinsics.checkNotNullParameter($info, "$info");
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("The game runs for more than 5 hours, memory leaks may accumulate to dangerous levels.");
        $this$addData.add($info);
        return Unit.INSTANCE;
    }

    private static final Unit performanceMods$lambda$8(boolean $hasOptifine, boolean $hasPatcher, List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Optifine is " + ($hasOptifine ? "" : "not") + " installed");
        $this$addData.add("Patcher is " + ($hasPatcher ? "" : "not") + " installed");
        $this$addData.add("These mods greatly improve performance and are almost required to play 1.8.9 Minecraft");
        if (!$hasOptifine) {
            $this$addData.add("https://optifine.net/downloadx?f=preview_OptiFine_1.8.9_HD_U_M6_pre2.jar");
        }
        if (!$hasPatcher) {
            $this$addData.add("https://modrinth.com/mod/patcher");
        }
        return Unit.INSTANCE;
    }

    private static final Unit performanceMods$lambda$9(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        $this$addIrrelevant.add("Optifine and Patcher are installed");
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$11$lambda$10(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        long uptime = INSTANCE.getUptime-UwyO8pc();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Minecraft is running for \u00a7b" + TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, uptime, null, false, false, 0, false, false, 63, null) + "\u00a7e.", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$11(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Shows the time since the start of minecraft");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback(ComputerEnvDebug::onCommandRegistration$lambda$11$lambda$10);
        return Unit.INSTANCE;
    }
}

