/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.model.TextInput;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiScreenElementWrapper;
import at.hannibal2.skyhanni.events.inventory.AttemptedInventoryCloseEvent;
import at.hannibal2.skyhanni.events.minecraft.KeyDownEvent;
import at.hannibal2.skyhanni.events.minecraft.KeyPressEvent;
import at.hannibal2.skyhanni.events.minecraft.KeyUpEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.compat.MouseCompat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000289B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0006J\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0006J\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0006J\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0006J\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0006J\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0006J\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0006J\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010\u0003J\u0017\u0010\"\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b$\u0010#J\u0017\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b%\u0010#J\u0011\u0010'\u001a\u00020\u0004*\u00020&\u00a2\u0006\u0004\b'\u0010(J\u0011\u0010)\u001a\u00020\u0004*\u00020\u000f\u00a2\u0006\u0004\b)\u0010\u0012J\u0011\u0010*\u001a\u00020\u0004*\u00020\u000f\u00a2\u0006\u0004\b*\u0010\u0012J\u0015\u0010+\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u000f\u00a2\u0006\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b/\u0010.R\u0014\u00100\u001a\u00020\u000f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b0\u0010.R\u0016\u00101\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010.R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R \u00106\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0004058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/utils/KeyboardManager;", "", "<init>", "()V", "", "isCommandKeyDown", "()Z", "isMenuKeyDown", "isControlKeyDown", "isDeleteWordDown", "isDeleteLineDown", "isShiftKeyDown", "isPastingKeysDown", "isCopyingKeysDown", "isModifierKeyDown", "", "keycode", "checkIsInventoryClosure", "(I)Z", "", "getModifierKeyName", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/KeyboardManager$EventKey;", "getKeyboardEventKey", "()Lat/hannibal2/skyhanni/utils/KeyboardManager$EventKey;", "getMouseEventKey", "key", "", "char", "getSyntheticKeyboardKeyCode", "(IC)I", "", "onTick", "keyCode", "postKeyPressEvent", "(I)V", "postKeyDownEvent", "postKeyUpEvent", "Lnet/minecraft/client/settings/KeyBinding;", "isActive", "(Lnet/minecraft/client/settings/KeyBinding;)Z", "isKeyHeld", "isKeyClicked", "getKeyName", "(I)Ljava/lang/String;", "LEFT_MOUSE", "I", "RIGHT_MOUSE", "MIDDLE_MOUSE", "lastClickedMouseButton", "", "pressedKeys", "Ljava/util/Set;", "", "lockedKeys", "Ljava/util/Map;", "EventKey", "WasdInputMatrix", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nKeyboardManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyboardManager.kt\nat/hannibal2/skyhanni/utils/KeyboardManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
public final class KeyboardManager {
    @NotNull
    public static final KeyboardManager INSTANCE = new KeyboardManager();
    public static final int LEFT_MOUSE = -100;
    public static final int RIGHT_MOUSE = -99;
    public static final int MIDDLE_MOUSE = -98;
    private static int lastClickedMouseButton = -1;
    @NotNull
    private static final Set<Integer> pressedKeys = new LinkedHashSet();
    @NotNull
    private static final Map<Integer, Boolean> lockedKeys = new LinkedHashMap();

    private KeyboardManager() {
    }

    private final boolean isCommandKeyDown() {
        return this.isKeyHeld(219) || this.isKeyHeld(220);
    }

    public final boolean isMenuKeyDown() {
        return this.isKeyHeld(56) || this.isKeyHeld(184);
    }

    public final boolean isControlKeyDown() {
        return this.isKeyHeld(29) || this.isKeyHeld(157);
    }

    public final boolean isDeleteWordDown() {
        return this.isKeyHeld(14) && (SystemUtils.IS_OS_MAC ? this.isMenuKeyDown() : this.isControlKeyDown());
    }

    public final boolean isDeleteLineDown() {
        return this.isKeyHeld(14) && (SystemUtils.IS_OS_MAC ? this.isCommandKeyDown() : this.isControlKeyDown() && this.isShiftKeyDown());
    }

    public final boolean isShiftKeyDown() {
        return this.isKeyHeld(42) || this.isKeyHeld(54);
    }

    public final boolean isPastingKeysDown() {
        return this.isModifierKeyDown() && this.isKeyHeld(47);
    }

    public final boolean isCopyingKeysDown() {
        return this.isModifierKeyDown() && this.isKeyHeld(46);
    }

    public final boolean isModifierKeyDown() {
        return SystemUtils.IS_OS_MAC ? this.isCommandKeyDown() : this.isControlKeyDown();
    }

    @JvmStatic
    public static final boolean checkIsInventoryClosure(int keycode) {
        boolean isClose;
        if (INSTANCE.isShiftKeyDown()) {
            return false;
        }
        boolean bl = isClose = keycode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i() || keycode == 1;
        if (!isClose) {
            return false;
        }
        return new AttemptedInventoryCloseEvent().post();
    }

    @NotNull
    public final String getModifierKeyName() {
        return SystemUtils.IS_OS_MAC ? "Command" : "Control";
    }

    private final EventKey getKeyboardEventKey() {
        int keyCode = this.getSyntheticKeyboardKeyCode(Keyboard.getEventKey(), Keyboard.getEventCharacter());
        if (keyCode == 0) {
            return null;
        }
        boolean keyState = Keyboard.getEventKeyState();
        return new EventKey(keyCode, keyState);
    }

    private final EventKey getMouseEventKey() {
        if (MouseCompat.INSTANCE.getEventButton() != -1) {
            int keyCode;
            lastClickedMouseButton = keyCode = MouseCompat.INSTANCE.getEventButton() - 100;
            return new EventKey(keyCode, MouseCompat.INSTANCE.getEventButtonState());
        }
        if (lastClickedMouseButton != -1 && MouseCompat.INSTANCE.getEventButton() == -1) {
            Mouse.poll();
            int originalButton = lastClickedMouseButton + 100;
            if (Mouse.isButtonDown((int)originalButton)) {
                return new EventKey(lastClickedMouseButton, true);
            }
            lastClickedMouseButton = -1;
        }
        return null;
    }

    private final int getSyntheticKeyboardKeyCode(int key, char c) {
        return key == 0 ? c + 256 : key;
    }

    @HandleEvent(priority=2)
    public final void onTick() {
        EventKey it;
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        boolean isConfigScreen = currentScreen instanceof GuiScreenElementWrapper;
        if (isConfigScreen || currentScreen instanceof GuiChat) {
            return;
        }
        Iterator iterator2 = CollectionsKt.createListBuilder();
        List<EventKey> $this$onTick_u24lambda_u242 = iterator2;
        boolean bl = false;
        EventKey eventKey = INSTANCE.getKeyboardEventKey();
        if (eventKey != null) {
            it = eventKey;
            boolean bl2 = false;
            $this$onTick_u24lambda_u242.add(it);
        }
        EventKey eventKey2 = INSTANCE.getMouseEventKey();
        if (eventKey2 != null) {
            it = eventKey2;
            boolean bl3 = false;
            $this$onTick_u24lambda_u242.add(it);
        }
        List<EventKey> keys2 = CollectionsKt.build(iterator2);
        for (EventKey key : keys2) {
            if (!key.getPressed() || pressedKeys.contains(key.getKeyCode())) continue;
            this.postKeyDownEvent(key.getKeyCode());
            pressedKeys.add(key.getKeyCode());
        }
        iterator2 = CollectionsKt.toList((Iterable)pressedKeys).iterator();
        while (iterator2.hasNext()) {
            boolean isDown;
            int keyCode = ((Number)iterator2.next()).intValue();
            boolean bl2 = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : (isDown = keyCode < 256 ? Keyboard.isKeyDown((int)keyCode) : false);
            if (isDown) {
                this.postKeyPressEvent(keyCode);
                continue;
            }
            this.postKeyUpEvent(keyCode);
            pressedKeys.remove(keyCode);
        }
    }

    private final void postKeyPressEvent(int keyCode) {
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(50, DurationUnit.MILLISECONDS), () -> KeyboardManager.postKeyPressEvent$lambda$3(keyCode));
    }

    private final void postKeyDownEvent(int keyCode) {
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(50, DurationUnit.MILLISECONDS), () -> KeyboardManager.postKeyDownEvent$lambda$4(keyCode));
    }

    private final void postKeyUpEvent(int keyCode) {
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(50, DurationUnit.MILLISECONDS), () -> KeyboardManager.postKeyUpEvent$lambda$5(keyCode));
    }

    public final boolean isActive(@NotNull KeyBinding $this$isActive) {
        Intrinsics.checkNotNullParameter($this$isActive, "<this>");
        if (!Keyboard.isCreated()) {
            return false;
        }
        try {
            if (this.isKeyHeld($this$isActive.func_151463_i())) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("keyCode", $this$isActive.func_151463_i())};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while checking if a key is pressed.", pairArray, false, false, false, 56, null);
            return false;
        }
        return $this$isActive.func_151470_d() || $this$isActive.func_151468_f();
    }

    public final boolean isKeyHeld(int $this$isKeyHeld) {
        boolean bl;
        if ($this$isKeyHeld == 0) {
            bl = false;
        } else if ($this$isKeyHeld < 0) {
            bl = MouseCompat.INSTANCE.isButtonDown($this$isKeyHeld + 100);
        } else if ($this$isKeyHeld >= 256) {
            int pressedKey;
            int n = pressedKey = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
            bl = Keyboard.getEventKeyState() && $this$isKeyHeld == pressedKey;
        } else {
            bl = Keyboard.isKeyDown((int)$this$isKeyHeld);
        }
        return bl;
    }

    public final boolean isKeyClicked(int $this$isKeyClicked) {
        boolean bl;
        if (this.isKeyHeld($this$isKeyClicked)) {
            if (!Intrinsics.areEqual(lockedKeys.get($this$isKeyClicked), true)) {
                Integer n = $this$isKeyClicked;
                lockedKeys.put(n, true);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            Integer n = $this$isKeyClicked;
            lockedKeys.put(n, false);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getKeyName(int keyCode) {
        String string = IMinecraft.INSTANCE.getKeyName(keyCode).getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return string;
    }

    private static final Unit postKeyPressEvent$lambda$3(int $keyCode) {
        if (TextInput.Companion.isActive()) {
            return Unit.INSTANCE;
        }
        new KeyPressEvent($keyCode).post();
        return Unit.INSTANCE;
    }

    private static final Unit postKeyDownEvent$lambda$4(int $keyCode) {
        if (TextInput.Companion.isActive()) {
            return Unit.INSTANCE;
        }
        new KeyDownEvent($keyCode).post();
        return Unit.INSTANCE;
    }

    private static final Unit postKeyUpEvent$lambda$5(int $keyCode) {
        if (TextInput.Companion.isActive()) {
            return Unit.INSTANCE;
        }
        new KeyUpEvent($keyCode).post();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/utils/KeyboardManager$EventKey;", "", "", "keyCode", "", "pressed", "<init>", "(IZ)V", "component1", "()I", "component2", "()Z", "copy", "(IZ)Lat/hannibal2/skyhanni/utils/KeyboardManager$EventKey;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getKeyCode", "Z", "getPressed", "1.8.9"})
    private static final class EventKey {
        private final int keyCode;
        private final boolean pressed;

        public EventKey(int keyCode, boolean pressed) {
            this.keyCode = keyCode;
            this.pressed = pressed;
        }

        public final int getKeyCode() {
            return this.keyCode;
        }

        public final boolean getPressed() {
            return this.pressed;
        }

        public final int component1() {
            return this.keyCode;
        }

        public final boolean component2() {
            return this.pressed;
        }

        @NotNull
        public final EventKey copy(int keyCode, boolean pressed) {
            return new EventKey(keyCode, pressed);
        }

        public static /* synthetic */ EventKey copy$default(EventKey eventKey, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = eventKey.keyCode;
            }
            if ((n2 & 2) != 0) {
                bl = eventKey.pressed;
            }
            return eventKey.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "EventKey(keyCode=" + this.keyCode + ", pressed=" + this.pressed + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.keyCode);
            result2 = result2 * 31 + Boolean.hashCode(this.pressed);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EventKey)) {
                return false;
            }
            EventKey eventKey = (EventKey)other;
            if (this.keyCode != eventKey.keyCode) {
                return false;
            }
            return this.pressed == eventKey.pressed;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0018\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/utils/KeyboardManager$WasdInputMatrix;", "", "Lnet/minecraft/client/settings/KeyBinding;", "<init>", "()V", "keyBinding", "", "contains", "(Lnet/minecraft/client/settings/KeyBinding;)Z", "", "iterator", "()Ljava/util/Iterator;", "getW", "()Lnet/minecraft/client/settings/KeyBinding;", "w", "getA", "a", "getS", "s", "getD", "d", "getUp", "up", "getDown", "down", "1.8.9"})
    public static final class WasdInputMatrix
    implements Iterable<KeyBinding>,
    KMappedMarker {
        @NotNull
        public static final WasdInputMatrix INSTANCE = new WasdInputMatrix();

        private WasdInputMatrix() {
        }

        public final boolean contains(@NotNull KeyBinding keyBinding) {
            Intrinsics.checkNotNullParameter(keyBinding, "keyBinding");
            KeyBinding keyBinding2 = keyBinding;
            return Intrinsics.areEqual(keyBinding2, this.getW()) || Intrinsics.areEqual(keyBinding2, this.getA()) || Intrinsics.areEqual(keyBinding2, this.getS()) || Intrinsics.areEqual(keyBinding2, this.getD()) || Intrinsics.areEqual(keyBinding2, this.getUp()) || Intrinsics.areEqual(keyBinding2, this.getDown());
        }

        @NotNull
        public final KeyBinding getW() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74351_w;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getA() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74370_x;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getS() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74368_y;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getD() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74366_z;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getUp() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74314_A;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getDown() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @Override
        @NotNull
        public Iterator<KeyBinding> iterator() {
            return new Iterator<KeyBinding>(){
                private KeyBinding current;
                private boolean finished;
                {
                    this.current = WasdInputMatrix.INSTANCE.getW();
                }

                public final KeyBinding getCurrent() {
                    return this.current;
                }

                public final void setCurrent(KeyBinding keyBinding) {
                    Intrinsics.checkNotNullParameter(keyBinding, "<set-?>");
                    this.current = keyBinding;
                }

                public final boolean getFinished() {
                    return this.finished;
                }

                public final void setFinished(boolean bl) {
                    this.finished = bl;
                }

                public boolean hasNext() {
                    return !this.finished;
                }

                public KeyBinding next() {
                    KeyBinding keyBinding;
                    KeyBinding keyBinding2;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    KeyBinding it = keyBinding2 = this.current;
                    boolean bl = false;
                    KeyBinding keyBinding3 = it;
                    if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getW())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getA();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getA())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getS();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getS())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getD();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getD())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getUp();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getUp())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getDown();
                    } else {
                        this.finished = true;
                        throw new NoSuchElementException();
                    }
                    this.current = keyBinding;
                    return keyBinding2;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
    }
}

