/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.renderables;

import at.hannibal2.skyhanni.utils.compat.MouseCompat;
import at.hannibal2.skyhanni.utils.renderables.ScrollValue;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0018\b&\u0018\u0000 .2\u00020\u0001:\u0002/.B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\rH\u0004\u00a2\u0006\u0004\b\u001b\u0010\u000fJ\u000f\u0010\u001c\u001a\u00020\rH\u0004\u00a2\u0006\u0004\b\u001c\u0010\u000fJ\u0017\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\rH&\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b#\u0010\u0012R\u001a\u0010\b\u001a\u00020\u00078\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010\u0014R\u001c\u0010\t\u001a\u0004\u0018\u00010\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\t\u0010&\u001a\u0004\b'\u0010(R$\u0010-\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00078D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010,\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/ScrollInput;", "", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValue", "", "minValue", "maxValue", "", "velocity", "dragScrollMouseButton", "startValue", "<init>", "(Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;IIDLjava/lang/Integer;Ljava/lang/Double;)V", "", "atMinimum", "()Z", "atMaximum", "asInt", "()I", "asDouble", "()D", "Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$ScrollDirection;", "asDirection", "()Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$ScrollDirection;", "", "coerceInLimit", "()V", "isMouseEventValid", "isPureScrollEvent", "isValid", "update", "(Z)V", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "I", "getMinValue", "getMaxValue", "D", "getVelocity", "Ljava/lang/Integer;", "getDragScrollMouseButton", "()Ljava/lang/Integer;", "value", "getScroll", "setScroll", "(D)V", "scroll", "Companion", "ScrollDirection", "1.8.9"})
public abstract class ScrollInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScrollValue scrollValue;
    private final int minValue;
    private final int maxValue;
    private final double velocity;
    @Nullable
    private final Integer dragScrollMouseButton;

    public ScrollInput(@NotNull ScrollValue scrollValue, int minValue, int maxValue, double velocity, @Nullable Integer dragScrollMouseButton, @Nullable Double startValue) {
        Intrinsics.checkNotNullParameter(scrollValue, "scrollValue");
        this.scrollValue = scrollValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.velocity = velocity;
        this.dragScrollMouseButton = dragScrollMouseButton;
        Double d = startValue;
        this.scrollValue.init(d != null ? d : (double)this.minValue);
        this.coerceInLimit();
    }

    protected final int getMinValue() {
        return this.minValue;
    }

    protected final int getMaxValue() {
        return this.maxValue;
    }

    protected final double getVelocity() {
        return this.velocity;
    }

    @Nullable
    protected final Integer getDragScrollMouseButton() {
        return this.dragScrollMouseButton;
    }

    protected final double getScroll() {
        return this.scrollValue.getValue();
    }

    protected final void setScroll(double value) {
        this.scrollValue.setValue(value);
    }

    public final boolean atMinimum() {
        return this.asInt() == this.minValue;
    }

    public final boolean atMaximum() {
        return this.asInt() == this.maxValue;
    }

    public final int asInt() {
        return (int)this.getScroll();
    }

    public final double asDouble() {
        return this.getScroll();
    }

    @NotNull
    public final ScrollDirection asDirection() {
        return this.getScroll() == 0.0 ? ScrollDirection.NONE : (this.getScroll() > 0.0 ? ScrollDirection.DOWN : ScrollDirection.UP);
    }

    protected final void coerceInLimit() {
        if (this.maxValue < this.minValue) {
            this.setScroll(this.minValue);
        } else {
            this.setScroll(RangesKt.coerceIn(this.getScroll(), (double)this.minValue, (double)this.maxValue));
        }
    }

    protected final boolean isMouseEventValid() {
        return this.scrollValue.isMouseEventValid();
    }

    protected final boolean isPureScrollEvent() {
        return this.scrollValue.isPureScrollEvent();
    }

    public abstract void update(boolean var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$Companion;", "", "<init>", "()V", "Vertical", "PureVertical", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$Companion$PureVertical;", "Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$Companion$Vertical;", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValue", "<init>", "(Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;)V", "", "isValid", "", "update", "(Z)V", "dispose", "()V", "1.8.9"})
        public static final class PureVertical
        extends Vertical {
            public PureVertical(@NotNull ScrollValue scrollValue) {
                Intrinsics.checkNotNullParameter(scrollValue, "scrollValue");
                super(scrollValue, -1, 1, 1.0, null, 0.0);
            }

            public /* synthetic */ PureVertical(ScrollValue scrollValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    scrollValue = new ScrollValue();
                }
                this(scrollValue);
            }

            @Override
            public void update(boolean isValid) {
                this.dispose();
                if (!this.isPureScrollEvent()) {
                    return;
                }
                super.update(isValid);
            }

            public final void dispose() {
                this.setScroll(0.0);
            }

            public PureVertical() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$Companion$Vertical;", "Lat/hannibal2/skyhanni/utils/renderables/ScrollInput;", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValue", "", "minHeight", "maxHeight", "", "velocity", "dragScrollMouseButton", "startValue", "<init>", "(Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;IIDLjava/lang/Integer;Ljava/lang/Double;)V", "", "isValid", "", "update", "(Z)V", "1.8.9"})
        public static class Vertical
        extends ScrollInput {
            public Vertical(@NotNull ScrollValue scrollValue, int minHeight, int maxHeight, double velocity, @Nullable Integer dragScrollMouseButton, @Nullable Double startValue) {
                Intrinsics.checkNotNullParameter(scrollValue, "scrollValue");
                super(scrollValue, minHeight, maxHeight, velocity, dragScrollMouseButton, startValue);
            }

            public /* synthetic */ Vertical(ScrollValue scrollValue, int n, int n2, double d, Integer n3, Double d2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n4 & 0x20) != 0) {
                    d2 = null;
                }
                this(scrollValue, n, n2, d, n3, d2);
            }

            @Override
            public void update(boolean isValid) {
                if (this.getMaxValue() < this.getMinValue()) {
                    return;
                }
                if (!isValid || !this.isMouseEventValid()) {
                    return;
                }
                if (this.getDragScrollMouseButton() != null && MouseCompat.INSTANCE.isButtonDown(this.getDragScrollMouseButton())) {
                    this.setScroll(this.getScroll() + (double)MouseCompat.INSTANCE.getEventDY() * this.getVelocity());
                }
                int deltaWheel = MouseCompat.INSTANCE.getScrollDelta();
                this.setScroll(this.getScroll() + (double)(-RangesKt.coerceIn(deltaWheel, -1, 1)) * 2.5 * this.getVelocity());
                this.coerceInLimit();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/ScrollInput$ScrollDirection;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "UP", "DOWN", "1.8.9"})
    public static final class ScrollDirection
    extends Enum<ScrollDirection> {
        public static final /* enum */ ScrollDirection NONE = new ScrollDirection();
        public static final /* enum */ ScrollDirection UP = new ScrollDirection();
        public static final /* enum */ ScrollDirection DOWN = new ScrollDirection();
        private static final /* synthetic */ ScrollDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScrollDirection[] values() {
            return (ScrollDirection[])$VALUES.clone();
        }

        public static ScrollDirection valueOf(String value) {
            return Enum.valueOf(ScrollDirection.class, value);
        }

        @NotNull
        public static EnumEntries<ScrollDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = scrollDirectionArray = new ScrollDirection[]{ScrollDirection.NONE, ScrollDirection.UP, ScrollDirection.DOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

