/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class ByteBufferInput
extends Input {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferInput() {
    }

    public ByteBufferInput(int bufferSize) {
        this.capacity = bufferSize;
        this.niobuffer = ByteBuffer.allocateDirect(bufferSize);
        this.niobuffer.order(this.byteOrder);
    }

    public ByteBufferInput(byte[] buffer) {
        this.setBuffer(buffer);
    }

    public ByteBufferInput(ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public ByteBufferInput(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public ByteBufferInput(InputStream inputStream, int bufferSize) {
        this(bufferSize);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public ByteOrder order() {
        return this.byteOrder;
    }

    public void order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setBuffer(byte[] bytes) {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(bytes.length);
        directBuffer.put(bytes);
        directBuffer.position(0);
        directBuffer.limit(bytes.length);
        directBuffer.order(this.byteOrder);
        this.setBuffer(directBuffer);
    }

    public void setBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.niobuffer = buffer;
        this.position = buffer.position();
        this.limit = buffer.limit();
        this.capacity = buffer.capacity();
        this.total = 0L;
        this.inputStream = null;
    }

    public void release() {
        this.close();
        UnsafeUtil.releaseBuffer(this.niobuffer);
        this.niobuffer = null;
    }

    public ByteBufferInput(long address, int size) {
        this.setBuffer(UnsafeUtil.getDirectBufferAt(address, size));
    }

    public ByteBuffer getByteBuffer() {
        return this.niobuffer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.rewind();
    }

    public void rewind() {
        super.rewind();
        this.niobuffer.position(0);
    }

    protected int fill(ByteBuffer buffer, int offset, int count2) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            byte[] tmp = new byte[count2];
            int result2 = this.inputStream.read(tmp, 0, count2);
            buffer.position(offset);
            if (result2 >= 0) {
                buffer.put(tmp, 0, result2);
                buffer.position(offset);
            }
            return result2;
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    protected final int require(int required) throws KryoException {
        int count2;
        int remaining = this.limit - this.position;
        if (remaining >= required) {
            return remaining;
        }
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        if (remaining > 0) {
            count2 = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
            if (count2 == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((remaining += count2) >= required) {
                this.limit += count2;
                return remaining;
            }
        }
        this.niobuffer.position(this.position);
        this.niobuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        do {
            if ((count2 = this.fill(this.niobuffer, remaining, this.capacity - remaining)) != -1) continue;
            if (remaining >= required) break;
            throw new KryoException("Buffer underflow.");
        } while ((remaining += count2) < required);
        this.limit = remaining;
        this.niobuffer.position(0);
        return remaining;
    }

    private int optional(int optional) throws KryoException {
        int remaining = this.limit - this.position;
        if (remaining >= optional) {
            return optional;
        }
        optional = Math.min(optional, this.capacity);
        int count2 = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
        if (count2 == -1) {
            return remaining == 0 ? -1 : Math.min(remaining, optional);
        }
        if ((remaining += count2) >= optional) {
            this.limit += count2;
            return optional;
        }
        this.niobuffer.compact();
        this.total += (long)this.position;
        this.position = 0;
        while ((count2 = this.fill(this.niobuffer, remaining, this.capacity - remaining)) != -1 && (remaining += count2) < optional) {
        }
        this.limit = remaining;
        this.niobuffer.position(this.position);
        return remaining == 0 ? -1 : Math.min(remaining, optional);
    }

    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        this.niobuffer.position(this.position);
        ++this.position;
        return this.niobuffer.get() & 0xFF;
    }

    public int read(byte[] bytes) throws KryoException {
        this.niobuffer.position(this.position);
        return this.read(bytes, 0, bytes.length);
    }

    public int read(byte[] bytes, int offset, int count2) throws KryoException {
        this.niobuffer.position(this.position);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int startingCount = count2;
        int copyCount = Math.min(this.limit - this.position, count2);
        do {
            this.niobuffer.get(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = this.optional(count2);
            if (copyCount != -1) continue;
            if (startingCount == count2) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return startingCount - count2;
    }

    public long skip(long count2) throws KryoException {
        int skip;
        for (long remaining = count2; remaining > 0L; remaining -= (long)skip) {
            skip = (int)Math.min(Integer.MAX_VALUE, remaining);
            this.skip(skip);
        }
        return count2;
    }

    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public byte readByte() throws KryoException {
        this.niobuffer.position(this.position);
        this.require(1);
        ++this.position;
        return this.niobuffer.get();
    }

    public int readByteUnsigned() throws KryoException {
        this.require(1);
        ++this.position;
        return this.niobuffer.get() & 0xFF;
    }

    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes, 0, length);
        return bytes;
    }

    public void readBytes(byte[] bytes) throws KryoException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int count2) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            this.niobuffer.get(bytes, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }

    public int readInt() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getInt();
    }

    public int readInt(boolean optimizePositive) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarInt(optimizePositive);
        }
        return this.readInt();
    }

    public int readVarInt(boolean optimizePositive) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 5) {
            return this.readInt_slow(optimizePositive);
        }
        ++this.position;
        byte b = this.niobuffer.get();
        int result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            ++this.position;
            b = this.niobuffer.get();
            result2 |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                ++this.position;
                b = this.niobuffer.get();
                result2 |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    ++this.position;
                    b = this.niobuffer.get();
                    result2 |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        ++this.position;
                        b = this.niobuffer.get();
                        result2 |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    private int readInt_slow(boolean optimizePositive) {
        ++this.position;
        byte b = this.niobuffer.get();
        int result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            this.require(1);
            ++this.position;
            b = this.niobuffer.get();
            result2 |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b = this.niobuffer.get();
                result2 |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b = this.niobuffer.get();
                    result2 |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b = this.niobuffer.get();
                        result2 |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return optimizePositive ? result2 : result2 >>> 1 ^ -(result2 & 1);
    }

    public boolean canReadInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        return p != this.limit;
    }

    public boolean canReadLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int p = this.position;
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        if (p == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(p++) & 0x80) == 0) {
            return true;
        }
        return p != this.limit;
    }

    public String readString() {
        this.niobuffer.position(this.position);
        int available = this.require(1);
        ++this.position;
        byte b = this.niobuffer.get();
        if ((b & 0x80) == 0) {
            return this.readAscii();
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        return new String(this.chars, 0, charCount);
    }

    private int readUtf8Length(int b) {
        int result2 = b & 0x3F;
        if ((b & 0x40) != 0) {
            ++this.position;
            b = this.niobuffer.get();
            result2 |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                ++this.position;
                b = this.niobuffer.get();
                result2 |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    ++this.position;
                    b = this.niobuffer.get();
                    result2 |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        ++this.position;
                        b = this.niobuffer.get();
                        result2 |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result2;
    }

    private int readUtf8Length_slow(int b) {
        int result2 = b & 0x3F;
        if ((b & 0x40) != 0) {
            this.require(1);
            ++this.position;
            b = this.niobuffer.get();
            result2 |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b = this.niobuffer.get();
                result2 |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b = this.niobuffer.get();
                    result2 |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b = this.niobuffer.get();
                        result2 |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result2;
    }

    private void readUtf8(int charCount) {
        char[] chars = this.chars;
        int charIndex = 0;
        int count2 = Math.min(this.require(1), charCount);
        int position = this.position;
        while (charIndex < count2) {
            ++position;
            byte b = this.niobuffer.get();
            if (b < 0) {
                --position;
                break;
            }
            chars[charIndex++] = (char)b;
        }
        this.position = position;
        if (charIndex < charCount) {
            this.niobuffer.position(position);
            this.readUtf8_slow(charCount, charIndex);
        }
    }

    private void readUtf8_slow(int charCount, int charIndex) {
        char[] chars = this.chars;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            int b = this.niobuffer.get() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    chars[charIndex] = (char)((b & 0x1F) << 6 | this.niobuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte b2 = this.niobuffer.get();
                    byte b3 = this.niobuffer.get();
                    chars[charIndex] = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAscii() {
        byte b;
        int end = this.position;
        int start2 = end - 1;
        int limit = this.limit;
        do {
            if (end == limit) {
                return this.readAscii_slow();
            }
            ++end;
        } while (((b = this.niobuffer.get()) & 0x80) == 0);
        this.niobuffer.put(end - 1, (byte)(this.niobuffer.get(end - 1) & 0x7F));
        byte[] tmp = new byte[end - start2];
        this.niobuffer.position(start2);
        this.niobuffer.get(tmp);
        String value = new String(tmp, 0, 0, end - start2);
        this.niobuffer.put(end - 1, (byte)(this.niobuffer.get(end - 1) | 0x80));
        this.position = end;
        this.niobuffer.position(this.position);
        return value;
    }

    private String readAscii_slow() {
        byte b;
        --this.position;
        int charCount = this.limit - this.position;
        if (charCount > this.chars.length) {
            this.chars = new char[charCount * 2];
        }
        char[] chars = this.chars;
        int i2 = this.position;
        int ii = 0;
        int n = this.limit;
        while (i2 < n) {
            chars[ii] = (char)this.niobuffer.get(i2);
            ++i2;
            ++ii;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            ++this.position;
            b = this.niobuffer.get();
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) break;
            chars[charCount++] = (char)b;
        }
        chars[charCount++] = (char)(b & 0x7F);
        return new String(chars, 0, charCount);
    }

    public StringBuilder readStringBuilder() {
        this.niobuffer.position(this.position);
        int available = this.require(1);
        ++this.position;
        byte b = this.niobuffer.get();
        if ((b & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }

    public float readFloat() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getFloat();
    }

    public float readFloat(float precision, boolean optimizePositive) throws KryoException {
        return (float)this.readInt(optimizePositive) / precision;
    }

    public short readShort() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getShort();
    }

    public int readShortUnsigned() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getShort();
    }

    public long readLong() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getLong();
    }

    public long readLong(boolean optimizePositive) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarLong(optimizePositive);
        }
        return this.readLong();
    }

    public long readVarLong(boolean optimizePositive) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 9) {
            return this.readLong_slow(optimizePositive);
        }
        ++this.position;
        byte b = this.niobuffer.get();
        long result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            ++this.position;
            b = this.niobuffer.get();
            result2 |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                ++this.position;
                b = this.niobuffer.get();
                result2 |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    ++this.position;
                    b = this.niobuffer.get();
                    result2 |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        ++this.position;
                        b = this.niobuffer.get();
                        result2 |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            ++this.position;
                            b = this.niobuffer.get();
                            result2 |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                ++this.position;
                                b = this.niobuffer.get();
                                result2 |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    ++this.position;
                                    b = this.niobuffer.get();
                                    result2 |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        ++this.position;
                                        b = this.niobuffer.get();
                                        result2 |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result2 = result2 >>> 1 ^ -(result2 & 1L);
        }
        return result2;
    }

    private long readLong_slow(boolean optimizePositive) {
        ++this.position;
        byte b = this.niobuffer.get();
        long result2 = b & 0x7F;
        if ((b & 0x80) != 0) {
            this.require(1);
            ++this.position;
            b = this.niobuffer.get();
            result2 |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b = this.niobuffer.get();
                result2 |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b = this.niobuffer.get();
                    result2 |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b = this.niobuffer.get();
                        result2 |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            this.require(1);
                            ++this.position;
                            b = this.niobuffer.get();
                            result2 |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                this.require(1);
                                ++this.position;
                                b = this.niobuffer.get();
                                result2 |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    this.require(1);
                                    ++this.position;
                                    b = this.niobuffer.get();
                                    result2 |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        this.require(1);
                                        ++this.position;
                                        b = this.niobuffer.get();
                                        result2 |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!optimizePositive) {
            result2 = result2 >>> 1 ^ -(result2 & 1L);
        }
        return result2;
    }

    public boolean readBoolean() throws KryoException {
        this.require(1);
        ++this.position;
        return this.niobuffer.get() == 1;
    }

    public char readChar() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getChar();
    }

    public double readDouble() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getDouble();
    }

    public double readDouble(double precision, boolean optimizePositive) throws KryoException {
        return (double)this.readLong(optimizePositive) / precision;
    }

    public int[] readInts(int length) throws KryoException {
        if (this.capacity - this.position >= length * 4 && this.isNativeOrder()) {
            int[] array = new int[length];
            IntBuffer buf = this.niobuffer.asIntBuffer();
            buf.get(array);
            this.position += length * 4;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readInts(length);
    }

    public long[] readLongs(int length) throws KryoException {
        if (this.capacity - this.position >= length * 8 && this.isNativeOrder()) {
            long[] array = new long[length];
            LongBuffer buf = this.niobuffer.asLongBuffer();
            buf.get(array);
            this.position += length * 8;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readLongs(length);
    }

    public float[] readFloats(int length) throws KryoException {
        if (this.capacity - this.position >= length * 4 && this.isNativeOrder()) {
            float[] array = new float[length];
            FloatBuffer buf = this.niobuffer.asFloatBuffer();
            buf.get(array);
            this.position += length * 4;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readFloats(length);
    }

    public short[] readShorts(int length) throws KryoException {
        if (this.capacity - this.position >= length * 2 && this.isNativeOrder()) {
            short[] array = new short[length];
            ShortBuffer buf = this.niobuffer.asShortBuffer();
            buf.get(array);
            this.position += length * 2;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readShorts(length);
    }

    public char[] readChars(int length) throws KryoException {
        if (this.capacity - this.position >= length * 2 && this.isNativeOrder()) {
            char[] array = new char[length];
            CharBuffer buf = this.niobuffer.asCharBuffer();
            buf.get(array);
            this.position += length * 2;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readChars(length);
    }

    public double[] readDoubles(int length) throws KryoException {
        if (this.capacity - this.position >= length * 8 && this.isNativeOrder()) {
            double[] array = new double[length];
            DoubleBuffer buf = this.niobuffer.asDoubleBuffer();
            buf.get(array);
            this.position += length * 8;
            this.niobuffer.position(this.position);
            return array;
        }
        return super.readDoubles(length);
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }

    public boolean getVarIntsEnabled() {
        return this.varIntsEnabled;
    }

    public void setVarIntsEnabled(boolean varIntsEnabled) {
        this.varIntsEnabled = varIntsEnabled;
    }
}

