/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.io.InputStream;

public class InputChunked
extends Input {
    private int chunkSize = -1;

    public InputChunked() {
        super(2048);
    }

    public InputChunked(int bufferSize) {
        super(bufferSize);
    }

    public InputChunked(InputStream inputStream) {
        super(inputStream, 2048);
    }

    public InputChunked(InputStream inputStream, int bufferSize) {
        super(inputStream, bufferSize);
    }

    public void setInputStream(InputStream inputStream) {
        super.setInputStream(inputStream);
        this.chunkSize = -1;
    }

    public void setBuffer(byte[] bytes, int offset, int count2) {
        super.setBuffer(bytes, offset, count2);
        this.chunkSize = -1;
    }

    public void rewind() {
        super.rewind();
        this.chunkSize = -1;
    }

    protected int fill(byte[] buffer, int offset, int count2) throws KryoException {
        if (this.chunkSize == -1) {
            this.readChunkSize();
        } else if (this.chunkSize == 0) {
            return -1;
        }
        int actual = super.fill(buffer, offset, Math.min(this.chunkSize, count2));
        this.chunkSize -= actual;
        if (this.chunkSize == 0) {
            this.readChunkSize();
        }
        return actual;
    }

    private void readChunkSize() {
        try {
            InputStream inputStream = this.getInputStream();
            int result2 = 0;
            for (int offset = 0; offset < 32; offset += 7) {
                int b = inputStream.read();
                if (b == -1) {
                    throw new KryoException("Buffer underflow.");
                }
                result2 |= (b & 0x7F) << offset;
                if ((b & 0x80) != 0) continue;
                this.chunkSize = result2;
                if (Log.TRACE) {
                    Log.trace("kryo", "Read chunk: " + this.chunkSize);
                }
                return;
            }
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        throw new KryoException("Malformed integer.");
    }

    public void nextChunks() {
        if (this.chunkSize == -1) {
            this.readChunkSize();
        }
        while (this.chunkSize > 0) {
            this.skip(this.chunkSize);
        }
        this.chunkSize = -1;
        if (Log.TRACE) {
            Log.trace("kryo", "Next chunks.");
        }
    }
}

