/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;

public class DefaultArraySerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectArraySerializer
    extends Serializer<Object[]> {
        private boolean elementsAreSameType;
        private boolean elementsCanBeNull = true;
        private Class[] generics;
        private final Class type;

        public ObjectArraySerializer(Kryo kryo, Class type2) {
            boolean isFinal;
            this.setAcceptsNull(true);
            this.type = type2;
            Class<?> componentType = type2.getComponentType();
            boolean bl = isFinal = 0 != (componentType.getModifiers() & 0x10);
            if (isFinal) {
                this.setElementsAreSameType(true);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Object[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                elementSerializer.setGenerics(kryo, this.generics);
                int n = object.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (this.elementsCanBeNull) {
                        kryo.writeObjectOrNull(output, object[i2], elementSerializer);
                        continue;
                    }
                    kryo.writeObject(output, object[i2], elementSerializer);
                }
            } else {
                int n = object.length;
                for (int i3 = 0; i3 < n; ++i3) {
                    if (object[i3] != null) {
                        Serializer serializer2 = kryo.getSerializer(object[i3].getClass());
                        serializer2.setGenerics(kryo, this.generics);
                    }
                    kryo.writeClassAndObject(output, object[i3]);
                }
            }
        }

        @Override
        public Object[] read(Kryo kryo, Input input2, Class<Object[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            Object[] object = (Object[])Array.newInstance(type2.getComponentType(), length - 1);
            kryo.reference(object);
            Class<?> elementClass = object.getClass().getComponentType();
            if (this.elementsAreSameType || Modifier.isFinal(elementClass.getModifiers())) {
                Serializer elementSerializer = kryo.getSerializer(elementClass);
                elementSerializer.setGenerics(kryo, this.generics);
                int n = object.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    object[i2] = this.elementsCanBeNull ? kryo.readObjectOrNull(input2, elementClass, elementSerializer) : kryo.readObject(input2, elementClass, elementSerializer);
                }
            } else {
                int n = object.length;
                for (int i3 = 0; i3 < n; ++i3) {
                    Registration registration = kryo.readClass(input2);
                    if (registration != null) {
                        registration.getSerializer().setGenerics(kryo, this.generics);
                        object[i3] = kryo.readObject(input2, registration.getType(), registration.getSerializer());
                        continue;
                    }
                    object[i3] = null;
                }
            }
            return object;
        }

        @Override
        public Object[] copy(Kryo kryo, Object[] original) {
            Object[] copy2 = (Object[])Array.newInstance(original.getClass().getComponentType(), original.length);
            int n = original.length;
            for (int i2 = 0; i2 < n; ++i2) {
                copy2[i2] = kryo.copy(original[i2]);
            }
            return copy2;
        }

        public void setElementsCanBeNull(boolean elementsCanBeNull) {
            this.elementsCanBeNull = elementsCanBeNull;
        }

        public void setElementsAreSameType(boolean elementsAreSameType) {
            this.elementsAreSameType = elementsAreSameType;
        }

        @Override
        public void setGenerics(Kryo kryo, Class[] generics) {
            if (Log.TRACE) {
                Log.trace("kryo", "setting generics for ObjectArraySerializer");
            }
            this.generics = generics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringArraySerializer
    extends Serializer<String[]> {
        public StringArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            if (kryo.getReferences() && kryo.getReferenceResolver().useReferences(String.class)) {
                Serializer serializer2 = kryo.getSerializer(String.class);
                int n = object.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    kryo.writeObjectOrNull(output, (Object)object[i2], serializer2);
                }
            } else {
                int n = object.length;
                for (int i3 = 0; i3 < n; ++i3) {
                    output.writeString(object[i3]);
                }
            }
        }

        @Override
        public String[] read(Kryo kryo, Input input2, Class<String[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            String[] array = new String[--length];
            if (kryo.getReferences() && kryo.getReferenceResolver().useReferences(String.class)) {
                Serializer serializer2 = kryo.getSerializer(String.class);
                for (int i2 = 0; i2 < length; ++i2) {
                    array[i2] = kryo.readObjectOrNull(input2, String.class, serializer2);
                }
            } else {
                for (int i3 = 0; i3 < length; ++i3) {
                    array[i3] = input2.readString();
                }
            }
            return array;
        }

        @Override
        public String[] copy(Kryo kryo, String[] original) {
            String[] copy2 = new String[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanArraySerializer
    extends Serializer<boolean[]> {
        public BooleanArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, boolean[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            int n = object.length;
            for (int i2 = 0; i2 < n; ++i2) {
                output.writeBoolean(object[i2]);
            }
        }

        @Override
        public boolean[] read(Kryo kryo, Input input2, Class<boolean[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            boolean[] array = new boolean[--length];
            for (int i2 = 0; i2 < length; ++i2) {
                array[i2] = input2.readBoolean();
            }
            return array;
        }

        @Override
        public boolean[] copy(Kryo kryo, boolean[] original) {
            boolean[] copy2 = new boolean[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleArraySerializer
    extends Serializer<double[]> {
        public DoubleArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, double[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeDoubles(object);
        }

        @Override
        public double[] read(Kryo kryo, Input input2, Class<double[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readDoubles(length - 1);
        }

        @Override
        public double[] copy(Kryo kryo, double[] original) {
            double[] copy2 = new double[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharArraySerializer
    extends Serializer<char[]> {
        public CharArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, char[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeChars(object);
        }

        @Override
        public char[] read(Kryo kryo, Input input2, Class<char[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readChars(length - 1);
        }

        @Override
        public char[] copy(Kryo kryo, char[] original) {
            char[] copy2 = new char[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortArraySerializer
    extends Serializer<short[]> {
        public ShortArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, short[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeShorts(object);
        }

        @Override
        public short[] read(Kryo kryo, Input input2, Class<short[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readShorts(length - 1);
        }

        @Override
        public short[] copy(Kryo kryo, short[] original) {
            short[] copy2 = new short[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongArraySerializer
    extends Serializer<long[]> {
        public LongArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, long[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeLongs(object, false);
        }

        @Override
        public long[] read(Kryo kryo, Input input2, Class<long[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readLongs(length - 1, false);
        }

        @Override
        public long[] copy(Kryo kryo, long[] original) {
            long[] copy2 = new long[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatArraySerializer
    extends Serializer<float[]> {
        public FloatArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, float[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeFloats(object);
        }

        @Override
        public float[] read(Kryo kryo, Input input2, Class<float[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readFloats(length - 1);
        }

        @Override
        public float[] copy(Kryo kryo, float[] original) {
            float[] copy2 = new float[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntArraySerializer
    extends Serializer<int[]> {
        public IntArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, int[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeInts(object, false);
        }

        @Override
        public int[] read(Kryo kryo, Input input2, Class<int[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readInts(length - 1, false);
        }

        @Override
        public int[] copy(Kryo kryo, int[] original) {
            int[] copy2 = new int[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArraySerializer
    extends Serializer<byte[]> {
        public ByteArraySerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, byte[] object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.length + 1, true);
            output.writeBytes(object);
        }

        @Override
        public byte[] read(Kryo kryo, Input input2, Class<byte[]> type2) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            return input2.readBytes(length - 1);
        }

        @Override
        public byte[] copy(Kryo kryo, byte[] original) {
            byte[] copy2 = new byte[original.length];
            System.arraycopy(original, 0, copy2, 0, copy2.length);
            return copy2;
        }
    }
}

