/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateSerializer
extends Serializer {
    private final Serializer serializer;
    private boolean noHeaders = true;
    private int compressionLevel = 4;

    public DeflateSerializer(Serializer serializer2) {
        this.serializer = serializer2;
    }

    public void write(Kryo kryo, Output output, Object object) {
        Deflater deflater = new Deflater(this.compressionLevel, this.noHeaders);
        OutputChunked outputChunked = new OutputChunked(output, 256);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputChunked, deflater);
        Output deflaterOutput = new Output(deflaterStream, 256);
        kryo.writeObject(deflaterOutput, object, this.serializer);
        deflaterOutput.flush();
        try {
            deflaterStream.finish();
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        outputChunked.endChunks();
    }

    public Object read(Kryo kryo, Input input2, Class type2) {
        InflaterInputStream inflaterStream = new InflaterInputStream(new InputChunked(input2, 256), new Inflater(this.noHeaders));
        return kryo.readObject(new Input(inflaterStream, 256), type2, this.serializer);
    }

    public void setNoHeaders(boolean noHeaders) {
        this.noHeaders = noHeaders;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Object copy(Kryo kryo, Object original) {
        return this.serializer.copy(kryo, original);
    }
}

