/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Generics;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.ObjectField;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSerializerGenericsUtil {
    private Kryo kryo;
    private FieldSerializer serializer;

    public FieldSerializerGenericsUtil(FieldSerializer serializer2) {
        this.serializer = serializer2;
        this.kryo = serializer2.getKryo();
    }

    Generics buildGenericsScope(Class clazz, Class[] generics) {
        TypeVariable<Class<T>>[] typeParams = null;
        for (Class<?> typ = clazz; typ != null && ((typeParams = typ.getTypeParameters()) == null || typeParams.length == 0); typ = typ.getComponentType()) {
        }
        if (typeParams != null && typeParams.length > 0) {
            Log.trace("kryo", "Class " + clazz.getName() + " has generic type parameters");
            int typeVarNum = 0;
            HashMap<String, Class> typeVar2concreteClass = new HashMap<String, Class>();
            for (TypeVariable typeVar : typeParams) {
                Class<?> concreteClass;
                String typeVarName = typeVar.getName();
                if (Log.TRACE) {
                    Log.trace("kryo", "Type parameter variable: name=" + typeVarName + " type bounds=" + Arrays.toString(typeVar.getBounds()));
                }
                if ((concreteClass = this.getTypeVarConcreteClass(generics, typeVarNum, typeVarName)) != null) {
                    typeVar2concreteClass.put(typeVarName, concreteClass);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Concrete type used for " + typeVarName + " is: " + concreteClass.getName());
                    }
                }
                ++typeVarNum;
            }
            Generics genScope = new Generics(typeVar2concreteClass);
            return genScope;
        }
        return null;
    }

    private Class<?> getTypeVarConcreteClass(Class[] generics, int typeVarNum, String typeVarName) {
        Generics scope2;
        if (generics != null && generics.length > typeVarNum) {
            return generics[typeVarNum];
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Trying to use kryo.getGenericScope");
        }
        if ((scope2 = this.kryo.getGenericsScope()) != null) {
            return scope2.getConcreteClass(typeVarName);
        }
        return null;
    }

    Class[] computeFieldGenerics(Type fieldGenericType, Field field, Class[] fieldClass) {
        Object[] fieldGenerics = null;
        if (fieldGenericType != null) {
            if (fieldGenericType instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                TypeVariable typeVar = (TypeVariable)fieldGenericType;
                Class concreteClass = this.serializer.getGenericsScope().getConcreteClass(typeVar.getName());
                if (concreteClass != null) {
                    fieldClass[0] = concreteClass;
                    fieldGenerics = new Class[]{fieldClass[0]};
                    if (Log.TRACE) {
                        Log.trace("kryo", "Determined concrete class of '" + field.getName() + "' to be " + fieldClass[0].getName());
                    }
                }
            } else if (fieldGenericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)fieldGenericType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments != null) {
                    fieldGenerics = new Class[actualTypeArguments.length];
                    for (int i2 = 0; i2 < actualTypeArguments.length; ++i2) {
                        Type t = actualTypeArguments[i2];
                        if (t instanceof Class) {
                            fieldGenerics[i2] = (Class)t;
                            continue;
                        }
                        if (t instanceof ParameterizedType) {
                            fieldGenerics[i2] = (Class)((ParameterizedType)t).getRawType();
                            continue;
                        }
                        if (t instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                            fieldGenerics[i2] = this.serializer.getGenericsScope().getConcreteClass(((TypeVariable)t).getName());
                            continue;
                        }
                        if (t instanceof WildcardType) {
                            fieldGenerics[i2] = Object.class;
                            continue;
                        }
                        if (t instanceof GenericArrayType) {
                            Class clazz;
                            Generics scope2;
                            Type componentType = ((GenericArrayType)t).getGenericComponentType();
                            if (componentType instanceof Class) {
                                fieldGenerics[i2] = Array.newInstance((Class)componentType, 0).getClass();
                                continue;
                            }
                            if (!(componentType instanceof TypeVariable) || (scope2 = this.serializer.getGenericsScope()) == null || (clazz = scope2.getConcreteClass(((TypeVariable)componentType).getName())) == null) continue;
                            fieldGenerics[i2] = Array.newInstance(clazz, 0).getClass();
                            continue;
                        }
                        fieldGenerics[i2] = null;
                    }
                    if (Log.TRACE && fieldGenerics != null) {
                        Log.trace("kryo", "Determined concrete class of parametrized '" + field.getName() + "' to be " + fieldGenericType + " where type parameters are " + Arrays.toString(fieldGenerics));
                    }
                }
            } else if (fieldGenericType instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)fieldGenericType;
                Type genericComponentType = arrayType.getGenericComponentType();
                Class[] tmpFieldClass = new Class[]{fieldClass[0]};
                fieldGenerics = this.computeFieldGenerics(genericComponentType, field, tmpFieldClass);
                if (Log.TRACE && fieldGenerics != null) {
                    Log.trace("kryo", "Determined concrete class of a generic array '" + field.getName() + "' to be " + fieldGenericType + " where type parameters are " + Arrays.toString(fieldGenerics));
                } else if (Log.TRACE) {
                    Log.trace("kryo", "Determined concrete class of '" + field.getName() + "' to be " + fieldGenericType);
                }
            }
        }
        return fieldGenerics;
    }

    FieldSerializer.CachedField newCachedFieldOfGenericType(Field field, int accessIndex, Class[] fieldClass, Type fieldGenericType) {
        if (Log.TRACE) {
            Log.trace("kryo", "Field '" + field.getName() + "' of type " + fieldClass[0] + " of generic type " + fieldGenericType);
        }
        if (Log.TRACE && fieldGenericType != null) {
            Log.trace("kryo", "Field generic type is of class " + fieldGenericType.getClass().getName());
        }
        Class[] cachedFieldGenerics = FieldSerializerGenericsUtil.getGenerics(fieldGenericType, this.kryo);
        Generics scope2 = this.buildGenericsScope(fieldClass[0], cachedFieldGenerics);
        if (fieldClass[0] == Object.class && fieldGenericType instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
            TypeVariable typeVar = (TypeVariable)fieldGenericType;
            Class concreteClass = this.serializer.getGenericsScope().getConcreteClass(typeVar.getName());
            if (concreteClass != null) {
                scope2 = new Generics();
                scope2.add(typeVar.getName(), concreteClass);
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Generics scope of field '" + field.getName() + "' of class " + fieldGenericType + " is " + scope2);
        }
        Object[] fieldGenerics = this.computeFieldGenerics(fieldGenericType, field, fieldClass);
        FieldSerializer.CachedField cachedField = this.serializer.newMatchingCachedField(field, accessIndex, fieldClass[0], fieldGenericType, (Class[])fieldGenerics);
        if (fieldGenerics != null && cachedField instanceof ObjectField && fieldGenerics.length > 0 && fieldGenerics[0] != null) {
            ((ObjectField)cachedField).generics = fieldGenerics;
            if (Log.TRACE) {
                Log.trace("kryo", "Field generics: " + Arrays.toString(fieldGenerics));
            }
        }
        return cachedField;
    }

    public static Class[] getGenerics(Type genericType, Kryo kryo) {
        if (genericType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)genericType).getGenericComponentType();
            if (componentType instanceof Class) {
                return new Class[]{(Class)componentType};
            }
            return FieldSerializerGenericsUtil.getGenerics(componentType, kryo);
        }
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Processing generic type " + genericType);
        }
        Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
        Class[] generics = new Class[actualTypes.length];
        int count2 = 0;
        for (Type actualType : actualTypes) {
            if (Log.TRACE) {
                Log.trace("kryo", "Processing actual type " + actualType + " (" + actualType.getClass().getName() + ")");
            }
            generics[i] = Object.class;
            if (actualType instanceof Class) {
                generics[i] = (Class)actualType;
            } else if (actualType instanceof ParameterizedType) {
                generics[i] = (Class)((ParameterizedType)actualType).getRawType();
            } else if (actualType instanceof TypeVariable) {
                Class clazz;
                Generics scope2 = kryo.getGenericsScope();
                if (scope2 == null || (clazz = scope2.getConcreteClass(((TypeVariable)actualType).getName())) == null) continue;
                generics[i] = clazz;
            } else {
                if (!(actualType instanceof GenericArrayType)) continue;
                Type componentType = ((GenericArrayType)actualType).getGenericComponentType();
                if (componentType instanceof Class) {
                    generics[i] = Array.newInstance((Class)componentType, 0).getClass();
                } else if (componentType instanceof TypeVariable) {
                    Class clazz;
                    Generics scope3 = kryo.getGenericsScope();
                    if (scope3 != null && (clazz = scope3.getConcreteClass(((TypeVariable)componentType).getName())) != null) {
                        generics[i] = Array.newInstance(clazz, 0).getClass();
                    }
                } else {
                    Class[] componentGenerics = FieldSerializerGenericsUtil.getGenerics(componentType, kryo);
                    if (componentGenerics != null) {
                        generics[i] = componentGenerics[0];
                    }
                }
            }
            ++count2;
        }
        if (count2 == 0) {
            return null;
        }
        return generics;
    }
}

