/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;

    public TaggedFieldSerializer(Kryo kryo, Class type2) {
        super(kryo, type2);
    }

    @Override
    protected void initializeCachedFields() {
        Field field;
        int i2;
        FieldSerializer.CachedField[] fields2 = this.getFields();
        int n = fields2.length;
        for (i2 = 0; i2 < n; ++i2) {
            field = fields2[i2].getField();
            if (field.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + fields2[i2]);
            }
            super.removeField(fields2[i2]);
        }
        fields2 = this.getFields();
        this.tags = new int[fields2.length];
        this.deprecated = new boolean[fields2.length];
        this.writeFieldCount = fields2.length;
        n = fields2.length;
        for (i2 = 0; i2 < n; ++i2) {
            field = fields2[i2].getField();
            this.tags[i2] = field.getAnnotation(Tag.class).value();
            if (field.getAnnotation(Deprecated.class) == null) continue;
            this.deprecated[i2] = true;
            --this.writeFieldCount;
        }
        this.removedFields.clear();
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields2 = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        int n = fields2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.deprecated[i2]) continue;
            output.writeVarInt(this.tags[i2], true);
            fields2[i2].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<T> type2) {
        T object = this.create(kryo, input2, type2);
        kryo.reference(object);
        int fieldCount = input2.readVarInt(true);
        int[] tags = this.tags;
        FieldSerializer.CachedField[] fields2 = this.getFields();
        int n = fieldCount;
        for (int i2 = 0; i2 < n; ++i2) {
            int tag = input2.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            int nn = tags.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (tags[ii] != tag) continue;
                cachedField = fields2[ii];
                break;
            }
            if (cachedField == null) {
                throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
            }
            cachedField.read(input2, object);
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

