/*
 * Decompiled with CFR 0.152.
 */
package de.hype.bingonet.shared.objects;

import de.hype.bingonet.shared.objects.Vector3d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00012B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0012J%\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0012J%\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010 J\u001a\u0010&\u001a\u00020%2\b\u0010$\u001a\u0004\u0018\u00010#H\u0096\u0002\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010,\u001a\u00020%2\u0006\u0010$\u001a\u00020\u0000\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010/\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a\u00a2\u0006\u0004\b/\u00100R\u0016\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u00101R\u0016\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0004\u00101R\u0016\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u00101\u00a8\u00063"}, d2={"Lde/hype/bingonet/shared/objects/Vector3i;", "", "", "x", "y", "z", "<init>", "(III)V", "Lde/hype/bingonet/shared/objects/Vector3d;", "vec", "(Lde/hype/bingonet/shared/objects/Vector3d;)V", "", "toString", "()Ljava/lang/String;", "", "asLong", "()J", "subtractReverse", "(Lde/hype/bingonet/shared/objects/Vector3i;)Lde/hype/bingonet/shared/objects/Vector3i;", "normalize", "()Lde/hype/bingonet/shared/objects/Vector3i;", "crossProduct", "subtract", "(III)Lde/hype/bingonet/shared/objects/Vector3i;", "add", "addVector", "", "distanceTo", "(Lde/hype/bingonet/shared/objects/Vector3i;)D", "", "pitch", "rotatePitch", "(F)Lde/hype/bingonet/shared/objects/Vector3i;", "yaw", "rotateYaw", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "compareTo", "(Lde/hype/bingonet/shared/objects/Vector3i;)I", "signumEquals", "(Lde/hype/bingonet/shared/objects/Vector3i;)Z", "value", "sqrt", "(D)D", "I", "Companion", "1.8.9"})
public class Vector3i
implements Comparable<Vector3i> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public int x;
    @JvmField
    public int y;
    @JvmField
    public int z;
    @NotNull
    private static final Vector3i NULL_VECTOR = new Vector3i(0, 0, 0);
    @NotNull
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION;
    private static final int SIZE_BITS_X;
    private static final int SIZE_BITS_Z;
    private static final int SIZE_BITS_Y;
    private static final long BITS_Y;
    private static final int BIT_SHIFT_Z;
    private static final int BIT_SHIFT_X;
    private static final long BITS_Z;
    private static final long BITS_X;
    @NotNull
    private static final float[] SIN_TABLE;

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x = (int)vec.getX();
        this.y = (int)vec.getY();
        this.z = (int)vec.getZ();
    }

    @NotNull
    public String toString() {
        return "" + this.x + ' ' + this.y + ' ' + this.z;
    }

    public final long asLong() {
        long l = 0L;
        l |= ((long)this.x & BITS_X) << BIT_SHIFT_X;
        return (l |= ((long)this.y & BITS_Y) << 0) | ((long)this.z & BITS_Z) << BIT_SHIFT_Z;
    }

    @NotNull
    public final Vector3i subtractReverse(@NotNull Vector3i vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return new Vector3i(vec.x - this.x, vec.x - this.y, vec.z - this.z);
    }

    @NotNull
    public final Vector3i normalize() {
        int base = this.x * this.x + this.y * this.y + this.z * this.z;
        return (double)base < 1.0E-4 ? new Vector3i(0, 0, 0) : new Vector3i(this.x / base, this.y / base, this.z / base);
    }

    @NotNull
    public final Vector3i crossProduct(@NotNull Vector3i vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return new Vector3i(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    @NotNull
    public final Vector3i subtract(@NotNull Vector3i vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return this.subtract(vec.x, vec.y, vec.z);
    }

    @NotNull
    public final Vector3i subtract(int x, int y, int z) {
        return this.addVector(-x, -y, -z);
    }

    @NotNull
    public final Vector3i add(@NotNull Vector3i vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return this.addVector(vec.x, vec.y, vec.z);
    }

    @NotNull
    public final Vector3i addVector(int x, int y, int z) {
        return new Vector3i(this.x + x, this.y + y, this.z + z);
    }

    public final double distanceTo(@NotNull Vector3i vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        double d2 = vec.z - this.z;
        return this.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    @NotNull
    public final Vector3i rotatePitch(float pitch) {
        float f = Companion.cos(pitch);
        float f1 = Companion.sin(pitch);
        int d1 = this.y * (int)f + this.z * (int)f1;
        int d2 = this.z * (int)f - this.y * (int)f1;
        return new Vector3i(this.x, d1, d2);
    }

    @NotNull
    public final Vector3i rotateYaw(float yaw) {
        float f = Companion.cos(yaw);
        float f1 = Companion.sin(yaw);
        int d0 = this.x * (int)f + this.z * (int)f1;
        int d2 = this.z * (int)f - this.x * (int)f1;
        return new Vector3i(d0, this.y, d2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3i)) {
            return false;
        }
        return this.x == ((Vector3i)other).x && this.y == ((Vector3i)other).y && this.z == ((Vector3i)other).z;
    }

    public int hashCode() {
        long bits = 1L;
        bits = 31L * bits + Double.doubleToLongBits(this.x);
        bits = 31L * bits + Double.doubleToLongBits(this.y);
        bits = 31L * bits + Double.doubleToLongBits(this.z);
        return (int)(bits ^ bits >> 32);
    }

    @Override
    public int compareTo(@NotNull Vector3i other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.y == other.y ? (this.z == other.z ? this.x - other.x : this.z - other.z) : this.y - other.y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean signumEquals(@NotNull Vector3i other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (Math.signum(this.x) != Math.signum(other.x)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (Math.signum(this.y) != Math.signum(other.y)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (Math.signum(this.z) != Math.signum(other.z)) return false;
        return true;
    }

    public final double sqrt(double value) {
        return Math.sqrt(value);
    }

    static {
        int[] nArray = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
        MULTIPLY_DE_BRUIJN_BIT_POSITION = nArray;
        SIZE_BITS_Z = SIZE_BITS_X = 1 + Companion.floorLog2(Vector3i.Companion.smallestEncompassingPowerOfTwo(30000000));
        SIZE_BITS_Y = 64 - SIZE_BITS_X - SIZE_BITS_Z;
        BITS_Y = (1L << SIZE_BITS_Y) - 1L;
        BIT_SHIFT_Z = SIZE_BITS_Y;
        BIT_SHIFT_X = SIZE_BITS_Y + SIZE_BITS_Z;
        BITS_Z = (1L << SIZE_BITS_Z) - 1L;
        BITS_X = (1L << SIZE_BITS_X) - 1L;
        SIN_TABLE = new float[65536];
        for (int i2 = 0; i2 < 65536; ++i2) {
            Vector3i.SIN_TABLE[i2] = (float)Math.sin((double)i2 * Math.PI * 2.0 / 65536.0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0007J\u0015\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001b\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u001bR\u0014\u0010$\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010\u001bR\u0014\u0010%\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\"R\u0014\u0010&\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\"R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lde/hype/bingonet/shared/objects/Vector3i$Companion;", "", "<init>", "()V", "", "value", "smallestEncompassingPowerOfTwo", "(I)I", "floorLog2", "", "isPowerOfTwo", "(I)Z", "ceilLog2", "", "f", "sin", "(F)F", "cos", "Lde/hype/bingonet/shared/objects/Vector3i;", "NULL_VECTOR", "Lde/hype/bingonet/shared/objects/Vector3i;", "getNULL_VECTOR", "()Lde/hype/bingonet/shared/objects/Vector3i;", "", "MULTIPLY_DE_BRUIJN_BIT_POSITION", "[I", "SIZE_BITS_X", "I", "SIZE_BITS_Z", "SIZE_BITS_Y", "getSIZE_BITS_Y", "()I", "", "BITS_Y", "J", "BIT_SHIFT_Z", "BIT_SHIFT_X", "BITS_Z", "BITS_X", "", "SIN_TABLE", "[F", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3i getNULL_VECTOR() {
            return NULL_VECTOR;
        }

        public final int getSIZE_BITS_Y() {
            return SIZE_BITS_Y;
        }

        private final int smallestEncompassingPowerOfTwo(int value) {
            int i2 = value - 1;
            i2 |= i2 >> 1;
            i2 |= i2 >> 2;
            i2 |= i2 >> 4;
            i2 |= i2 >> 8;
            i2 |= i2 >> 16;
            return i2 + 1;
        }

        public final int floorLog2(int value) {
            return this.ceilLog2(value) - (this.isPowerOfTwo(value) ? 0 : 1);
        }

        public final boolean isPowerOfTwo(int value) {
            return value != 0 && (value & value - 1) == 0;
        }

        public final int ceilLog2(int value) {
            int value2 = value;
            value2 = this.isPowerOfTwo(value2) ? value2 : this.smallestEncompassingPowerOfTwo(value2);
            return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value2 * 125613361L >> 27) & 0x1F];
        }

        public final float sin(float f) {
            return SIN_TABLE[(int)(f * 10430.378f) & 0xFFFF];
        }

        public final float cos(float value) {
            return SIN_TABLE[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

