/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.smtp;

import at.hannibal2.skyhanni.deps.commons.net.smtp.SMTPReply;
import at.hannibal2.skyhanni.deps.commons.net.smtp.SMTPSClient;
import java.io.IOException;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;

public class AuthenticatingSMTPClient
extends SMTPSClient {
    private static final String MAC_ALGORITHM = "HmacMD5";

    public AuthenticatingSMTPClient() {
    }

    public AuthenticatingSMTPClient(boolean implicit, SSLContext ctx) {
        super(implicit, ctx);
    }

    public AuthenticatingSMTPClient(String protocol) {
        super(protocol);
    }

    public AuthenticatingSMTPClient(String proto, boolean implicit) {
        super(proto, implicit);
    }

    public AuthenticatingSMTPClient(String proto, boolean implicit, String encoding) {
        super(proto, implicit, encoding);
    }

    public AuthenticatingSMTPClient(String protocol, String encoding) {
        super(protocol, false, encoding);
    }

    public boolean auth(AUTH_METHOD method, String user, String password) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        if (!SMTPReply.isPositiveIntermediate(this.sendCommand(14, AUTH_METHOD.getAuthName(method)))) {
            return false;
        }
        if (method.equals((Object)AUTH_METHOD.PLAIN)) {
            return SMTPReply.isPositiveCompletion(this.sendCommand(Base64.getEncoder().encodeToString(("\u0000" + user + "\u0000" + password).getBytes(this.getCharset()))));
        }
        if (method.equals((Object)AUTH_METHOD.CRAM_MD5)) {
            byte[] serverChallenge = Base64.getDecoder().decode(this.getReplyString().substring(4).trim());
            Mac hmacMd5 = Mac.getInstance(MAC_ALGORITHM);
            hmacMd5.init(new SecretKeySpec(password.getBytes(this.getCharset()), MAC_ALGORITHM));
            byte[] hmacResult = this.convertToHexString(hmacMd5.doFinal(serverChallenge)).getBytes(this.getCharset());
            byte[] userNameBytes = user.getBytes(this.getCharset());
            byte[] toEncode = new byte[userNameBytes.length + 1 + hmacResult.length];
            System.arraycopy(userNameBytes, 0, toEncode, 0, userNameBytes.length);
            toEncode[userNameBytes.length] = 32;
            System.arraycopy(hmacResult, 0, toEncode, userNameBytes.length + 1, hmacResult.length);
            return SMTPReply.isPositiveCompletion(this.sendCommand(Base64.getEncoder().encodeToString(toEncode)));
        }
        if (method.equals((Object)AUTH_METHOD.LOGIN)) {
            if (!SMTPReply.isPositiveIntermediate(this.sendCommand(Base64.getEncoder().encodeToString(user.getBytes(this.getCharset()))))) {
                return false;
            }
            return SMTPReply.isPositiveCompletion(this.sendCommand(Base64.getEncoder().encodeToString(password.getBytes(this.getCharset()))));
        }
        if (method.equals((Object)AUTH_METHOD.XOAUTH) || method.equals((Object)AUTH_METHOD.XOAUTH2)) {
            return SMTPReply.isPositiveIntermediate(this.sendCommand(Base64.getEncoder().encodeToString(user.getBytes(this.getCharset()))));
        }
        return false;
    }

    private String convertToHexString(byte[] a) {
        StringBuilder result2 = new StringBuilder(a.length * 2);
        for (byte element : a) {
            if ((element & 0xFF) <= 15) {
                result2.append("0");
            }
            result2.append(Integer.toHexString(element & 0xFF));
        }
        return result2.toString();
    }

    public int ehlo(String hostname) throws IOException {
        return this.sendCommand(15, hostname);
    }

    public boolean elogin() throws IOException {
        InetAddress host = this.getLocalAddress();
        String name2 = host.getHostName();
        if (name2 == null) {
            return false;
        }
        return SMTPReply.isPositiveCompletion(this.ehlo(name2));
    }

    public boolean elogin(String hostname) throws IOException {
        return SMTPReply.isPositiveCompletion(this.ehlo(hostname));
    }

    public int[] getEnhancedReplyCode() {
        String reply = this.getReplyString().substring(4);
        String[] parts = reply.substring(0, reply.indexOf(32)).split("\\.");
        int[] res = new int[parts.length];
        Arrays.setAll(res, i2 -> Integer.parseInt(parts[i2]));
        return res;
    }

    public static enum AUTH_METHOD {
        PLAIN,
        CRAM_MD5,
        LOGIN,
        XOAUTH,
        XOAUTH2;


        public static final String getAuthName(AUTH_METHOD method) {
            if (method.equals((Object)PLAIN)) {
                return "PLAIN";
            }
            if (method.equals((Object)CRAM_MD5)) {
                return "CRAM-MD5";
            }
            if (method.equals((Object)LOGIN)) {
                return "LOGIN";
            }
            if (method.equals((Object)XOAUTH)) {
                return "XOAUTH";
            }
            if (method.equals((Object)XOAUTH2)) {
                return "XOAUTH2";
            }
            return null;
        }
    }
}

