/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesOverflowConfig;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.ItemCompatKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryTooltipOverflow;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "event", "", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "", "", "split", "", "currentTier", "Lkotlin/Pair;", "getLevels", "(Ljava/util/List;I)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "counter", "getHaveNeed", "(ILat/hannibal2/skyhanni/features/garden/CropType;J)Lkotlin/Pair;", "getCrop", "(Ljava/util/List;)Lat/hannibal2/skyhanni/features/garden/CropType;", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "config", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nGardenInventoryTooltipOverflow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenInventoryTooltipOverflow.kt\nat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryTooltipOverflow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1761#2,3:98\n*S KotlinDebug\n*F\n+ 1 GardenInventoryTooltipOverflow.kt\nat/hannibal2/skyhanni/features/garden/inventory/GardenInventoryTooltipOverflow\n*L\n35#1:98,3\n*E\n"})
public final class GardenInventoryTooltipOverflow {
    @NotNull
    public static final GardenInventoryTooltipOverflow INSTANCE = new GardenInventoryTooltipOverflow();

    private GardenInventoryTooltipOverflow() {
    }

    private final CropMilestonesOverflowConfig getConfig() {
        return SkyHanniMod.feature.getGarden().getCropMilestones().getOverflow();
    }

    @HandleEvent
    public final void onToolTip(@NotNull ToolTipEvent event2) {
        boolean bl;
        class_1799 stack;
        block8: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!this.isEnabled()) {
                return;
            }
            String inventoryName = InventoryUtils.INSTANCE.openInventoryName();
            if (!Intrinsics.areEqual((Object)inventoryName, (Object)"Crop Milestones")) {
                return;
            }
            stack = event2.getItemStack();
            Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"Max tier reached!", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        String[] $i$f$any = new String[]{" "};
        List split = StringsKt.split$default((CharSequence)ItemUtils.INSTANCE.cleanName(stack), (String[])$i$f$any, (boolean)false, (int)0, (int)6, null);
        CropType crop = this.getCrop(split);
        long counter = GardenCropMilestones.INSTANCE.getCounter(crop);
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, crop, true);
        Pair<Long, Long> pair = this.getHaveNeed(currentTier, crop, counter);
        long have = ((Number)pair.component1()).longValue();
        long need = ((Number)pair.component2()).longValue();
        Pair<String, String> pair2 = this.getLevels(split, currentTier);
        String level = (String)pair2.component1();
        String nextLevel = (String)pair2.component2();
        boolean next = false;
        ListIterator<String> iterator2 = event2.getToolTip().listIterator();
        double percentage = (double)have / (double)need;
        ListIterator<String> listIterator = iterator2;
        while (((Iterator)listIterator).hasNext()) {
            String bar;
            String maxTierReached;
            String line = listIterator.next();
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)(maxTierReached = "\u00a77\u00a78Max tier reached!"), (boolean)false, (int)2, null)) {
                iterator2.set("\u00a77Progress to tier " + nextLevel + ": \u00a7e" + NumberUtil.INSTANCE.formatPercentage(percentage));
                ItemCompatKt.setCustomItemName(event2.getItemStack(), "\u00a7a" + crop.getCropName() + " " + level);
                next = true;
                continue;
            }
            if (!next || !StringsKt.contains$default((CharSequence)line, (CharSequence)(bar = "                    "), (boolean)false, (int)2, null)) continue;
            Object progressBar2 = StringUtils.progressBar$default(StringUtils.INSTANCE, percentage, 0, 2, null);
            iterator2.set(progressBar2 + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(have) + "\u00a76/\u00a7e" + NumberUtil.INSTANCE.addSeparators(need));
        }
    }

    private final Pair<String, String> getLevels(List<String> split, int currentTier) {
        int nextTier = currentTier + 1;
        boolean useRoman = StringsKt.toIntOrNull((String)((String)CollectionsKt.last(split))) == null;
        Object level = useRoman ? NumberUtil.INSTANCE.toRoman(currentTier) : "" + currentTier;
        Object nextLevel = useRoman ? NumberUtil.INSTANCE.toRoman(nextTier) : "" + nextTier;
        return new Pair(level, nextLevel);
    }

    private final Pair<Long, Long> getHaveNeed(int currentTier, CropType crop, long counter) {
        int nextTier = currentTier + 1;
        long cropsForCurrentTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentTier, crop, true);
        long cropsForNextTier = GardenCropMilestones.INSTANCE.getCropsForTier(nextTier, crop, true);
        long have = counter - cropsForCurrentTier;
        long need = cropsForNextTier - cropsForCurrentTier;
        return new Pair((Object)have, (Object)need);
    }

    private final CropType getCrop(List<String> split) {
        String cropName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(split, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        return CropType.Companion.getByName(StringUtils.removeColor$default(StringUtils.INSTANCE, cropName, false, 1, null));
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getInventoryTooltip();
    }
}

