/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.numpadcodes;

import at.hannibal2.skyhanni.data.IslandType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R&\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00160\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/features/misc/numpadcodes/IslandManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/data/IslandType;", "island", "", "addIsland", "(Lat/hannibal2/skyhanni/data/IslandType;)V", "", "getKnownIslands", "()Ljava/util/Set;", "", "code", "islands", "registerCodeAllowedIslands", "(Ljava/lang/String;Ljava/util/Set;)V", "getAllowedIslandsFor", "(Ljava/lang/String;)Ljava/util/Set;", "", "isAllowedOnIsland", "(Ljava/lang/String;Lat/hannibal2/skyhanni/data/IslandType;)Z", "", "knownIslands", "Ljava/util/Set;", "", "allowedIslandsByCode", "Ljava/util/Map;", "allowOtherIslandsByUser", "Z", "getAllowOtherIslandsByUser", "()Z", "setAllowOtherIslandsByUser", "(Z)V", "1.21.8"})
public final class IslandManager {
    @NotNull
    public static final IslandManager INSTANCE = new IslandManager();
    @NotNull
    private static final Set<IslandType> knownIslands;
    @NotNull
    private static final Map<String, Set<IslandType>> allowedIslandsByCode;
    private static boolean allowOtherIslandsByUser;

    private IslandManager() {
    }

    public final boolean getAllowOtherIslandsByUser() {
        return allowOtherIslandsByUser;
    }

    public final void setAllowOtherIslandsByUser(boolean bl) {
        allowOtherIslandsByUser = bl;
    }

    public final void addIsland(@NotNull IslandType island) {
        Intrinsics.checkNotNullParameter((Object)((Object)island), (String)"island");
        knownIslands.add(island);
    }

    @NotNull
    public final Set<IslandType> getKnownIslands() {
        return CollectionsKt.toSet((Iterable)knownIslands);
    }

    public final void registerCodeAllowedIslands(@NotNull String code, @NotNull Set<? extends IslandType> islands) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(islands, (String)"islands");
        allowedIslandsByCode.put(code, CollectionsKt.toMutableSet((Iterable)islands));
    }

    @NotNull
    public final Set<IslandType> getAllowedIslandsFor(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Set set = allowedIslandsByCode.get(code);
        if (set == null) {
            set = SetsKt.setOf((Object)((Object)IslandType.ANY));
        }
        return set;
    }

    public final boolean isAllowedOnIsland(@NotNull String code, @NotNull IslandType island) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)((Object)island), (String)"island");
        Set<IslandType> allowed = this.getAllowedIslandsFor(code);
        if (allowed.contains((Object)IslandType.ANY)) {
            return true;
        }
        if (allowed.contains((Object)island)) {
            return true;
        }
        return allowed.contains((Object)IslandType.UNKNOWN) && allowOtherIslandsByUser && !knownIslands.contains((Object)island);
    }

    static {
        IslandType[] islandTypeArray = new IslandType[]{IslandType.ANY};
        knownIslands = SetsKt.mutableSetOf((Object[])islandTypeArray);
        allowedIslandsByCode = new LinkedHashMap();
        allowOtherIslandsByUser = true;
    }
}

