/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.shader;

import at.hannibal2.skyhanni.features.chroma.StandardChromaShader;
import at.hannibal2.skyhanni.features.chroma.TexturedChromaShader;
import at.hannibal2.skyhanni.features.misc.DarkenShader;
import at.hannibal2.skyhanni.shader.CircleShader;
import at.hannibal2.skyhanni.shader.RadialGradientCircleShader;
import at.hannibal2.skyhanni.shader.RoundedRectangleOutlineShader;
import at.hannibal2.skyhanni.shader.RoundedRectangleShader;
import at.hannibal2.skyhanni.shader.RoundedTextureShader;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.shader.Shader;
import at.hannibal2.skyhanni.utils.shader.ShaderHelper;
import at.hannibal2.skyhanni.utils.shader.ShaderType;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001d\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/utils/shader/ShaderManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/shader/ShaderManager$Shaders;", "shader", "", "enableShader", "(Lat/hannibal2/skyhanni/utils/shader/ShaderManager$Shaders;)V", "", "shaderProgram", "shaderID", "attachShader", "(II)V", "disableShader", "Lat/hannibal2/skyhanni/utils/shader/ShaderType;", "type", "", "fileName", "loadShader", "(Lat/hannibal2/skyhanni/utils/shader/ShaderType;Ljava/lang/String;)I", "", "inWorld", "()Z", "Lat/hannibal2/skyhanni/utils/shader/Shader;", "activeShader", "Lat/hannibal2/skyhanni/utils/shader/Shader;", "Shaders", "1.21.8"})
public final class ShaderManager {
    @NotNull
    public static final ShaderManager INSTANCE = new ShaderManager();
    @Nullable
    private static Shader activeShader;

    private ShaderManager() {
    }

    public final void enableShader(@NotNull Shaders shader) {
        Intrinsics.checkNotNullParameter((Object)((Object)shader), (String)"shader");
        Shader shaderInstance = shader.getShader();
        if (!shaderInstance.getCreated()) {
            return;
        }
        activeShader = shaderInstance;
        shaderInstance.enable();
        shaderInstance.updateUniforms();
    }

    public final void attachShader(int shaderProgram, int shaderID) {
        ShaderHelper.INSTANCE.glAttachShader(shaderProgram, shaderID);
    }

    public final void disableShader() {
        if (activeShader == null) {
            return;
        }
        Shader shader = activeShader;
        if (shader != null) {
            shader.disable();
        }
        activeShader = null;
    }

    public final int loadShader(@NotNull ShaderType type2, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        class_2960 resourceLocation = TextCompatKt.createResourceLocation("skyhanni:shaders/" + fileName + type2.getExtension());
        StringBuilder source = new StringBuilder();
        InputStream inputStream = ((class_3298)class_310.method_1551().method_1478().method_14486(resourceLocation).get()).method_14482();
        TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(inputStream)), arg_0 -> ShaderManager.loadShader$lambda$0(source, arg_0));
        int shaderID = ShaderHelper.INSTANCE.glCreateShader(type2.getShaderType());
        String string = source.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ShaderHelper.INSTANCE.glShaderSource(shaderID, string);
        ShaderHelper.INSTANCE.glCompileShader(shaderID);
        if (ShaderHelper.INSTANCE.glGetShaderInt(shaderID, ShaderHelper.INSTANCE.getGL_COMPILE_STATUS()) == 0) {
            String errorMessage2 = "Failed to compile shader " + fileName + type2.getExtension() + ". Features that utilise this shader will not work correctly, if at all";
            String errorLog = StringUtils.trim((String)ShaderHelper.INSTANCE.glGetShaderInfoLog(shaderID, 1024));
            if (this.inWorld()) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"GLSL Compilation Error:\n", (Object)errorLog)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new Exception("Shader compilation error."), errorMessage2, pairArray, false, false, false, 56, null);
            } else {
                ChatUtils.INSTANCE.consoleLog(errorMessage2 + " " + errorLog);
            }
            return -1;
        }
        return shaderID;
    }

    public final boolean inWorld() {
        return MinecraftCompat.INSTANCE.getLocalWorldExists() && MinecraftCompat.INSTANCE.getLocalPlayerExists();
    }

    private static final Unit loadShader$lambda$0(StringBuilder $source, String it) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $source.append(it).append("\n");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/utils/shader/ShaderManager$Shaders;", "", "Lat/hannibal2/skyhanni/utils/shader/Shader;", "shader", "<init>", "(Ljava/lang/String;ILat/hannibal2/skyhanni/utils/shader/Shader;)V", "", "enableShader", "()V", "Lat/hannibal2/skyhanni/utils/shader/Shader;", "getShader", "()Lat/hannibal2/skyhanni/utils/shader/Shader;", "STANDARD_CHROMA", "TEXTURED_CHROMA", "ROUNDED_RECTANGLE", "ROUNDED_RECT_OUTLINE", "ROUNDED_TEXTURE", "DARKEN", "CIRCLE", "RADIAL_GRADIENT_CIRCLE", "1.21.8"})
    public static final class Shaders
    extends Enum<Shaders> {
        @NotNull
        private final Shader shader;
        public static final /* enum */ Shaders STANDARD_CHROMA = new Shaders(StandardChromaShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders TEXTURED_CHROMA = new Shaders(TexturedChromaShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders ROUNDED_RECTANGLE = new Shaders((Shader)RoundedRectangleShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders ROUNDED_RECT_OUTLINE = new Shaders((Shader)RoundedRectangleOutlineShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders ROUNDED_TEXTURE = new Shaders((Shader)RoundedTextureShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders DARKEN = new Shaders(DarkenShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders CIRCLE = new Shaders((Shader)CircleShader.INSTANCE.getINSTANCE());
        public static final /* enum */ Shaders RADIAL_GRADIENT_CIRCLE = new Shaders((Shader)RadialGradientCircleShader.INSTANCE.getINSTANCE());
        private static final /* synthetic */ Shaders[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Shaders(Shader shader) {
            this.shader = shader;
        }

        @NotNull
        public final Shader getShader() {
            return this.shader;
        }

        public final void enableShader() {
            INSTANCE.enableShader(this);
        }

        public static Shaders[] values() {
            return (Shaders[])$VALUES.clone();
        }

        public static Shaders valueOf(String value) {
            return Enum.valueOf(Shaders.class, value);
        }

        @NotNull
        public static EnumEntries<Shaders> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = shadersArray = new Shaders[]{Shaders.STANDARD_CHROMA, Shaders.TEXTURED_CHROMA, Shaders.ROUNDED_RECTANGLE, Shaders.ROUNDED_RECT_OUTLINE, Shaders.ROUNDED_TEXTURE, Shaders.DARKEN, Shaders.CIRCLE, Shaders.RADIAL_GRADIENT_CIRCLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

