/*
 * Decompiled with CFR 0.152.
 */
package de.hype.bingonet.environment.packetconfig;

import com.google.gson.Gson;
import de.hype.bingonet.environment.packetconfig.AbstractPacket;
import de.hype.bingonet.environment.packetconfig.BNGson;
import de.hype.bingonet.environment.packetconfig.BNPacketManager;
import de.hype.bingonet.environment.packetconfig.Packet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\f\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lde/hype/bingonet/environment/packetconfig/PacketUtils;", "", "<init>", "()V", "Lde/hype/bingonet/environment/packetconfig/AbstractPacket;", "packet", "", "parsePacketToJson", "(Lde/hype/bingonet/environment/packetconfig/AbstractPacket;)Ljava/lang/String;", "message", "Lkotlin/Pair;", "Lde/hype/bingonet/environment/packetconfig/Packet;", "parsePacket", "(Ljava/lang/String;)Lkotlin/Pair;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "", "knownPacketIssues", "Ljava/util/Set;", "getKnownPacketIssues", "()Ljava/util/Set;", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nPacketUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketUtils.kt\nde/hype/bingonet/environment/packetconfig/PacketUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,24:1\n739#2,9:25\n37#3:34\n36#3,3:35\n*S KotlinDebug\n*F\n+ 1 PacketUtils.kt\nde/hype/bingonet/environment/packetconfig/PacketUtils\n*L\n15#1:25,9\n15#1:34\n15#1:35,3\n*E\n"})
public final class PacketUtils {
    @NotNull
    public static final PacketUtils INSTANCE = new PacketUtils();
    @NotNull
    private static final Gson gson = BNGson.INSTANCE.createNotPrettyPrinting();
    @NotNull
    private static final Set<String> knownPacketIssues = new HashSet();

    private PacketUtils() {
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final Set<String> getKnownPacketIssues() {
        return knownPacketIssues;
    }

    @NotNull
    public final String parsePacketToJson(@NotNull AbstractPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        String string = gson.toJson((Object)packet);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return StringsKt.replace$default((String)string, (String)"\n", (String)"/n", (boolean)false, (int)4, null);
    }

    @Nullable
    public final Pair<Packet<? extends AbstractPacket>, AbstractPacket> parsePacket(@NotNull String message) {
        List list;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!StringsKt.contains$default((CharSequence)message, (CharSequence)".", (boolean)false, (int)2, null)) {
            return null;
        }
        CharSequence charSequence = message;
        Regex regex = new Regex("\\.");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String packetName = thisCollection$iv.toArray(new String[0])[0];
        String string = message.substring(packetName.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String rawJson = string;
        for (Packet<? extends AbstractPacket> packet : BNPacketManager.INSTANCE.getPackets()) {
            if (!Intrinsics.areEqual((Object)packetName, (Object)packet.getClazz().getSimpleName())) continue;
            return new Pair(packet, gson.fromJson(StringsKt.replace$default((String)rawJson, (String)"/n", (String)"\n", (boolean)false, (int)4, null), packet.getClazz()));
        }
        return null;
    }
}

