/*
 * Decompiled with CFR 0.152.
 */
package de.hype.bingonet.shared.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lde/hype/bingonet/shared/json/DurationSerializer;", "Lcom/google/gson/JsonSerializer;", "Ljava/time/Duration;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Ljava/time/Duration;", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "serialize", "(Ljava/time/Duration;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;", "", "formatTime", "(Ljava/time/Duration;)Ljava/lang/String;", "1.21.8"})
public final class DurationSerializer
implements JsonSerializer<Duration>,
JsonDeserializer<Duration> {
    @NotNull
    public Duration deserialize(@NotNull JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context2) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (json2.isJsonObject()) {
            JsonObject jsonObject = json2.getAsJsonObject();
            long seconds = jsonObject.get("seconds").getAsLong();
            int nanoAdjustment = jsonObject.get("nanoAdjustment").getAsInt();
            Duration duration = Duration.ofSeconds(seconds, nanoAdjustment);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            return duration;
        }
        long millis = json2.getAsLong();
        Duration duration = Duration.ofMillis(millis);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @NotNull
    public JsonElement serialize(@NotNull Duration src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context2) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("seconds", (Number)src.getSeconds());
        jsonObject.addProperty("nanoAdjustment", (Number)src.getNano());
        jsonObject.addProperty("toString", this.formatTime(src));
        return (JsonElement)jsonObject;
    }

    @NotNull
    public final String formatTime(@NotNull Duration src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        long seconds = src.getSeconds();
        if (seconds == 0L) {
            return "now";
        }
        String prefix = seconds > 0L ? "in %s" : "%s ago";
        int days = (int)(seconds / (long)86400);
        int hours = (int)(seconds % (long)86400 / (long)3600);
        int minutes = (int)(seconds % (long)3600 / (long)60);
        int secs = (int)(seconds % (long)60);
        StringBuilder sb = new StringBuilder();
        if (days != 0) {
            sb.append(days).append("d ");
        }
        if (hours != 0) {
            sb.append(hours).append("h ");
        }
        if (minutes != 0) {
            sb.append(minutes).append("m ");
        }
        if (secs != 0) {
            sb.append(secs).append("s");
        }
        Object[] objectArray = new Object[]{sb.toString()};
        String string = String.format(prefix, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }
}

