/*
 * Decompiled with CFR 0.152.
 */
package de.hype.bingonet.shared.packets.network;

import de.hype.bingonet.shared.packets.base.ExpectReplyPacket;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 \u001fB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ.\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001a\u001a\u0004\b\u001b\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001e\u0010\r\u00a8\u0006!"}, d2={"Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket;", "Lde/hype/bingonet/shared/packets/base/ExpectReplyPacket;", "Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket;", "Ljava/util/UUID;", "mcuuid", "", "discordId", "clientMojangServerId", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/lang/String;", "component3", "copy", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/util/UUID;", "getMcuuid", "Ljava/lang/String;", "getDiscordId", "getClientMojangServerId", "Companion", "MCRegistrationResponsePacket", "1.21.8"})
public final class RequestRegisterPacket
extends ExpectReplyPacket<MCRegistrationResponsePacket> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID mcuuid;
    @NotNull
    private final String discordId;
    @NotNull
    private final String clientMojangServerId;
    @NotNull
    public static final String PHRASE = "I will read the info channels in the discord before asking questions!";

    public RequestRegisterPacket(@NotNull UUID mcuuid, @NotNull String discordId, @NotNull String clientMojangServerId) {
        Intrinsics.checkNotNullParameter((Object)mcuuid, (String)"mcuuid");
        Intrinsics.checkNotNullParameter((Object)discordId, (String)"discordId");
        Intrinsics.checkNotNullParameter((Object)clientMojangServerId, (String)"clientMojangServerId");
        this.mcuuid = mcuuid;
        this.discordId = discordId;
        this.clientMojangServerId = clientMojangServerId;
    }

    @NotNull
    public final UUID getMcuuid() {
        return this.mcuuid;
    }

    @NotNull
    public final String getDiscordId() {
        return this.discordId;
    }

    @NotNull
    public final String getClientMojangServerId() {
        return this.clientMojangServerId;
    }

    @NotNull
    public final UUID component1() {
        return this.mcuuid;
    }

    @NotNull
    public final String component2() {
        return this.discordId;
    }

    @NotNull
    public final String component3() {
        return this.clientMojangServerId;
    }

    @NotNull
    public final RequestRegisterPacket copy(@NotNull UUID mcuuid, @NotNull String discordId, @NotNull String clientMojangServerId) {
        Intrinsics.checkNotNullParameter((Object)mcuuid, (String)"mcuuid");
        Intrinsics.checkNotNullParameter((Object)discordId, (String)"discordId");
        Intrinsics.checkNotNullParameter((Object)clientMojangServerId, (String)"clientMojangServerId");
        return new RequestRegisterPacket(mcuuid, discordId, clientMojangServerId);
    }

    public static /* synthetic */ RequestRegisterPacket copy$default(RequestRegisterPacket requestRegisterPacket, UUID uUID, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = requestRegisterPacket.mcuuid;
        }
        if ((n & 2) != 0) {
            string = requestRegisterPacket.discordId;
        }
        if ((n & 4) != 0) {
            string2 = requestRegisterPacket.clientMojangServerId;
        }
        return requestRegisterPacket.copy(uUID, string, string2);
    }

    @NotNull
    public String toString() {
        return "RequestRegisterPacket(mcuuid=" + this.mcuuid + ", discordId=" + this.discordId + ", clientMojangServerId=" + this.clientMojangServerId + ")";
    }

    public int hashCode() {
        int result2 = this.mcuuid.hashCode();
        result2 = result2 * 31 + this.discordId.hashCode();
        result2 = result2 * 31 + this.clientMojangServerId.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestRegisterPacket)) {
            return false;
        }
        RequestRegisterPacket requestRegisterPacket = (RequestRegisterPacket)other;
        if (!Intrinsics.areEqual((Object)this.mcuuid, (Object)requestRegisterPacket.mcuuid)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.discordId, (Object)requestRegisterPacket.discordId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientMojangServerId, (Object)requestRegisterPacket.clientMojangServerId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$Companion;", "", "<init>", "()V", "", "input", "", "passesAccuracyCheck", "(Ljava/lang/String;)Z", "str1", "str2", "", "calculateSimilarity", "(Ljava/lang/String;Ljava/lang/String;)I", "a", "b", "levenshteinDistance", "PHRASE", "Ljava/lang/String;", "1.21.8"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean passesAccuracyCheck(@NotNull String input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            String string = RequestRegisterPacket.PHRASE.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String required = string;
            String string2 = input2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String inputLower = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            int similarity = this.calculateSimilarity(required, inputLower);
            return similarity >= 95;
        }

        public final int calculateSimilarity(@NotNull String str1, @NotNull String str2) {
            Intrinsics.checkNotNullParameter((Object)str1, (String)"str1");
            Intrinsics.checkNotNullParameter((Object)str2, (String)"str2");
            int longer = Math.max(str1.length(), str2.length());
            int distance = this.levenshteinDistance(str1, str2);
            return (longer - distance) / longer * 100;
        }

        public final int levenshteinDistance(@NotNull String a, @NotNull String b) {
            int n;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int n2 = 0;
            int n3 = a.length() + 1;
            int[][] nArrayArray = new int[n3][];
            while (n2 < n3) {
                n = n2++;
                nArrayArray[n] = new int[b.length() + 1];
            }
            int[][] dp = nArrayArray;
            int i2 = 0;
            n3 = a.length();
            if (i2 <= n3) {
                while (true) {
                    int j;
                    if ((j = 0) <= (n = b.length())) {
                        while (true) {
                            dp[i2][j] = i2 == 0 ? j : (j == 0 ? i2 : (a.charAt(i2 - 1) == b.charAt(j - 1) ? dp[i2 - 1][j - 1] : 1 + Math.min(dp[i2 - 1][j], Math.min(dp[i2][j - 1], dp[i2 - 1][j - 1]))));
                            if (j == n) break;
                            ++j;
                        }
                    }
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            return dp[a.length()][b.length()];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket;", "Lde/hype/bingonet/shared/packets/base/ExpectReplyPacket$ReplyPacket;", "Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket$ResponseType;", "response", "<init>", "(Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket$ResponseType;)V", "component1", "()Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket$ResponseType;", "copy", "(Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket$ResponseType;)Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket$ResponseType;", "getResponse", "ResponseType", "1.21.8"})
    public static final class MCRegistrationResponsePacket
    extends ExpectReplyPacket.ReplyPacket {
        @NotNull
        private final ResponseType response;

        public MCRegistrationResponsePacket(@NotNull ResponseType response) {
            Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
            this.response = response;
        }

        @NotNull
        public final ResponseType getResponse() {
            return this.response;
        }

        @NotNull
        public final ResponseType component1() {
            return this.response;
        }

        @NotNull
        public final MCRegistrationResponsePacket copy(@NotNull ResponseType response) {
            Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
            return new MCRegistrationResponsePacket(response);
        }

        public static /* synthetic */ MCRegistrationResponsePacket copy$default(MCRegistrationResponsePacket mCRegistrationResponsePacket, ResponseType responseType, int n, Object object) {
            if ((n & 1) != 0) {
                responseType = mCRegistrationResponsePacket.response;
            }
            return mCRegistrationResponsePacket.copy(responseType);
        }

        @NotNull
        public String toString() {
            return "MCRegistrationResponsePacket(response=" + this.response + ")";
        }

        public int hashCode() {
            return this.response.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MCRegistrationResponsePacket)) {
                return false;
            }
            MCRegistrationResponsePacket mCRegistrationResponsePacket = (MCRegistrationResponsePacket)other;
            return this.response == mCRegistrationResponsePacket.response;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lde/hype/bingonet/shared/packets/network/RequestRegisterPacket$MCRegistrationResponsePacket$ResponseType;", "", "<init>", "(Ljava/lang/String;I)V", "AWAITING_DC_USER_CONFIRMATION", "NOT_ON_DISCORD", "ALREADY_REGISTERED", "BAD_REQUEST", "ERROR", "1.21.8"})
        public static final class ResponseType
        extends Enum<ResponseType> {
            public static final /* enum */ ResponseType AWAITING_DC_USER_CONFIRMATION = new ResponseType();
            public static final /* enum */ ResponseType NOT_ON_DISCORD = new ResponseType();
            public static final /* enum */ ResponseType ALREADY_REGISTERED = new ResponseType();
            public static final /* enum */ ResponseType BAD_REQUEST = new ResponseType();
            public static final /* enum */ ResponseType ERROR = new ResponseType();
            private static final /* synthetic */ ResponseType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ResponseType[] values() {
                return (ResponseType[])$VALUES.clone();
            }

            public static ResponseType valueOf(String value) {
                return Enum.valueOf(ResponseType.class, value);
            }

            @NotNull
            public static EnumEntries<ResponseType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = responseTypeArray = new ResponseType[]{ResponseType.AWAITING_DC_USER_CONFIRMATION, ResponseType.NOT_ON_DISCORD, ResponseType.ALREADY_REGISTERED, ResponseType.BAD_REQUEST, ResponseType.ERROR};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

