/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.PurseChangeCause;
import at.hannibal2.skyhanni.events.PurseChangeEvent;
import at.hannibal2.skyhanni.events.ScoreboardUpdateEvent;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001b\u0010\u001b\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001e\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\u001d\u0010\u001aR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R$\u0010#\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010\u0012\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/data/PurseApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "event", "", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;", "onScoreboardChange", "(Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;)V", "", "diff", "Lat/hannibal2/skyhanni/events/PurseChangeCause;", "getCause", "(D)Lat/hannibal2/skyhanni/events/PurseChangeCause;", "getPurse", "()D", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "coinsPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getCoinsPattern", "()Ljava/util/regex/Pattern;", "coinsPattern", "piggyPattern$delegate", "getPiggyPattern", "piggyPattern", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "inventoryCloseTime", "J", "value", "currentPurse", "D", "getCurrentPurse", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPurseApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurseApi.kt\nat/hannibal2/skyhanni/data/PurseApi\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n27#2:94\n14#2,2:95\n17#2:98\n1#3:97\n*S KotlinDebug\n*F\n+ 1 PurseApi.kt\nat/hannibal2/skyhanni/data/PurseApi\n*L\n50#1:94\n50#1:95,2\n50#1:98\n50#1:97\n*E\n"})
public final class PurseApi {
    @NotNull
    public static final PurseApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern coinsPattern$delegate;
    @NotNull
    private static final RepoPattern piggyPattern$delegate;
    private static long inventoryCloseTime;
    private static double currentPurse;

    private PurseApi() {
    }

    @NotNull
    public final Pattern getCoinsPattern() {
        return (Pattern)coinsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @NotNull
    public final Pattern getPiggyPattern() {
        return (Pattern)piggyPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    public final double getCurrentPurse() {
        return currentPurse;
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        inventoryCloseTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onScoreboardChange(@NotNull ScoreboardUpdateEvent event2) {
        void $this$firstMatcher$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(event2, "event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getCoinsPattern();
        List<String> list$iv = event2.getAdded();
        boolean $i$f$firstMatcher = false;
        void var6_6 = this_$iv;
        void var7_7 = $this$firstMatcher$iv;
        Sequence sequence$iv$iv = CollectionsKt.asSequence((Iterable)list$iv);
        boolean $i$f$firstMatcher2 = false;
        Iterator iterator2 = sequence$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$firstMatcher$iv$iv;
            String line$iv$iv = (String)iterator2.next();
            Matcher it$iv$iv = $this$firstMatcher$iv$iv.matcher(line$iv$iv);
            boolean bl = false;
            if (!it$iv$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv$iv);
            Matcher $this$onScoreboardChange_u24lambda_u240 = it$iv$iv;
            boolean bl2 = false;
            String string = $this$onScoreboardChange_u24lambda_u240.group("coins");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            double newPurse = NumberUtil.INSTANCE.formatDouble(string);
            double diff = newPurse - currentPurse;
            if (diff == 0.0) {
                return;
            }
            currentPurse = newPurse;
            new PurseChangeEvent(diff, currentPurse, INSTANCE.getCause(diff)).post();
            break;
        }
    }

    private final PurseChangeCause getCause(double diff) {
        if (diff > 0.0) {
            if (diff == 1.0) {
                return PurseChangeCause.GAIN_TALISMAN_OF_COINS;
            }
            if (diff == NumberUtil.INSTANCE.getMillion(15) || diff == NumberUtil.INSTANCE.getMillion(100)) {
                return PurseChangeCause.GAIN_DICE_ROLL;
            }
            if (Minecraft.func_71410_x().field_71462_r == null) {
                if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(inventoryCloseTime), DurationKt.toDuration(2, DurationUnit.SECONDS)) > 0) {
                    return PurseChangeCause.GAIN_MOB_KILL;
                }
            }
            return PurseChangeCause.GAIN_UNKNOWN;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(SlayerApi.INSTANCE.getQuestStartTime-uFjCsEo()), DurationKt.toDuration(1.5, DurationUnit.SECONDS)) < 0) {
            return PurseChangeCause.LOSE_SLAYER_QUEST_STARTED;
        }
        if (diff == -6666666.0 || diff == -666666.0) {
            return PurseChangeCause.LOSE_DICE_ROLL_COST;
        }
        return PurseChangeCause.LOSE_UNKNOWN;
    }

    public final double getPurse() {
        return currentPurse;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PurseApi.class, "coinsPattern", "getCoinsPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PurseApi.class, "piggyPattern", "getPiggyPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PurseApi();
        patternGroup = RepoPattern.Companion.group("data.purse");
        coinsPattern$delegate = patternGroup.pattern("coins", "(?:\u00a7.)*(?:Piggy|Purse): \u00a76(?<coins>[\\d,.]+)(?: ?(?:\u00a7.)*\\([+-](?<earned>[\\d,.]+)\\)?|.*)?$");
        piggyPattern$delegate = patternGroup.pattern("piggy", "(?:\u00a7.)*Piggy: (?<coins>.*)");
        inventoryCloseTime = SimpleTimeMark.Companion.farPast();
    }
}

