/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.tftp;

import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPAckPacket;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPDataPacket;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPErrorPacket;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPPacketException;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPReadRequestPacket;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPWriteRequestPacket;
import java.net.DatagramPacket;
import java.net.InetAddress;

public abstract class TFTPPacket {
    static final int MIN_PACKET_SIZE = 4;
    public static final int READ_REQUEST = 1;
    public static final int WRITE_REQUEST = 2;
    public static final int DATA = 3;
    public static final int ACKNOWLEDGEMENT = 4;
    public static final int ERROR = 5;
    public static final int SEGMENT_SIZE = 512;
    int type;
    int port;
    InetAddress address;

    public static final TFTPPacket newTFTPPacket(DatagramPacket datagram) throws TFTPPacketException {
        TFTPPacket packet;
        if (datagram.getLength() < 4) {
            throw new TFTPPacketException("Bad packet. Datagram data length is too short.");
        }
        byte[] data2 = datagram.getData();
        switch (data2[1]) {
            case 1: {
                packet = new TFTPReadRequestPacket(datagram);
                break;
            }
            case 2: {
                packet = new TFTPWriteRequestPacket(datagram);
                break;
            }
            case 3: {
                packet = new TFTPDataPacket(datagram);
                break;
            }
            case 4: {
                packet = new TFTPAckPacket(datagram);
                break;
            }
            case 5: {
                packet = new TFTPErrorPacket(datagram);
                break;
            }
            default: {
                throw new TFTPPacketException("Bad packet.  Invalid TFTP operator code.");
            }
        }
        return packet;
    }

    TFTPPacket(int type2, InetAddress address, int port) {
        this.type = type2;
        this.address = address;
        this.port = port;
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getType() {
        return this.type;
    }

    public abstract DatagramPacket newDatagram();

    abstract DatagramPacket newDatagram(DatagramPacket var1, byte[] var2);

    public final void setAddress(InetAddress address) {
        this.address = address;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return this.address + " " + this.port + " " + this.type;
    }
}

