/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui;

import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class GuiComponent {
    protected final IMinecraft mc = IMinecraft.INSTANCE;
    GuiContext context;

    protected GuiComponent() {
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void requestFocus() {
        if (this.context != null) {
            this.context.setFocusedElement(this);
        }
    }

    public void blur() {
        if (this.context != null && this.context.getFocusedElement() == this) {
            this.context.setFocusedElement(null);
        }
    }

    public void setFocus(boolean shouldFocus) {
        if (shouldFocus) {
            this.requestFocus();
        } else {
            this.blur();
        }
    }

    public boolean isFocused() {
        return this.context != null && this.context.getFocusedElement() == this;
    }

    public boolean isInFocus() {
        return this.foldRecursive(false, (element, isFocused) -> isFocused != false || element.isFocused());
    }

    public void onLostFocus() {
    }

    public void onGainedFocus() {
    }

    public final <T> T foldRecursive(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor2) {
        return (T)this.foldChildren(visitor2.apply(this, (GuiComponent)initial), (element, state) -> element.foldRecursive(state, visitor2));
    }

    public <T> T foldChildren(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor2) {
        return initial;
    }

    public abstract void render(@NotNull GuiImmediateContext var1);

    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        return false;
    }

    public boolean keyboardEvent(@NotNull KeyboardEvent event2, @NotNull GuiImmediateContext context2) {
        return false;
    }

    public void setContext(GuiContext context2) {
        this.context = context2;
    }

    public GuiContext getContext() {
        return this.context;
    }
}

