/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui;

import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiElement;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Warnings;
import org.jetbrains.annotations.NotNull;

public final class GuiElementComponent
extends GuiComponent {
    private final GuiElement element;

    @Override
    public void setContext(GuiContext context2) {
        super.setContext(context2);
        if (context2.getRoot() != this) {
            Warnings.warn("Mounting GuiElementComponent at location other than root. This can cause issues.");
        }
    }

    @Override
    public int getWidth() {
        return this.mc.getScaledWidth();
    }

    @Override
    public int getHeight() {
        return this.mc.getScaledHeight();
    }

    @Override
    public void render(@NotNull GuiImmediateContext context2) {
        if (context2.getRenderOffsetX() != 0 || context2.getRenderOffsetY() != 0) {
            Warnings.warn("Cannot render GuiElement with a pretransformed matrix stack");
        }
        this.element.render();
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        return this.element.mouseInput(context2.getMouseX(), context2.getMouseY(), mouseEvent);
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event2, @NotNull GuiImmediateContext context2) {
        return this.element.keyboardInput(event2);
    }

    public GuiElementComponent(GuiElement element) {
        this.element = element;
    }

    public GuiElement getElement() {
        return this.element;
    }

    public String toString() {
        return "GuiElementComponent(element=" + this.getElement() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementComponent)) {
            return false;
        }
        GuiElementComponent other = (GuiElementComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GuiElement this$element = this.getElement();
        GuiElement other$element = other.getElement();
        return !(this$element == null ? other$element != null : !this$element.equals(other$element));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = super.hashCode();
        GuiElement $element = this.getElement();
        result2 = result2 * 59 + ($element == null ? 43 : $element.hashCode());
        return result2;
    }
}

