/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class RowComponent
extends GuiComponent {
    final List<GuiComponent> children;

    public RowComponent(List<GuiComponent> children2) {
        this.children = children2;
    }

    public RowComponent(GuiComponent ... children2) {
        this(Arrays.asList(children2));
    }

    @Override
    public int getWidth() {
        return this.foldChildren(0, (child, width) -> child.getWidth() + width);
    }

    @Override
    public int getHeight() {
        return this.foldChildren(0, (child, height) -> Math.max(child.getHeight(), height));
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor2) {
        for (GuiComponent child : this.children) {
            initial = visitor2.apply(child, (GuiComponent)initial);
        }
        return initial;
    }

    public void foldWithContext(GuiImmediateContext context2, BiConsumer<GuiComponent, GuiImmediateContext> visitor2) {
        int height = context2.getHeight();
        this.foldChildren(0, (child, position) -> {
            visitor2.accept((GuiComponent)child, context2.translated((int)position, 0, child.getWidth(), height));
            return child.getWidth() + position;
        });
    }

    @Override
    public void render(GuiImmediateContext context2) {
        context2.getRenderContext().pushMatrix();
        this.foldWithContext(context2, (child, childContext) -> {
            child.render((GuiImmediateContext)childContext);
            context2.getRenderContext().translate(child.getWidth(), 0.0f);
        });
        context2.getRenderContext().popMatrix();
    }

    @Override
    public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context2) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context2, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.mouseEvent(mouseEvent, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    @Override
    public boolean keyboardEvent(KeyboardEvent event2, GuiImmediateContext context2) {
        boolean[] wasHandled = new boolean[1];
        this.foldWithContext(context2, (guiComponent, guiImmediateContext) -> {
            if (guiComponent.keyboardEvent(event2, (GuiImmediateContext)guiImmediateContext)) {
                wasHandled[0] = true;
            }
        });
        return wasHandled[0];
    }

    public String toString() {
        return "RowComponent(children=" + this.children + ")";
    }
}

