/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.DescriptionRendereringBehaviour;
import at.hannibal2.skyhanni.deps.moulconfig.TitleRenderingBehaviour;
import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.component.CenterComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.component.PanelComponent;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

public abstract class ComponentEditor
extends GuiOptionEditor {
    private static final int HEIGHT = 45;
    @Nullable
    private GuiComponent overlay;
    private int overlayX;
    private int overlayY;
    private int lastRenderX;
    private int lastRenderY;
    private int lastRenderWidth;
    private int lastRenderHeight;

    protected ComponentEditor(ProcessedOption option) {
        super(option);
    }

    @NotNull
    public abstract GuiComponent getDelegate();

    public void closeOverlay() {
        this.overlay = null;
    }

    public boolean isOverlayOpen() {
        return this.overlay != null;
    }

    public void openOverlay(GuiComponent overlay, int overlayX, int overlayY) {
        this.overlay = overlay;
        this.overlayX = overlayX;
        this.overlayY = overlayY;
    }

    @Nullable
    public GuiComponent getOverlayDelegate() {
        return this.overlay;
    }

    public GuiImmediateContext getImmContext(int x, int y, int width, int height, RenderContext renderContext) {
        IMinecraft instance = IMinecraft.INSTANCE;
        return new GuiImmediateContext(renderContext, x, y, width, height, instance.getMouseX() - x, instance.getMouseY() - y, instance.getMouseX(), instance.getMouseY(), (float)instance.getMouseXHF() - (float)x, (float)instance.getMouseYHF() - (float)y);
    }

    protected GuiComponent wrapComponent(GuiComponent component, @Nullable GuiComponent bottomComponent) {
        return new EditorComponentWrapper(new CenterComponent(component), bottomComponent);
    }

    protected GuiComponent wrapComponent(GuiComponent component) {
        return new EditorComponentWrapper(new CenterComponent(component));
    }

    @Override
    public int getHeight() {
        return Math.max(this.getDelegate().getHeight(), super.getHeight());
    }

    @Override
    public final boolean mouseInput(int x, int y, int width, int mouseX, int mouseY, MouseEvent mouseEvent) {
        return this.getDelegate().mouseEvent(mouseEvent, this.getImmContext(x, y, width, this.getHeight(), IMinecraft.INSTANCE.provideTopLevelRenderContext()));
    }

    @Override
    public final boolean keyboardInput(KeyboardEvent keyboardEvent) {
        GuiImmediateContext ctx = this.getImmContext(this.lastRenderX, this.lastRenderY, this.lastRenderWidth, this.lastRenderHeight, IMinecraft.INSTANCE.provideTopLevelRenderContext());
        GuiComponent overlay = this.getOverlayDelegate();
        if (overlay != null) {
            overlay.foldRecursive(null, (comp, _void) -> {
                comp.setContext(this.getDelegate().getContext());
                return _void;
            });
            if (overlay.keyboardEvent(keyboardEvent, ctx)) {
                return true;
            }
        }
        return this.getDelegate().keyboardEvent(keyboardEvent, ctx);
    }

    @Override
    public void setGuiContext(GuiContext guiContext) {
        this.getDelegate().foldRecursive(null, (comp, _void) -> {
            comp.setContext(guiContext);
            return _void;
        });
    }

    @Override
    public final void render(RenderContext renderContext, int x, int y, int width) {
        this.lastRenderX = x;
        this.lastRenderY = y;
        this.lastRenderWidth = width;
        this.lastRenderHeight = this.getHeight();
        GuiImmediateContext context2 = this.getImmContext(x, y, width, this.getHeight(), renderContext);
        context2.getRenderContext().pushMatrix();
        context2.getRenderContext().translate(context2.getRenderOffsetX(), context2.getRenderOffsetY());
        this.getDelegate().render(context2);
        context2.getRenderContext().popMatrix();
    }

    @Override
    public final boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY, MouseEvent event2) {
        if (this.overlay == null) {
            return false;
        }
        this.overlay.foldRecursive(null, (comp, _void) -> {
            comp.setContext(this.getDelegate().getContext());
            return _void;
        });
        return this.overlay.mouseEvent(event2, this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight(), IMinecraft.INSTANCE.provideTopLevelRenderContext()));
    }

    @Override
    public final void renderOverlay(RenderContext context2, int x, int y, int width) {
        if (this.overlay == null) {
            return;
        }
        this.overlay.foldRecursive(null, (comp, _void) -> {
            comp.setContext(this.getDelegate().getContext());
            return _void;
        });
        GuiImmediateContext ctx = this.getImmContext(this.overlayX, this.overlayY, this.overlay.getWidth(), this.overlay.getHeight(), context2);
        ctx.getRenderContext().translate(this.overlayX, this.overlayY);
        this.overlay.render(ctx);
    }

    public int getOverlayX() {
        return this.overlayX;
    }

    public int getOverlayY() {
        return this.overlayY;
    }

    @NullMarked
    public class EditorComponentWrapper
    extends PanelComponent {
        @Nullable
        public final GuiComponent bottomComponent;
        int bottomOffset;

        public EditorComponentWrapper(GuiComponent component) {
            this(component, null);
        }

        public EditorComponentWrapper(@Nullable GuiComponent component, GuiComponent bottomComponent) {
            super(component);
            this.bottomOffset = 0;
            this.bottomComponent = bottomComponent;
        }

        @Override
        public int getWidth() {
            return super.getWidth() + 150;
        }

        protected int getDescriptionHeight() {
            if (ComponentEditor.this.option.getConfig().getDescriptionBehaviour(ComponentEditor.this.option) == DescriptionRendereringBehaviour.SCALE_TEXT) {
                return super.getHeight();
            }
            IFontRenderer fr = IMinecraft.INSTANCE.getDefaultFontRenderer();
            return Math.max(45, fr.splitText(ComponentEditor.this.option.getDescription(), 156).size() * (fr.getHeight() + 1) + 10);
        }

        public int getTopHeight() {
            int height = this.getDescriptionHeight();
            if (ComponentEditor.this.option.getConfig().getTitleRenderingBehaviour(ComponentEditor.this.option) != TitleRenderingBehaviour.LEFT) {
                height += IMinecraft.INSTANCE.getDefaultFontRenderer().getHeight() + 1;
            }
            return Math.max(45, height);
        }

        @Override
        public int getHeight() {
            return this.getTopHeight() + (this.bottomComponent != null ? this.bottomComponent.getHeight() + 10 : 0);
        }

        @Override
        protected GuiImmediateContext getChildContext(GuiImmediateContext context2) {
            return context2.translated(5, 15, context2.getWidth() / 3 - 10, context2.getHeight() - 15);
        }

        protected int getEffectiveTopHeight(GuiImmediateContext context2) {
            return Math.min(context2.getHeight(), this.getTopHeight());
        }

        protected GuiImmediateContext getBottomContext(GuiImmediateContext context2) {
            int effectiveTopHeight = this.getEffectiveTopHeight(context2);
            return context2.translated(5, effectiveTopHeight + this.bottomOffset, context2.getWidth() - 10, context2.getHeight() - effectiveTopHeight - this.bottomOffset - 8);
        }

        protected GuiImmediateContext getTopContext(GuiImmediateContext context2) {
            return context2.translated(0, 0, context2.getWidth(), this.getEffectiveTopHeight(context2));
        }

        @Override
        public void render(GuiImmediateContext context2) {
            context2.getRenderContext().drawDarkRect(0, 0, context2.getWidth(), context2.getHeight() - 2);
            GuiImmediateContext topContext = this.getTopContext(context2);
            this.renderTitle(topContext);
            this.renderDescription(topContext);
            this.renderElement(topContext);
            context2.getRenderContext().pushMatrix();
            context2.getRenderContext().translate(5.0f, this.getEffectiveTopHeight(context2) + this.bottomOffset);
            this.renderBottomElement(this.getBottomContext(context2));
            context2.getRenderContext().popMatrix();
        }

        protected void renderBottomElement(GuiImmediateContext context2) {
            if (this.bottomComponent != null) {
                this.bottomComponent.render(context2);
            }
        }

        protected void renderElement(GuiImmediateContext context2) {
            context2.getRenderContext().pushMatrix();
            context2.getRenderContext().translate(5.0f, 15.0f);
            this.getElement().render(this.getChildContext(context2));
            context2.getRenderContext().popMatrix();
        }

        protected void renderTitle(GuiImmediateContext context2) {
            int width = context2.getWidth();
            IMinecraft minecraft = context2.getRenderContext().getMinecraft();
            IFontRenderer fr = minecraft.getDefaultFontRenderer();
            switch (ComponentEditor.this.option.getConfig().getTitleRenderingBehaviour(ComponentEditor.this.option)) {
                case WIDE_CENTERED_UNDERLINED: {
                    context2.getRenderContext().drawHorizontalLine(16, 10, width - 10, -12566464);
                }
                case WIDE_CENTERED: {
                    context2.getRenderContext().drawStringCenteredScaledMaxWidth(ComponentEditor.this.option.getName(), fr, width / 2, 10.0f, true, width - 10, 0xE0E0E0);
                    break;
                }
                case LEFT: {
                    context2.getRenderContext().drawStringCenteredScaledMaxWidth(ComponentEditor.this.option.getName(), fr, width / 6, 10.0f, true, width / 3 - 10, 0xE0E0E0);
                }
            }
        }

        @Override
        public boolean mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context2) {
            if (super.mouseEvent(mouseEvent, this.getTopContext(context2))) {
                return true;
            }
            return this.bottomComponent != null && this.bottomComponent.mouseEvent(mouseEvent, this.getBottomContext(context2));
        }

        @Override
        public boolean keyboardEvent(KeyboardEvent event2, GuiImmediateContext context2) {
            if (super.keyboardEvent(event2, this.getTopContext(context2))) {
                return true;
            }
            return this.bottomComponent != null && this.bottomComponent.keyboardEvent(event2, this.getBottomContext(context2));
        }

        protected void renderDescription(@NotNull GuiImmediateContext context2) {
            List<StructuredText> lines;
            int width = context2.getWidth();
            IMinecraft minecraft = context2.getRenderContext().getMinecraft();
            IFontRenderer fr = minecraft.getDefaultFontRenderer();
            int yOffset = ComponentEditor.this.option.getConfig().getTitleRenderingBehaviour(ComponentEditor.this.option) != TitleRenderingBehaviour.LEFT ? fr.getHeight() + 13 : 5;
            float scale = 1.0f;
            int descriptionHeight = context2.getHeight() - yOffset;
            while (!((float)(lines = fr.splitText(ComponentEditor.this.option.getDescription(), (int)((float)(width * 2 / 3) / scale - 10.0f))).size() * scale * (float)(fr.getHeight() + 1) < (float)descriptionHeight) && !((scale -= 0.125f) < 0.0625f)) {
            }
            context2.getRenderContext().pushMatrix();
            context2.getRenderContext().translate(5 + width / 3, yOffset);
            context2.getRenderContext().scale(scale, scale);
            for (StructuredText line : lines) {
                context2.getRenderContext().drawString(fr, line, 0, 0, 0xC0C0C0, false);
                context2.getRenderContext().translate(0.0f, fr.getHeight() + 1);
            }
            context2.getRenderContext().popMatrix();
        }
    }
}

