/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.GuiTextures;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.common.TextureFilter;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.internal.KeybindHelper;
import at.hannibal2.skyhanni.deps.moulconfig.internal.TextRenderUtils;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.util.Collections;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorKeybindL
extends GuiOptionEditor {
    private final int defaultKeyCode;
    private boolean editingKeycode;
    private Pair<Integer, Integer> lastMousePosition = null;

    public GuiOptionEditorKeybindL(ProcessedOption option, int defaultKeyCode) {
        super(option);
        this.defaultKeyCode = defaultKeyCode;
    }

    @Override
    public void render(RenderContext renderContext, int x, int y, int width) {
        super.render(renderContext, x, y, width);
        int height = this.getHeight();
        renderContext.drawTexturedRect(GuiTextures.BUTTON, x + width / 6 - 24, y + height - 7 - 14, 48.0f, 16.0f);
        String keyName = KeybindHelper.getKeyName((Integer)this.option.get());
        String text = this.editingKeycode ? "> " + keyName + " <" : keyName;
        TextRenderUtils.drawStringCenteredScaledMaxWidth(text, Minecraft.func_71410_x().field_71466_p, x + width / 6, y + height - 7 - 6, false, 38, -13619152);
        int resetX = x + width / 6 - 24 + 48 + 3;
        int resetY = y + height - 7 - 14 + 3;
        IMinecraft mc = IMinecraft.INSTANCE;
        renderContext.drawComplexTexture(GuiTextures.RESET, resetX, resetY, 10.0f, 11.0f, it -> it.filter(TextureFilter.NEAREST));
        if (this.lastMousePosition != null && this.lastMousePosition.getFirst() >= resetX && this.lastMousePosition.getFirst() < resetX + 10 && this.lastMousePosition.getSecond() >= resetY && this.lastMousePosition.getSecond() < resetY + 11) {
            renderContext.scheduleDrawTooltip(mc.getMouseX(), mc.getMouseY(), Collections.singletonList(StructuredText.of("Reset to Default").darkRed()));
        }
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        this.lastMousePosition = new Pair<Integer, Integer>(mouseX, mouseY);
        if (Mouse.getEventButtonState() && Mouse.getEventButton() != -1 && this.editingKeycode) {
            this.editingKeycode = false;
            this.option.set(Mouse.getEventButton() - 100);
            return true;
        }
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            int height = this.getHeight();
            if (mouseX > x + width / 6 - 24 && mouseX < x + width / 6 + 24 && mouseY > y + height - 7 - 14 && mouseY < y + height - 7 + 2) {
                this.editingKeycode = true;
                return true;
            }
            if (mouseX > x + width / 6 - 24 + 48 + 3 && mouseX < x + width / 6 - 24 + 48 + 13 && mouseY > y + height - 7 - 14 + 3 && mouseY < y + height - 7 - 14 + 3 + 11) {
                this.option.set(this.defaultKeyCode);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (this.editingKeycode) {
            this.editingKeycode = false;
            int keyCode = 0;
            if (Keyboard.getEventKey() != 1 && Keyboard.getEventKey() != 0) {
                keyCode = Keyboard.getEventKey();
            }
            if (keyCode > 256) {
                keyCode = 0;
            }
            this.option.set(keyCode);
            return true;
        }
        return false;
    }
}

