/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.processor;

import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.SearchTag;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.gui.editors.GuiOptionEditorAccordion;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedCategory;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ProcessedOptionImpl
implements ProcessedOption,
ProcessedOption.HasField {
    final StructuredText name;
    final StructuredText desc;
    final Field field;
    final String path;
    final ProcessedCategory category;
    final Object container;
    GuiOptionEditor editor;
    int accordionId = -1;
    boolean isProperty;
    Config config;
    private GuiOptionEditorAccordion owningAccordion;

    public ProcessedOptionImpl(StructuredText name2, StructuredText desc, String path, Field field, ProcessedCategory category, Object container, Config config) {
        this.name = name2;
        this.path = path;
        this.desc = desc;
        this.category = category;
        this.config = config;
        this.field = field;
        this.container = container;
        this.isProperty = field.getType() == Property.class;
    }

    @Override
    public SearchTag[] getSearchTags() {
        return (SearchTag[])this.field.getAnnotationsByType(SearchTag.class);
    }

    @Override
    public String getDebugDeclarationLocation() {
        return this.field.toString();
    }

    public GuiOptionEditorAccordion getOwningAccordion() {
        if (this.owningAccordion == null && this.getAccordionId() >= 0) {
            this.owningAccordion = this.getCategory().getOptions().stream().map(ProcessedOption::getEditor).filter(it -> it instanceof GuiOptionEditorAccordion).map(it -> (GuiOptionEditorAccordion)it).filter(it -> it.getAccordionId() == this.getAccordionId()).findAny().orElse(null);
        }
        return this.owningAccordion;
    }

    @Override
    public int getAccordionId() {
        return this.accordionId;
    }

    @Override
    public GuiOptionEditor getEditor() {
        return this.editor;
    }

    @Override
    public ProcessedCategory getCategory() {
        return this.category;
    }

    @Override
    public StructuredText getName() {
        return this.name;
    }

    @Override
    public StructuredText getDescription() {
        return this.desc;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Object get() {
        try {
            Object obj = this.field.get(this.container);
            if (this.isProperty) {
                return ((Property)obj).get();
            }
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Type getType() {
        if (this.isProperty) {
            return ((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
        }
        return this.field.getGenericType();
    }

    @Override
    public boolean set(Object value) {
        try {
            Object toSet = this.getType() == Integer.TYPE && value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : value;
            if (this.isProperty) {
                ((Property)this.field.get(this.container)).set(toSet);
            } else {
                this.field.set(this.container, toSet);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void explicitNotifyChange() {
        if (this.isProperty) {
            try {
                ((Property)this.field.get(this.container)).notifyObservers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Field getField() {
        return this.field;
    }
}

