/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.chat;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.features.misc.visualwords.ModifyVisualWords;
import at.hannibal2.skyhanni.mixins.transformers.AccessorMixinGuiNewChat;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ClipboardUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.ReflectionUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.GuiScreenUtils;
import at.hannibal2.skyhanni.utils.compat.MouseCompat;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ!\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0016\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lat/hannibal2/skyhanni/features/chat/CopyChat;", "", "<init>", "()V", "", "mouseX", "mouseY", "", "handleCopyChat", "(II)V", "processCopyChat", "Lnet/minecraft/client/gui/ChatLine;", "getChatLine", "(II)Lnet/minecraft/client/gui/ChatLine;", "getOffset", "()I", "", "getConfig", "()Z", "config", "isPatcherLoaded$delegate", "Lkotlin/Lazy;", "isPatcherLoaded", "1.8.9"})
public final class CopyChat {
    @NotNull
    public static final CopyChat INSTANCE = new CopyChat();
    @NotNull
    private static final Lazy isPatcherLoaded$delegate = LazyKt.lazy(CopyChat::isPatcherLoaded_delegate$lambda$0);

    private CopyChat() {
    }

    private final boolean getConfig() {
        return SkyHanniMod.feature.getChat().getCopyChat();
    }

    @JvmStatic
    public static final void handleCopyChat(int mouseX, int mouseY) {
        try {
            if (!INSTANCE.getConfig()) {
                return;
            }
            INSTANCE.processCopyChat(mouseX, mouseY);
        }
        catch (Exception e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while copying chat line", new Pair[0], false, false, false, 56, null);
        }
    }

    private final void processCopyChat(int mouseX, int mouseY) {
        Pair<String, String> pair;
        ChatLine chatLine;
        if (PlatformUtils.INSTANCE.getIS_LEGACY() ? (chatLine = this.getChatLine(MouseCompat.INSTANCE.getX(), MouseCompat.INSTANCE.getY())) == null : (chatLine = this.getChatLine(mouseX, mouseY)) == null) {
            return;
        }
        ChatLine chatLine2 = chatLine;
        String formatted = ChatUtils.INSTANCE.getFullComponent(chatLine2).func_150254_d();
        if (KeyboardManager.INSTANCE.isMenuKeyDown()) {
            Intrinsics.checkNotNull(formatted);
            pair = TuplesKt.to(StringUtils.INSTANCE.stripHypixelMessage(formatted), "formatted message");
        } else if (KeyboardManager.INSTANCE.isShiftKeyDown()) {
            String string = ModifyVisualWords.INSTANCE.modifyText(formatted);
            if (string == null || (string = StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null)) == null) {
                string = formatted;
            }
            pair = TuplesKt.to(string, "modified message");
        } else if (KeyboardManager.INSTANCE.isControlKeyDown()) {
            pair = TuplesKt.to(StringUtils.removeColor$default(StringUtils.INSTANCE, ChatUtils.INSTANCE.getChatMessage(chatLine2), false, 1, null), "line");
        } else {
            Intrinsics.checkNotNull(formatted);
            pair = TuplesKt.to(StringUtils.removeColor$default(StringUtils.INSTANCE, formatted, false, 1, null), "message");
        }
        Pair<String, String> pair2 = pair;
        String clipboard = pair2.component1();
        String infoMessage = pair2.component2();
        ClipboardUtils.copyToClipboard$default(ClipboardUtils.INSTANCE, clipboard, 0, 2, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied " + infoMessage + " to clipboard!", false, null, false, false, null, 62, null);
    }

    private final ChatLine getChatLine(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            return null;
        }
        Minecraft mc = minecraft;
        GuiNewChat guiNewChat = mc.field_71456_v.func_146158_b();
        if (guiNewChat == null) {
            return null;
        }
        GuiNewChat chatGui = guiNewChat;
        AccessorMixinGuiNewChat access = (AccessorMixinGuiNewChat)chatGui;
        float chatScale = chatGui.func_146244_h();
        int scaleFactor = GuiScreenUtils.INSTANCE.getScaleFactor();
        int x = MathHelper.func_76141_d((float)((float)(mouseX / scaleFactor - 3) / chatScale));
        int y = MathHelper.func_76141_d((float)((float)(mouseY / scaleFactor - 27 - this.getOffset()) / chatScale));
        if (x < 0 || y < 0) {
            return null;
        }
        int fontHeight = mc.field_71466_p.field_78288_b;
        List<ChatLine> chatLines = access.getDrawnChatLines_skyhanni();
        int maxLines = RangesKt.coerceAtMost(chatGui.func_146232_i(), chatLines.size());
        if (x <= MathHelper.func_76141_d((float)((float)chatGui.func_146228_f() / chatGui.func_146244_h())) && y < fontHeight * maxLines + maxLines) {
            int lineIndex = y / fontHeight + access.getScrollPos_skyhanni();
            boolean bl = 0 <= lineIndex ? lineIndex < chatLines.size() : false;
            if (bl) {
                return chatLines.get(lineIndex);
            }
        }
        return null;
    }

    private final boolean isPatcherLoaded() {
        Lazy lazy = isPatcherLoaded$delegate;
        return (Boolean)lazy.getValue();
    }

    private final int getOffset() {
        Object object;
        if (!this.isPatcherLoaded()) {
            return 0;
        }
        Object object2 = this;
        try {
            CopyChat $this$getOffset_u24lambda_u241 = object2;
            boolean bl = false;
            Class<?> patcherConfigClass = Class.forName("club.sk1er.patcher.config.PatcherConfig");
            Intrinsics.checkNotNull(patcherConfigClass);
            Field field = ReflectionUtils.INSTANCE.getDeclaredFieldOrNull(patcherConfigClass, "chatPosition");
            object = Result.constructor-impl((field != null ? field.getBoolean(null) : false) ? 12 : 0);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        object = 0;
        return ((Number)(Result.isFailure-impl(object2) ? object : object2)).intValue();
    }

    private static final boolean isPatcherLoaded_delegate$lambda$0() {
        return PlatformUtils.INSTANCE.isModInstalled("patcher");
    }
}

