/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.fishing.FishingHookDisplayConfig;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.events.fishing.FishingBobberCastEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.entity.item.EntityArmorStand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u001d\u0010\u000e\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u001a\u001a\u00020\u0019*\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010\"\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingHookDisplay;", "", "<init>", "()V", "", "onWorldChange", "Lat/hannibal2/skyhanni/events/fishing/FishingBobberCastEvent;", "event", "onBobberThrow", "(Lat/hannibal2/skyhanni/events/fishing/FishingBobberCastEvent;)V", "onTick", "reset", "Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;", "Lnet/minecraft/entity/item/EntityArmorStand;", "onJoinWorld", "(Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;)V", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "hasCorrectName", "(Lnet/minecraft/entity/item/EntityArmorStand;)Z", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/FishingHookDisplayConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishingHookDisplayConfig;", "config", "armorStand", "Lnet/minecraft/entity/item/EntityArmorStand;", "", "potentialArmorStands", "Ljava/util/List;", "Ljava/util/regex/Pattern;", "pattern", "Ljava/util/regex/Pattern;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nFishingHookDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingHookDisplay.kt\nat/hannibal2/skyhanni/features/fishing/FishingHookDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n*S KotlinDebug\n*F\n+ 1 FishingHookDisplay.kt\nat/hannibal2/skyhanni/features/fishing/FishingHookDisplay\n*L\n39#1:97\n39#1:98,2\n*E\n"})
public final class FishingHookDisplay {
    @NotNull
    public static final FishingHookDisplay INSTANCE = new FishingHookDisplay();
    @Nullable
    private static EntityArmorStand armorStand;
    @NotNull
    private static final List<EntityArmorStand> potentialArmorStands;
    @NotNull
    private static final Pattern pattern;

    private FishingHookDisplay() {
    }

    private final FishingHookDisplayConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getFishingHookDisplay();
    }

    @HandleEvent
    public final void onWorldChange() {
        this.reset();
    }

    @HandleEvent
    public final void onBobberThrow(@NotNull FishingBobberCastEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        if (armorStand == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = potentialArmorStands;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EntityArmorStand it = (EntityArmorStand)element$iv$iv;
                boolean bl = false;
                if (!(it.func_145818_k_() && INSTANCE.hasCorrectName(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filter2 = (List)destination$iv$iv;
            if (filter2.size() == 1) {
                armorStand = (EntityArmorStand)filter2.get(0);
            }
        }
    }

    private final void reset() {
        potentialArmorStands.clear();
        armorStand = null;
    }

    @HandleEvent
    public final void onJoinWorld(@NotNull EntityEnterWorldEvent<EntityArmorStand> event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        potentialArmorStands.add(event2.getEntity());
    }

    @HandleEvent
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<EntityArmorStand> event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().getHideArmorStand()) {
            return;
        }
        if (Intrinsics.areEqual(event2.getEntity(), armorStand)) {
            event2.cancel();
        }
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        EntityArmorStand entityArmorStand = armorStand;
        if (entityArmorStand == null) {
            return;
        }
        EntityArmorStand armorStand = entityArmorStand;
        if (armorStand.field_70128_L) {
            this.reset();
            return;
        }
        if (!armorStand.func_145818_k_()) {
            return;
        }
        String alertText = Intrinsics.areEqual(armorStand.func_70005_c_(), "\u00a7c\u00a7l!!!") ? StringsKt.replace$default(this.getConfig().getCustomAlertText(), "&", "\u00a7", false, 4, null) : armorStand.func_70005_c_();
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), alertText, 0, 0, "Fishing Hook Display", 6, null);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.transform(72, "fishing.fishingHookDisplay.position", (Function1<? super JsonElement, ? extends JsonElement>)new Function1<JsonElement, JsonElement>((Object)Position.Companion){

            public final JsonElement invoke(JsonElement p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((Position.Companion)this.receiver).migrate(p0);
            }
        });
    }

    private final boolean hasCorrectName(EntityArmorStand $this$hasCorrectName) {
        if (Intrinsics.areEqual($this$hasCorrectName.func_70005_c_(), "\u00a7c\u00a7l!!!")) {
            return true;
        }
        return pattern.matcher($this$hasCorrectName.func_70005_c_()).matches();
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getEnabled() && FishingApi.INSTANCE.getHoldingRod();
    }

    static {
        potentialArmorStands = new ArrayList();
        String string = "\u00a7e\u00a7l(\\d+(\\.\\d+)?)";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        FishingHookDisplay.pattern = pattern;
    }
}

