/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.pests.PestSpawnConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.garden.pests.PestSpawnEvent;
import at.hannibal2.skyhanni.features.garden.pests.PestApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001b\u0010\u001c\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001f\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u001bR\u001b\u0010\"\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0019\u001a\u0004\b!\u0010\u001bR\u001b\u0010%\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u001b\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestSpawn;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "", "amount", "", "", "plotNames", "spawn", "(Ljava/lang/Integer;Ljava/util/List;)V", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestSpawnConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestSpawnConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "onePestPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getOnePestPattern", "()Ljava/util/regex/Pattern;", "onePestPattern", "multiplePestsPattern$delegate", "getMultiplePestsPattern", "multiplePestsPattern", "offlinePestsPattern$delegate", "getOfflinePestsPattern", "offlinePestsPattern", "clickToTPPattern$delegate", "getClickToTPPattern", "clickToTPPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPestSpawn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestSpawn.kt\nat/hannibal2/skyhanni/features/garden/pests/PestSpawn\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n8#2:110\n8#2:112\n8#2:114\n8#2:116\n1#3:111\n1#3:113\n1#3:115\n1#3:117\n*S KotlinDebug\n*F\n+ 1 PestSpawn.kt\nat/hannibal2/skyhanni/features/garden/pests/PestSpawn\n*L\n62#1:110\n66#1:112\n70#1:114\n75#1:116\n62#1:111\n66#1:113\n70#1:115\n75#1:117\n*E\n"})
public final class PestSpawn {
    @NotNull
    public static final PestSpawn INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern onePestPattern$delegate;
    @NotNull
    private static final RepoPattern multiplePestsPattern$delegate;
    @NotNull
    private static final RepoPattern offlinePestsPattern$delegate;
    @NotNull
    private static final RepoPattern clickToTPPattern$delegate;

    private PestSpawn() {
    }

    private final PestSpawnConfig getConfig() {
        return PestApi.INSTANCE.getConfig().getPestSpawn();
    }

    private final Pattern getOnePestPattern() {
        return (Pattern)onePestPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getMultiplePestsPattern() {
        return (Pattern)multiplePestsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getOfflinePestsPattern() {
        return (Pattern)offlinePestsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getClickToTPPattern() {
        return (Pattern)clickToTPPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        String message = event2.getMessage();
        boolean blocked = false;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getOnePestPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            INSTANCE.spawn(1, CollectionsKt.listOf($this$onChat_u24lambda_u240.group("plot")));
            blocked = true;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getMultiplePestsPattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            String string = $this$onChat_u24lambda_u241.group("amount");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            INSTANCE.spawn(Integer.parseInt(string), CollectionsKt.listOf($this$onChat_u24lambda_u241.group("plot")));
            blocked = true;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getOfflinePestsPattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl4 = false;
            String string = $this$onChat_u24lambda_u242.group("plots");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String[] stringArray = new String[]{", ", " and "};
            INSTANCE.spawn(null, CollectionsKt.toList(StringsKt.split$default((CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null), stringArray, false, 0, 6, null)));
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getClickToTPPattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl5 = false;
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(PestApi.INSTANCE.getLastPestSpawnTime-uFjCsEo()), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
                blocked = true;
            }
        }
        if (blocked && this.getConfig().getChatMessageFormat() != PestSpawnConfig.ChatMessageFormatEntry.HYPIXEL) {
            event2.setBlockedReason("pests_spawn");
        }
    }

    private final void spawn(Integer amount, List<String> plotNames) {
        new PestSpawnEvent(amount, plotNames).post();
        if (amount == null) {
            return;
        }
        String string = CollectionsKt.firstOrNull(plotNames);
        if (string == null) {
            throw new IllegalStateException("first plot name is null".toString());
        }
        String plotName = string;
        String pestName = StringUtils.pluralize$default(StringUtils.INSTANCE, amount, "Pest", null, false, 12, null);
        String message = "\u00a7e" + amount + " \u00a7a" + pestName + " Spawned in \u00a7b" + plotName + "\u00a7a!";
        if (this.getConfig().getShowTitle()) {
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, message, null, DurationKt.toDuration(7, DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        }
        if (this.getConfig().getChatMessageFormat() == PestSpawnConfig.ChatMessageFormatEntry.COMPACT) {
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, message, () -> PestSpawn.spawn$lambda$4(plotName), "\u00a7eClick to run /plottp " + plotName + '!', 0L, false, null, false, false, 248, null);
        }
    }

    private static final Unit spawn$lambda$4(String $plotName) {
        Intrinsics.checkNotNullParameter($plotName, "$plotName");
        HypixelCommands.INSTANCE.teleportToPlot($plotName);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "onePestPattern", "getOnePestPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "multiplePestsPattern", "getMultiplePestsPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "offlinePestsPattern", "getOfflinePestsPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "clickToTPPattern", "getClickToTPPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PestSpawn();
        patternGroup = RepoPattern.Companion.group("garden.pests.spawn");
        onePestPattern$delegate = patternGroup.pattern("one", "\u00a76\u00a7l.*! \u00a77A \u00a72\u0d60 Pest \u00a77has appeared in \u00a7aPlot \u00a77- \u00a7b(?<plot>.*)\u00a77!");
        multiplePestsPattern$delegate = patternGroup.pattern("multiple", "\u00a76\u00a7l.*! \u00a72(?<amount>\\d) \u00a72\u0d60 Pests? \u00a77have spawned in \u00a7aPlot \u00a77- \u00a7b(?<plot>.*)\u00a77!");
        offlinePestsPattern$delegate = patternGroup.pattern("offline", "\u00a76\u00a7l.*! \u00a77While you were offline, \u00a72\u0d60 \u00a72Pests? \u00a77spawned in \u00a7aPlots (?<plots>.*)!");
        clickToTPPattern$delegate = patternGroup.pattern("teleport", "\\s*\u00a7r\u00a7e\u00a7lCLICK HERE \u00a7eto teleport to the plot!");
    }
}

