/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.sensitivity;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.features.garden.sensitivity.MouseSensitivityManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0018\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/features/garden/sensitivity/LockMouseLook;", "", "<init>", "()V", "", "onWorldChange", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "unlockMouse", "lockMouse", "toggleLock", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Ljava/util/regex/Pattern;", "gardenTeleportPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getGardenTeleportPattern", "()Ljava/util/regex/Pattern;", "gardenTeleportPattern", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "", "isActive", "()Z", "1.8.9"})
public final class LockMouseLook {
    @NotNull
    public static final LockMouseLook INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern gardenTeleportPattern$delegate;

    private LockMouseLook() {
    }

    private final Pattern getGardenTeleportPattern() {
        return (Pattern)gardenTeleportPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    private final boolean isActive() {
        return MouseSensitivityManager.SensitivityState.LOCKED.isActive();
    }

    @HandleEvent
    public final void onWorldChange() {
        this.unlockMouse();
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!RegexUtils.INSTANCE.matches(this.getGardenTeleportPattern(), event2.getMessage())) {
            return;
        }
        this.unlockMouse();
    }

    public final void unlockMouse() {
        if (!this.isActive()) {
            return;
        }
        MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.UNCHANGED);
        if (this.getConfig().getLockMouseLookChatMessage()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse rotation is now unlocked.", false, null, false, false, null, 62, null);
        }
    }

    private final void lockMouse() {
        if (this.isActive()) {
            return;
        }
        MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.LOCKED);
        if (this.getConfig().getLockMouseLookChatMessage()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse rotation is now locked.", false, null, false, false, null, 62, null);
        }
    }

    private final void toggleLock() {
        if (this.isActive()) {
            this.unlockMouse();
        } else {
            this.lockMouse();
        }
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isActive()) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getLockedMouseDisplay(), "\u00a7eMouse Locked", 0, 0, "Mouse Locked", 6, null);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.register("shmouselock", LockMouseLook::onCommandRegistration$lambda$1);
    }

    private static final Unit onCommandRegistration$lambda$1$lambda$0(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.toggleLock();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$1(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Lock/Unlock the mouse so it will no longer rotate the player (for farming)");
        $this$register.setCategory(CommandCategory.USERS_ACTIVE);
        $this$register.setAliases(CollectionsKt.listOf("shlockmouse"));
        $this$register.callback(LockMouseLook::onCommandRegistration$lambda$1$lambda$0);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LockMouseLook.class, "gardenTeleportPattern", "getGardenTeleportPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new LockMouseLook();
        gardenTeleportPattern$delegate = RepoPattern.Companion.pattern("chat.garden.teleport", "\u00a7aTeleported you to .*");
    }
}

