/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.MiningConfig;
import at.hannibal2.skyhanni.data.IslandTypeTags;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.features.mining.MiningNotifications;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0019\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001cR\u0016\u0010\u001f\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001cR\u0018\u0010!\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/features/mining/GoldenGoblinHighlight;", "", "<init>", "()V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onEvent", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "onMobEvent", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "handle", "Lat/hannibal2/skyhanni/config/features/mining/MiningConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningConfig;", "config", "Ljava/util/regex/Pattern;", "goblinPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getGoblinPattern", "()Ljava/util/regex/Pattern;", "goblinPattern", "Lkotlin/time/Duration;", "timeOut", "J", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastChatMessage", "lastGoblinSpawn", "Lat/hannibal2/skyhanni/data/mob/Mob;", "lastGoblin", "Lat/hannibal2/skyhanni/data/mob/Mob;", "1.8.9"})
public final class GoldenGoblinHighlight {
    @NotNull
    public static final GoldenGoblinHighlight INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern goblinPattern$delegate;
    private static final long timeOut;
    private static long lastChatMessage;
    private static long lastGoblinSpawn;
    @Nullable
    private static Mob lastGoblin;

    private GoldenGoblinHighlight() {
    }

    private final MiningConfig getConfig() {
        return SkyHanniMod.feature.getMining();
    }

    private final Pattern getGoblinPattern() {
        return (Pattern)goblinPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final boolean isEnabled() {
        return IslandTypeTags.INSTANCE.getMINING().inAny() && this.getConfig().getHighlightYourGoldenGoblin();
    }

    @HandleEvent
    public final void onEvent(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(MiningNotifications.INSTANCE.getGoldenGoblinSpawn(), event2.getMessage()) && !RegexUtils.INSTANCE.matches(MiningNotifications.INSTANCE.getDiamondGoblinSpawn(), event2.getMessage())) {
            return;
        }
        lastChatMessage = SimpleTimeMark.Companion.now-uFjCsEo();
        this.handle();
    }

    @HandleEvent
    public final void onMobEvent(@NotNull MobEvent.Spawn.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getGoblinPattern(), event2.getMob().getName())) {
            return;
        }
        lastGoblin = event2.getMob();
        lastGoblinSpawn = SimpleTimeMark.Companion.now-uFjCsEo();
        this.handle();
    }

    private final void handle() {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastChatMessage), timeOut) > 0 || Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastGoblinSpawn), timeOut) > 0) {
            return;
        }
        lastChatMessage = SimpleTimeMark.Companion.farPast();
        lastGoblinSpawn = SimpleTimeMark.Companion.farPast();
        Mob mob = lastGoblin;
        if (mob == null) {
            return;
        }
        Mob goblin = mob;
        goblin.highlight(LorenzColor.toChromaColor$default(LorenzColor.GREEN, 0, 0, 3, null));
        if (this.getConfig().getLineToYourGoldenGoblin()) {
            Mob.lineToPlayer$default(goblin, LorenzColor.toChromaColor$default(LorenzColor.GREEN, 0, 0, 3, null), 0, false, GoldenGoblinHighlight::handle$lambda$0, 6, null);
        }
        lastGoblin = null;
    }

    private static final boolean handle$lambda$0() {
        return INSTANCE.getConfig().getLineToYourGoldenGoblin();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(GoldenGoblinHighlight.class, "goblinPattern", "getGoblinPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new GoldenGoblinHighlight();
        goblinPattern$delegate = RepoPattern.Companion.pattern("mining.mob.golden.goblin", "Golden Goblin|Diamond Goblin");
        timeOut = DurationKt.toDuration(10, DurationUnit.SECONDS);
        lastChatMessage = SimpleTimeMark.Companion.farPast();
        lastGoblinSpawn = SimpleTimeMark.Companion.farPast();
    }
}

