/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.area.dreadfarm;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.rift.area.dreadfarm.VoltCruxConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.entity.EntityEquipmentChangeEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.features.rift.area.dreadfarm.VoltHighlighter$onRenderWorld$;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010#\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001d\u001a\u0004\b\"\u0010\u001fR\u001b\u0010&\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001d\u001a\u0004\b%\u0010\u001fR\u0014\u0010(\u001a\u00020'8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\"\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020.0-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/entity/EntityEquipmentChangeEvent;", "Lnet/minecraft/entity/Entity;", "event", "", "onArmorChange", "(Lat/hannibal2/skyhanni/events/entity/EntityEquipmentChangeEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lnet/minecraft/item/ItemStack;", "itemStack", "Lat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter$VoltState;", "getVoltState", "(Lnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter$VoltState;", "entity", "(Lnet/minecraft/entity/Entity;)Lat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter$VoltState;", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/rift/area/dreadfarm/VoltCruxConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/area/dreadfarm/VoltCruxConfig;", "config", "", "VOLT_DOING_LIGHTNING$delegate", "Lkotlin/Lazy;", "getVOLT_DOING_LIGHTNING", "()Ljava/lang/String;", "VOLT_DOING_LIGHTNING", "VOLT_FRIENDLY$delegate", "getVOLT_FRIENDLY", "VOLT_FRIENDLY", "VOLT_HOSTILE$delegate", "getVOLT_HOSTILE", "VOLT_HOSTILE", "", "LIGHTNING_DISTANCE", "F", "Lkotlin/time/Duration;", "CHARGE_TIME", "J", "", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "chargingSince", "Ljava/util/Map;", "VoltState", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nVoltHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoltHighlighter.kt\nat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n190#2:119\n477#3:120\n1#4:121\n*S KotlinDebug\n*F\n+ 1 VoltHighlighter.kt\nat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter\n*L\n60#1:119\n60#1:120\n*E\n"})
public final class VoltHighlighter {
    @NotNull
    public static final VoltHighlighter INSTANCE = new VoltHighlighter();
    @NotNull
    private static final Lazy VOLT_DOING_LIGHTNING$delegate = LazyKt.lazy(VoltHighlighter::VOLT_DOING_LIGHTNING_delegate$lambda$0);
    @NotNull
    private static final Lazy VOLT_FRIENDLY$delegate = LazyKt.lazy(VoltHighlighter::VOLT_FRIENDLY_delegate$lambda$1);
    @NotNull
    private static final Lazy VOLT_HOSTILE$delegate = LazyKt.lazy(VoltHighlighter::VOLT_HOSTILE_delegate$lambda$2);
    private static final float LIGHTNING_DISTANCE = 7.0f;
    private static final long CHARGE_TIME = DurationKt.toDuration(12, DurationUnit.SECONDS);
    @NotNull
    private static Map<Entity, SimpleTimeMark> chargingSince = MapsKt.emptyMap();

    private VoltHighlighter() {
    }

    private final VoltCruxConfig getConfig() {
        return RiftApi.INSTANCE.getConfig().getArea().getDreadfarm().getVoltCrux();
    }

    private final String getVOLT_DOING_LIGHTNING() {
        Lazy lazy = VOLT_DOING_LIGHTNING$delegate;
        return (String)lazy.getValue();
    }

    private final String getVOLT_FRIENDLY() {
        Lazy lazy = VOLT_FRIENDLY$delegate;
        return (String)lazy.getValue();
    }

    private final String getVOLT_HOSTILE() {
        Lazy lazy = VOLT_HOSTILE$delegate;
        return (String)lazy.getValue();
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onArmorChange(@NotNull EntityEquipmentChangeEvent<Entity> event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.getConfig().getVoltWarning()) {
            return;
        }
        EntityPlayerSP entityPlayerSP = MinecraftCompat.INSTANCE.getLocalPlayerOrNull();
        if (entityPlayerSP == null) {
            return;
        }
        EntityPlayerSP player = entityPlayerSP;
        if (event2.isHead() && this.getVoltState(event2.getEntity()) == VoltState.DOING_LIGHTNING && event2.getEntity().func_174791_d().func_72436_e(player.func_174791_d()) <= 49.0) {
            chargingSince = CollectionUtils.INSTANCE.editCopy(chargingSince, arg_0 -> VoltHighlighter.onArmorChange$lambda$3(event2, arg_0));
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_RIFT)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.getConfig().getVoltRange() && !this.getConfig().getVoltMoodMeter()) {
            return;
        }
        EntityUtils this_$iv = EntityUtils.INSTANCE;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv, onRenderWorld$$inlined$getEntities$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Iterator<Entity> iterator2 = sequence2.iterator();
        while (iterator2.hasNext()) {
            VoltState state;
            VoltState voltState;
            EntityLivingBase entity = (EntityLivingBase)iterator2.next();
            VoltState it = voltState = this.getVoltState((Entity)entity);
            boolean bl = false;
            if ((it != VoltState.NO_VOLT ? voltState : null) == null) continue;
            state = state;
            if (this.getConfig().getVoltMoodMeter()) {
                RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime(entity, ColorUtils.INSTANCE.toColor(state.getColor()), VoltHighlighter::onRenderWorld$lambda$5);
            }
            if (state != VoltState.DOING_LIGHTNING || !this.getConfig().getVoltRange()) continue;
            WorldRenderUtils.INSTANCE.drawCylinderInWorld(event2, ColorUtils.INSTANCE.toColor(this.getConfig().getVoltColor()), entity.field_70165_t, entity.field_70163_u - (double)4.0f, entity.field_70161_v, 7.0f, 20.0f);
            long dischargingSince = chargingSince.getOrDefault(entity, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.farPast())).unbox-impl();
            long dischargeTimeLeft = Duration.minus-LRDsOJo(CHARGE_TIME, SimpleTimeMark.passedSince-UwyO8pc(dischargingSince));
            if (Duration.compareTo-LRDsOJo(dischargeTimeLeft, Duration.Companion.getZERO-UwyO8pc()) <= 0) continue;
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, WorldRenderUtils.INSTANCE.exactLocation(event2, (Entity)entity).up(2.5), "\u00a7eLightning: " + TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, dischargeTimeLeft, null, true, false, 0, false, false, 61, null), 2.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    private final VoltState getVoltState(ItemStack itemStack) {
        String string = ItemUtils.INSTANCE.getSkullTexture(itemStack);
        return Intrinsics.areEqual(string, this.getVOLT_DOING_LIGHTNING()) ? VoltState.DOING_LIGHTNING : (Intrinsics.areEqual(string, this.getVOLT_FRIENDLY()) ? VoltState.FRIENDLY : (Intrinsics.areEqual(string, this.getVOLT_HOSTILE()) ? VoltState.HOSTILE : VoltState.NO_VOLT));
    }

    private final VoltState getVoltState(Entity entity) {
        if (!(entity instanceof EntityArmorStand)) {
            return VoltState.NO_VOLT;
        }
        ItemStack itemStack = EntityCompatKt.getStandHelmet((EntityArmorStand)entity);
        if (itemStack == null) {
            return VoltState.NO_VOLT;
        }
        ItemStack helmet = itemStack;
        return this.getVoltState(helmet);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 82, "rift.area.dreadfarm.voltCrux.voltColour", "rift.area.dreadfarm.voltCrux.voltColor", null, 8, null);
    }

    private static final String VOLT_DOING_LIGHTNING_delegate$lambda$0() {
        return SkullTextureHolder.INSTANCE.getTexture("VOLT_DOING_LIGHTNING");
    }

    private static final String VOLT_FRIENDLY_delegate$lambda$1() {
        return SkullTextureHolder.INSTANCE.getTexture("VOLT_FRIENDLY");
    }

    private static final String VOLT_HOSTILE_delegate$lambda$2() {
        return SkullTextureHolder.INSTANCE.getTexture("VOLT_HOSTILE");
    }

    private static final Unit onArmorChange$lambda$3(EntityEquipmentChangeEvent $event, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($event, "$event");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.put($event.getEntity(), SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
        return Unit.INSTANCE;
    }

    private static final boolean onRenderWorld$lambda$5() {
        return INSTANCE.getConfig().getVoltMoodMeter();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/features/rift/area/dreadfarm/VoltHighlighter$VoltState;", "", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "color", "<init>", "(Ljava/lang/String;ILio/github/notenoughupdates/moulconfig/ChromaColour;)V", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "NO_VOLT", "FRIENDLY", "HOSTILE", "DOING_LIGHTNING", "1.8.9"})
    public static final class VoltState
    extends Enum<VoltState> {
        @NotNull
        private final ChromaColour color;
        public static final /* enum */ VoltState NO_VOLT = new VoltState(ChromaColour.Companion.fromStaticRGB(0, 0, 0, 0));
        public static final /* enum */ VoltState FRIENDLY = new VoltState(ChromaColour.Companion.fromStaticRGB(0, 255, 0, 128));
        public static final /* enum */ VoltState HOSTILE = new VoltState(ChromaColour.Companion.fromStaticRGB(255, 0, 0, 128));
        public static final /* enum */ VoltState DOING_LIGHTNING = new VoltState(ChromaColour.Companion.fromStaticRGB(0, 0, 255, 128));
        private static final /* synthetic */ VoltState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private VoltState(ChromaColour color) {
            this.color = color;
        }

        @NotNull
        public final ChromaColour getColor() {
            return this.color;
        }

        public static VoltState[] values() {
            return (VoltState[])$VALUES.clone();
        }

        public static VoltState valueOf(String value) {
            return Enum.valueOf(VoltState.class, value);
        }

        @NotNull
        public static EnumEntries<VoltState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = voltStateArray = new VoltState[]{VoltState.NO_VOLT, VoltState.FRIENDLY, VoltState.HOSTILE, VoltState.DOING_LIGHTNING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

