/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.stranded;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.stranded.StrandedConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0016\u001a\u00020\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001b\u0010&\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010)\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010#\u001a\u0004\b(\u0010%R\u001b\u0010,\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010#\u001a\u0004\b+\u0010%R\u0016\u0010-\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/features/stranded/HighlightPlaceableNpcs;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "", "lore", "", "isPlaceableNpc", "(Ljava/util/List;)Z", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/stranded/StrandedConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/stranded/StrandedConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "locationPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getLocationPattern", "()Ljava/util/regex/Pattern;", "locationPattern", "clickToSetPattern$delegate", "getClickToSetPattern", "clickToSetPattern", "clickToSpawnPattern$delegate", "getClickToSpawnPattern", "clickToSpawnPattern", "inInventory", "Z", "", "highlightedItems", "Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHighlightPlaceableNpcs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightPlaceableNpcs.kt\nat/hannibal2/skyhanni/features/stranded/HighlightPlaceableNpcs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n2632#2,3:93\n*S KotlinDebug\n*F\n+ 1 HighlightPlaceableNpcs.kt\nat/hannibal2/skyhanni/features/stranded/HighlightPlaceableNpcs\n*L\n87#1:93,3\n*E\n"})
public final class HighlightPlaceableNpcs {
    @NotNull
    public static final HighlightPlaceableNpcs INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern locationPattern$delegate;
    @NotNull
    private static final RepoPattern clickToSetPattern$delegate;
    @NotNull
    private static final RepoPattern clickToSpawnPattern$delegate;
    private static boolean inInventory;
    @NotNull
    private static List<Integer> highlightedItems;

    private HighlightPlaceableNpcs() {
    }

    private final StrandedConfig getConfig() {
        return SkyHanniMod.feature.misc.getStranded();
    }

    private final Pattern getLocationPattern() {
        return (Pattern)locationPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getClickToSetPattern() {
        return (Pattern)clickToSetPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getClickToSpawnPattern() {
        return (Pattern)clickToSpawnPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        inInventory = false;
        if (!this.isEnabled()) {
            return;
        }
        if (!Intrinsics.areEqual(event2.getInventoryName(), "Island NPCs")) {
            return;
        }
        List highlightedItems = new ArrayList();
        for (Map.Entry<Integer, ItemStack> entry : event2.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack stack = entry.getValue();
            if (!this.isPlaceableNpc(ItemUtils.INSTANCE.getLore(stack))) continue;
            highlightedItems.add(slot);
        }
        inInventory = true;
        HighlightPlaceableNpcs.highlightedItems = highlightedItems;
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        inInventory = false;
        highlightedItems = CollectionsKt.emptyList();
    }

    @HandleEvent(priority=1)
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled() || !inInventory) {
            return;
        }
        for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            if (!highlightedItems.contains(slot.getSlotIndex())) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.GREEN);
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 31, "stranded", "misc.stranded", null, 8, null);
    }

    private final boolean isPlaceableNpc(List<String> lore) {
        boolean bl;
        block4: {
            if (lore.isEmpty() || !RegexUtils.INSTANCE.matches(this.getClickToSetPattern(), CollectionsKt.last(lore)) && !RegexUtils.INSTANCE.matches(this.getClickToSpawnPattern(), CollectionsKt.last(lore))) {
                return false;
            }
            Iterable $this$none$iv = lore;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!RegexUtils.INSTANCE.matches(INSTANCE.getLocationPattern(), it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && SkyBlockUtils.INSTANCE.isStrandedProfile() && this.getConfig().getHighlightPlaceableNpcs();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(HighlightPlaceableNpcs.class, "locationPattern", "getLocationPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(HighlightPlaceableNpcs.class, "clickToSetPattern", "getClickToSetPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(HighlightPlaceableNpcs.class, "clickToSpawnPattern", "getClickToSpawnPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HighlightPlaceableNpcs();
        patternGroup = RepoPattern.Companion.group("stranded.highlightplacement");
        locationPattern$delegate = patternGroup.pattern("location", "\u00a77Location: \u00a7f\\[\u00a7e\\d+\u00a7f, \u00a7e\\d+\u00a7f, \u00a7e\\d+\u00a7f]");
        clickToSetPattern$delegate = patternGroup.pattern("clicktoset", "\u00a77\u00a7eClick to set the location of this NPC!");
        clickToSpawnPattern$delegate = patternGroup.pattern("clicktospawn", "\u00a7elocation!");
        highlightedItems = CollectionsKt.emptyList();
    }
}

