/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.render;

import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B!\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\u0012\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0015\u0010\u0019J%\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u001dJ7\u0010 \u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010%\u001a\u0004\b&\u0010'R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010(\u001a\u0004\b)\u0010*R\u001f\u0010-\u001a\n ,*\u0004\u0018\u00010+0+8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/utils/render/LineDrawer;", "", "Lnet/minecraft/client/renderer/Tessellator;", "tessellator", "", "lineWidth", "", "depth", "<init>", "(Lnet/minecraft/client/renderer/Tessellator;IZ)V", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "path", "Ljava/awt/Color;", "color", "", "bezierPoint", "", "drawPath", "(Ljava/util/List;Ljava/awt/Color;D)V", "location", "drawEdges", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;)V", "Lnet/minecraft/util/AxisAlignedBB;", "axisAlignedBB", "(Lnet/minecraft/util/AxisAlignedBB;Ljava/awt/Color;)V", "p1", "p2", "draw3DLine", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;)V", "p3", "segments", "drawBezier2", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;I)V", "Lnet/minecraft/client/renderer/Tessellator;", "getTessellator", "()Lnet/minecraft/client/renderer/Tessellator;", "I", "getLineWidth", "()I", "Z", "getDepth", "()Z", "Lnet/minecraft/client/renderer/WorldRenderer;", "kotlin.jvm.PlatformType", "worldRenderer", "Lnet/minecraft/client/renderer/WorldRenderer;", "getWorldRenderer", "()Lnet/minecraft/client/renderer/WorldRenderer;", "Companion", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nLineDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineDrawer.kt\nat/hannibal2/skyhanni/utils/render/LineDrawer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,147:1\n1863#2,2:148\n1872#2,3:150\n1863#2,2:153\n13346#3,2:155\n*S KotlinDebug\n*F\n+ 1 LineDrawer.kt\nat/hannibal2/skyhanni/utils/render/LineDrawer\n*L\n22#1:148,2\n27#1:150,3\n35#1:153,2\n89#1:155,2\n*E\n"})
public final class LineDrawer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tessellator tessellator;
    private final int lineWidth;
    private final boolean depth;
    private final WorldRenderer worldRenderer;
    @NotNull
    private static final FloatBuffer bezier2Buffer;

    @PublishedApi
    public LineDrawer(@NotNull Tessellator tessellator, int lineWidth, boolean depth) {
        Intrinsics.checkNotNullParameter(tessellator, "tessellator");
        this.tessellator = tessellator;
        this.lineWidth = lineWidth;
        this.depth = depth;
        this.worldRenderer = this.tessellator.func_178180_c();
    }

    @NotNull
    public final Tessellator getTessellator() {
        return this.tessellator;
    }

    public final int getLineWidth() {
        return this.lineWidth;
    }

    public final boolean getDepth() {
        return this.depth;
    }

    public final WorldRenderer getWorldRenderer() {
        return this.worldRenderer;
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPath(@NotNull List<LorenzVec> path, @NotNull Color color, double bezierPoint) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(color, "color");
        if (bezierPoint < 0.0) {
            Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)path);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                this.draw3DLine((LorenzVec)it.getFirst(), (LorenzVec)it.getSecond(), color);
            }
        } else {
            List pathLines = CollectionsKt.zipWithNext((Iterable)path);
            Iterable $this$forEachIndexed$iv = pathLines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void pathLine;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                LorenzVec reduce2 = ((LorenzVec)pathLine.getSecond()).minus((LorenzVec)pathLine.getFirst()).normalize().times(bezierPoint);
                this.draw3DLine(index != 0 ? ((LorenzVec)pathLine.getFirst()).plus(reduce2) : (LorenzVec)pathLine.getFirst(), index != CollectionsKt.getLastIndex(pathLines) ? ((LorenzVec)pathLine.getSecond()).minus(reduce2) : (LorenzVec)pathLine.getSecond(), color);
            }
            Iterable $this$forEach$iv = CollectionUtils.INSTANCE.zipWithNext3((Iterable)path);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple it = (Triple)element$iv;
                boolean bl = false;
                LorenzVec p1 = ((LorenzVec)it.getSecond()).minus(((LorenzVec)it.getSecond()).minus((LorenzVec)it.getFirst()).normalize().times(bezierPoint));
                LorenzVec p3 = ((LorenzVec)it.getSecond()).minus(((LorenzVec)it.getSecond()).minus((LorenzVec)it.getThird()).normalize().times(bezierPoint));
                LorenzVec p2 = (LorenzVec)it.getSecond();
                LineDrawer.drawBezier2$default(this, p1, p2, p3, color, 0, 16, null);
            }
        }
    }

    public static /* synthetic */ void drawPath$default(LineDrawer lineDrawer, List list, Color color, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        lineDrawer.drawPath(list, color, d);
    }

    public final void drawEdges(@NotNull LorenzVec location, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(color, "color");
        for (Pair<LorenzVec, LorenzVec> pair : location.getEdges()) {
            LorenzVec p1 = pair.component1();
            LorenzVec p2 = pair.component2();
            this.draw3DLine(p1, p2, color);
        }
    }

    public final void drawEdges(@NotNull AxisAlignedBB axisAlignedBB, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(axisAlignedBB, "axisAlignedBB");
        Intrinsics.checkNotNullParameter(color, "color");
        for (Pair<LorenzVec, LorenzVec> pair : LocationUtils.INSTANCE.calculateEdges(axisAlignedBB)) {
            LorenzVec p1 = pair.component1();
            LorenzVec p2 = pair.component2();
            this.draw3DLine(p1, p2, color);
        }
    }

    public final void draw3DLine(@NotNull LorenzVec p1, @NotNull LorenzVec p2, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(color, "color");
        GL11.glLineWidth((float)this.lineWidth);
        if (!this.depth) {
            GL11.glDisable((int)2929);
            GlStateManager.func_179132_a((boolean)false);
        }
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        this.worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        this.worldRenderer.func_181662_b(p1.getX(), p1.getY(), p1.getZ()).func_181675_d();
        this.worldRenderer.func_181662_b(p2.getX(), p2.getY(), p2.getZ()).func_181675_d();
        this.tessellator.func_78381_a();
        if (!this.depth) {
            GL11.glEnable((int)2929);
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    public final void drawBezier2(@NotNull LorenzVec p1, @NotNull LorenzVec p2, @NotNull LorenzVec p3, @NotNull Color color, int segments) {
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        Intrinsics.checkNotNullParameter(p3, "p3");
        Intrinsics.checkNotNullParameter(color, "color");
        GL11.glLineWidth((float)this.lineWidth);
        if (!this.depth) {
            GL11.glDisable((int)2929);
            GlStateManager.func_179132_a((boolean)false);
        }
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        Float[] ctrlPoints = ArraysKt.plus(ArraysKt.plus(p1.toFloatArray(), p2.toFloatArray()), p3.toFloatArray());
        bezier2Buffer.clear();
        Float[] $this$forEach$iv = ctrlPoints;
        boolean $i$f$forEach = false;
        for (Float element$iv : $this$forEach$iv) {
            float it = ((Number)element$iv).floatValue();
            boolean bl = false;
            bezier2Buffer.put(it);
        }
        bezier2Buffer.flip();
        GL11.glMap1f((int)3479, (float)0.0f, (float)1.0f, (int)3, (int)3, (FloatBuffer)bezier2Buffer);
        GL11.glEnable((int)3479);
        GL11.glBegin((int)3);
        int i2 = 0;
        if (i2 <= segments) {
            while (true) {
                GL11.glEvalCoord1f((float)((float)i2 / (float)segments));
                if (i2 == segments) break;
                ++i2;
            }
        }
        GL11.glEnd();
        if (!this.depth) {
            GL11.glEnable((int)2929);
            GlStateManager.func_179132_a((boolean)true);
        }
    }

    public static /* synthetic */ void drawBezier2$default(LineDrawer lineDrawer, LorenzVec lorenzVec, LorenzVec lorenzVec2, LorenzVec lorenzVec3, Color color, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 30;
        }
        lineDrawer.drawBezier2(lorenzVec, lorenzVec2, lorenzVec3, color, n);
    }

    static {
        FloatBuffer floatBuffer = GLAllocation.func_74529_h((int)9);
        Intrinsics.checkNotNullExpressionValue(floatBuffer, "createDirectFloatBuffer(...)");
        bezier2Buffer = floatBuffer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0019\b\u0004\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/utils/render/LineDrawer$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "", "lineWidth", "", "depth", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/utils/render/LineDrawer;", "", "Lkotlin/ExtensionFunctionType;", "draws", "draw3D", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;IZLkotlin/jvm/functions/Function1;)V", "Ljava/nio/FloatBuffer;", "bezier2Buffer", "Ljava/nio/FloatBuffer;", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        public final void draw3D(@NotNull SkyHanniRenderWorldEvent event2, int lineWidth, boolean depth, @NotNull Function1<? super LineDrawer, Unit> draws) {
            Intrinsics.checkNotNullParameter(event2, "event");
            Intrinsics.checkNotNullParameter(draws, "draws");
            boolean $i$f$draw3D = false;
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179090_x();
            GlStateManager.func_179129_p();
            GlStateManager.func_179118_c();
            GlStateManager.func_179094_E();
            LorenzVec inverseView = WorldRenderUtils.INSTANCE.getViewerPos(event2.getPartialTicks());
            WorldRenderUtils.INSTANCE.translate(inverseView.negated());
            Tessellator tessellator = Tessellator.func_178181_a();
            Intrinsics.checkNotNullExpressionValue(tessellator, "getInstance(...)");
            draws.invoke(new LineDrawer(tessellator, lineWidth, depth));
            GlStateManager.func_179121_F();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

