/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.KryoSerialization;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.Serialization;
import com.esotericsoftware.kryonet.ServerDiscoveryHandler;
import com.esotericsoftware.kryonet.UdpConnection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public class Server
implements EndPoint {
    private final Serialization serialization;
    private final int writeBufferSize;
    private final int objectBufferSize;
    private final Selector selector;
    private int emptySelects;
    private ServerSocketChannel serverChannel;
    private UdpConnection udp;
    private Connection[] connections = new Connection[0];
    private IntMap<Connection> pendingConnections = new IntMap();
    Listener[] listeners = new Listener[0];
    private Object listenerLock = new Object();
    private int nextConnectionID = 1;
    private volatile boolean shutdown;
    private Object updateLock = new Object();
    private Thread updateThread;
    private ServerDiscoveryHandler discoveryHandler;
    private Listener dispatchListener = new Listener(){

        public void connected(Connection connection) {
            Listener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i2 = 0; i2 < n; ++i2) {
                listeners[i2].connected(connection);
            }
        }

        public void disconnected(Connection connection) {
            Server.this.removeConnection(connection);
            Listener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i2 = 0; i2 < n; ++i2) {
                listeners[i2].disconnected(connection);
            }
        }

        public void received(Connection connection, Object object) {
            Listener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i2 = 0; i2 < n; ++i2) {
                listeners[i2].received(connection, object);
            }
        }

        public void idle(Connection connection) {
            Listener[] listeners = Server.this.listeners;
            int n = listeners.length;
            for (int i2 = 0; i2 < n; ++i2) {
                listeners[i2].idle(connection);
            }
        }
    };

    public Server() {
        this(16384, 2048);
    }

    public Server(int writeBufferSize, int objectBufferSize) {
        this(writeBufferSize, objectBufferSize, new KryoSerialization());
    }

    public Server(int writeBufferSize, int objectBufferSize, Serialization serialization) {
        this.writeBufferSize = writeBufferSize;
        this.objectBufferSize = objectBufferSize;
        this.serialization = serialization;
        this.discoveryHandler = ServerDiscoveryHandler.DEFAULT;
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error opening selector.", ex);
        }
    }

    public void setDiscoveryHandler(ServerDiscoveryHandler newDiscoveryHandler) {
        this.discoveryHandler = newDiscoveryHandler;
    }

    public Serialization getSerialization() {
        return this.serialization;
    }

    public Kryo getKryo() {
        return ((KryoSerialization)this.serialization).getKryo();
    }

    public void bind(int tcpPort) throws IOException {
        this.bind(new InetSocketAddress(tcpPort), null);
    }

    public void bind(int tcpPort, int udpPort) throws IOException {
        this.bind(new InetSocketAddress(tcpPort), new InetSocketAddress(udpPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(InetSocketAddress tcpPort, InetSocketAddress udpPort) throws IOException {
        this.close();
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.serverChannel = this.selector.provider().openServerSocketChannel();
                this.serverChannel.socket().bind(tcpPort);
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(this.selector, 16);
                if (Log.DEBUG) {
                    Log.debug("kryonet", "Accepting connections on port: " + tcpPort + "/TCP");
                }
                if (udpPort != null) {
                    this.udp = new UdpConnection(this.serialization, this.objectBufferSize);
                    this.udp.bind(this.selector, udpPort);
                    if (Log.DEBUG) {
                        Log.debug("kryonet", "Accepting connections on port: " + udpPort + "/UDP");
                    }
                }
            }
            catch (IOException ex) {
                this.close();
                throw ex;
            }
        }
        if (Log.INFO) {
            Log.info("kryonet", "Server opened.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int timeout) throws IOException {
        this.updateThread = Thread.currentThread();
        Object object = this.updateLock;
        synchronized (object) {
        }
        long startTime = System.currentTimeMillis();
        int select = 0;
        select = timeout > 0 ? this.selector.select(timeout) : this.selector.selectNow();
        if (select == 0) {
            ++this.emptySelects;
            if (this.emptySelects == 100) {
                this.emptySelects = 0;
                long elapsedTime = System.currentTimeMillis() - startTime;
                try {
                    if (elapsedTime < 25L) {
                        Thread.sleep(25L - elapsedTime);
                    }
                }
                catch (InterruptedException ex) {}
            }
        } else {
            Set<SelectionKey> keys2;
            this.emptySelects = 0;
            Set<SelectionKey> set = keys2 = this.selector.selectedKeys();
            synchronized (set) {
                UdpConnection udp = this.udp;
                Iterator<SelectionKey> iter = keys2.iterator();
                while (iter.hasNext()) {
                    this.keepAlive();
                    SelectionKey selectionKey = iter.next();
                    iter.remove();
                    Connection fromConnection = (Connection)selectionKey.attachment();
                    try {
                        Object object2;
                        InetSocketAddress fromAddress;
                        int ops = selectionKey.readyOps();
                        if (fromConnection != null) {
                            if (udp != null && fromConnection.udpRemoteAddress == null) {
                                fromConnection.close();
                                continue;
                            }
                            if ((ops & 1) == 1) {
                                try {
                                    Object object3;
                                    while ((object3 = fromConnection.tcp.readObject(fromConnection)) != null) {
                                        if (Log.DEBUG) {
                                            String objectString;
                                            String string = objectString = object3 == null ? "null" : object3.getClass().getSimpleName();
                                            if (!(object3 instanceof FrameworkMessage)) {
                                                Log.debug("kryonet", fromConnection + " received TCP: " + objectString);
                                            } else if (Log.TRACE) {
                                                Log.trace("kryonet", fromConnection + " received TCP: " + objectString);
                                            }
                                        }
                                        fromConnection.notifyReceived(object3);
                                    }
                                }
                                catch (IOException ex) {
                                    if (Log.TRACE) {
                                        Log.trace("kryonet", "Unable to read TCP from: " + fromConnection, ex);
                                    } else if (Log.DEBUG) {
                                        Log.debug("kryonet", fromConnection + " update: " + ex.getMessage());
                                    }
                                    fromConnection.close();
                                }
                                catch (KryoNetException ex) {
                                    if (Log.ERROR) {
                                        Log.error("kryonet", "Error reading TCP from connection: " + fromConnection, ex);
                                    }
                                    fromConnection.close();
                                }
                            }
                            if ((ops & 4) != 4) continue;
                            try {
                                fromConnection.tcp.writeOperation();
                            }
                            catch (IOException ex) {
                                if (Log.TRACE) {
                                    Log.trace("kryonet", "Unable to write TCP to connection: " + fromConnection, ex);
                                } else if (Log.DEBUG) {
                                    Log.debug("kryonet", fromConnection + " update: " + ex.getMessage());
                                }
                                fromConnection.close();
                            }
                            continue;
                        }
                        if ((ops & 0x10) == 16) {
                            ServerSocketChannel serverChannel = this.serverChannel;
                            if (serverChannel == null) continue;
                            try {
                                SocketChannel socketChannel = serverChannel.accept();
                                if (socketChannel == null) continue;
                                this.acceptOperation(socketChannel);
                            }
                            catch (IOException ex) {
                                if (!Log.DEBUG) continue;
                                Log.debug("kryonet", "Unable to accept new connection.", ex);
                            }
                            continue;
                        }
                        if (udp == null) {
                            selectionKey.channel().close();
                            continue;
                        }
                        try {
                            fromAddress = udp.readFromAddress();
                        }
                        catch (IOException ex) {
                            if (!Log.WARN) continue;
                            Log.warn("kryonet", "Error reading UDP data.", ex);
                            continue;
                        }
                        if (fromAddress == null) continue;
                        for (Connection connection : this.connections) {
                            if (!fromAddress.equals(connection.udpRemoteAddress)) continue;
                            fromConnection = connection;
                            break;
                        }
                        try {
                            object2 = udp.readObject(fromConnection);
                        }
                        catch (KryoNetException ex) {
                            if (!Log.WARN) continue;
                            if (fromConnection != null) {
                                if (!Log.ERROR) continue;
                                Log.error("kryonet", "Error reading UDP from connection: " + fromConnection, ex);
                                continue;
                            }
                            Log.warn("kryonet", "Error reading UDP from unregistered address: " + fromAddress, ex);
                            continue;
                        }
                        if (object2 instanceof FrameworkMessage) {
                            if (object2 instanceof FrameworkMessage.RegisterUDP) {
                                Connection connection;
                                int fromConnectionID = ((FrameworkMessage.RegisterUDP)object2).connectionID;
                                connection = this.pendingConnections.remove(fromConnectionID);
                                if (connection != null) {
                                    if (connection.udpRemoteAddress != null) continue;
                                    connection.udpRemoteAddress = fromAddress;
                                    this.addConnection(connection);
                                    connection.sendTCP(new FrameworkMessage.RegisterUDP());
                                    if (Log.DEBUG) {
                                        Log.debug("kryonet", "Port " + udp.datagramChannel.socket().getLocalPort() + "/UDP connected to: " + fromAddress);
                                    }
                                    connection.notifyConnected();
                                    continue;
                                }
                                if (!Log.DEBUG) continue;
                                Log.debug("kryonet", "Ignoring incoming RegisterUDP with invalid connection ID: " + fromConnectionID);
                                continue;
                            }
                            if (object2 instanceof FrameworkMessage.DiscoverHost) {
                                try {
                                    boolean responseSent = this.discoveryHandler.onDiscoverHost(udp, fromAddress, this.serialization);
                                    if (!Log.DEBUG || !responseSent) continue;
                                    Log.debug("kryonet", "Responded to host discovery from: " + fromAddress);
                                }
                                catch (IOException ex) {
                                    if (!Log.WARN) continue;
                                    Log.warn("kryonet", "Error replying to host discovery from: " + fromAddress, ex);
                                }
                                continue;
                            }
                        }
                        if (fromConnection != null) {
                            if (Log.DEBUG) {
                                String objectString;
                                String string = objectString = object2 == null ? "null" : object2.getClass().getSimpleName();
                                if (object2 instanceof FrameworkMessage) {
                                    if (Log.TRACE) {
                                        Log.trace("kryonet", fromConnection + " received UDP: " + objectString);
                                    }
                                } else {
                                    Log.debug("kryonet", fromConnection + " received UDP: " + objectString);
                                }
                            }
                            fromConnection.notifyReceived(object2);
                            continue;
                        }
                        if (!Log.DEBUG) continue;
                        Log.debug("kryonet", "Ignoring UDP from unregistered address: " + fromAddress);
                    }
                    catch (CancelledKeyException ex) {
                        if (fromConnection != null) {
                            fromConnection.close();
                            continue;
                        }
                        selectionKey.channel().close();
                    }
                }
            }
        }
        long time = System.currentTimeMillis();
        for (Connection connection : this.connections) {
            if (connection.tcp.isTimedOut(time)) {
                if (Log.DEBUG) {
                    Log.debug("kryonet", connection + " timed out.");
                }
                connection.close();
            } else if (connection.tcp.needsKeepAlive(time)) {
                connection.sendTCP(FrameworkMessage.keepAlive);
            }
            if (!connection.isIdle()) continue;
            connection.notifyIdle();
        }
    }

    private void keepAlive() {
        long time = System.currentTimeMillis();
        for (Connection connection : this.connections) {
            if (!connection.tcp.needsKeepAlive(time)) continue;
            connection.sendTCP(FrameworkMessage.keepAlive);
        }
    }

    public void run() {
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread started.");
        }
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(250);
            }
            catch (IOException ex) {
                if (Log.ERROR) {
                    Log.error("kryonet", "Error updating server connections.", ex);
                }
                this.close();
            }
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread stopped.");
        }
    }

    public void start() {
        new Thread((Runnable)this, "Server").start();
    }

    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.close();
        if (Log.TRACE) {
            Log.trace("kryonet", "Server thread stopping.");
        }
        this.shutdown = true;
    }

    private void acceptOperation(SocketChannel socketChannel) {
        block7: {
            Connection connection = this.newConnection();
            connection.initialize(this.serialization, this.writeBufferSize, this.objectBufferSize);
            connection.endPoint = this;
            UdpConnection udp = this.udp;
            if (udp != null) {
                connection.udp = udp;
            }
            try {
                SelectionKey selectionKey = connection.tcp.accept(this.selector, socketChannel);
                selectionKey.attach(connection);
                int id = this.nextConnectionID++;
                if (this.nextConnectionID == -1) {
                    this.nextConnectionID = 1;
                }
                connection.id = id;
                connection.setConnected(true);
                connection.addListener(this.dispatchListener);
                if (udp == null) {
                    this.addConnection(connection);
                } else {
                    this.pendingConnections.put(id, connection);
                }
                FrameworkMessage.RegisterTCP registerConnection = new FrameworkMessage.RegisterTCP();
                registerConnection.connectionID = id;
                connection.sendTCP(registerConnection);
                if (udp == null) {
                    connection.notifyConnected();
                }
            }
            catch (IOException ex) {
                connection.close();
                if (!Log.DEBUG) break block7;
                Log.debug("kryonet", "Unable to accept TCP connection.", ex);
            }
        }
    }

    protected Connection newConnection() {
        return new Connection();
    }

    private void addConnection(Connection connection) {
        Connection[] newConnections = new Connection[this.connections.length + 1];
        newConnections[0] = connection;
        System.arraycopy(this.connections, 0, newConnections, 1, this.connections.length);
        this.connections = newConnections;
    }

    void removeConnection(Connection connection) {
        ArrayList<Connection> temp = new ArrayList<Connection>(Arrays.asList(this.connections));
        temp.remove(connection);
        this.connections = temp.toArray(new Connection[temp.size()]);
        this.pendingConnections.remove(connection.id);
    }

    public void sendToAllTCP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendTCP(object);
        }
    }

    public void sendToAllExceptTCP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == connectionID) continue;
            connection.sendTCP(object);
        }
    }

    public void sendToTCP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != connectionID) continue;
            connection.sendTCP(object);
            break;
        }
    }

    public void sendToAllUDP(Object object) {
        for (Connection connection : this.connections) {
            connection.sendUDP(object);
        }
    }

    public void sendToAllExceptUDP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id == connectionID) continue;
            connection.sendUDP(object);
        }
    }

    public void sendToUDP(int connectionID, Object object) {
        for (Connection connection : this.connections) {
            if (connection.id != connectionID) continue;
            connection.sendUDP(object);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listeners = this.listeners;
            int n = listeners.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (listener != listeners[i2]) continue;
                return;
            }
            Listener[] newListeners = new Listener[n + 1];
            newListeners[0] = listener;
            System.arraycopy(listeners, 0, newListeners, 1, n);
            this.listeners = newListeners;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server listener added: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listeners = this.listeners;
            int n = listeners.length;
            Listener[] newListeners = new Listener[n - 1];
            int ii = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                Listener copyListener = listeners[i2];
                if (listener == copyListener) continue;
                if (ii == n - 1) {
                    return;
                }
                newListeners[ii++] = copyListener;
            }
            this.listeners = newListeners;
        }
        if (Log.TRACE) {
            Log.trace("kryonet", "Server listener removed: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        UdpConnection udp;
        Connection[] connections = this.connections;
        if (Log.INFO && connections.length > 0) {
            Log.info("kryonet", "Closing server connections...");
        }
        int n = connections.length;
        for (int i2 = 0; i2 < n; ++i2) {
            connections[i2].close();
        }
        connections = new Connection[]{};
        ServerSocketChannel serverChannel = this.serverChannel;
        if (serverChannel != null) {
            block12: {
                try {
                    serverChannel.close();
                    if (Log.INFO) {
                        Log.info("kryonet", "Server closed.");
                    }
                }
                catch (IOException ex) {
                    if (!Log.DEBUG) break block12;
                    Log.debug("kryonet", "Unable to close server.", ex);
                }
            }
            this.serverChannel = null;
        }
        if ((udp = this.udp) != null) {
            udp.close();
            this.udp = null;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.selector.wakeup();
            try {
                this.selector.selectNow();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public void dispose() throws IOException {
        this.close();
        this.selector.close();
    }

    public Thread getUpdateThread() {
        return this.updateThread;
    }

    public Connection[] getConnections() {
        return this.connections;
    }
}

