/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.reflectasm;

import com.esotericsoftware.reflectasm.AccessClassLoader;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.ClassWriter;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.Label;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.MethodVisitor;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodAccess {
    private String[] methodNames;
    private Class[][] parameterTypes;
    private Class[] returnTypes;

    public abstract Object invoke(Object var1, int var2, Object ... var3);

    public Object invoke(Object object, String methodName, Class[] paramTypes, Object ... args2) {
        return this.invoke(object, this.getIndex(methodName, paramTypes), args2);
    }

    public Object invoke(Object object, String methodName, Object ... args2) {
        return this.invoke(object, this.getIndex(methodName, args2 == null ? 0 : args2.length), args2);
    }

    public int getIndex(String methodName) {
        int n = this.methodNames.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!this.methodNames[i2].equals(methodName)) continue;
            return i2;
        }
        throw new IllegalArgumentException("Unable to find public method: " + methodName);
    }

    public int getIndex(String methodName, Class ... paramTypes) {
        int n = this.methodNames.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!this.methodNames[i2].equals(methodName) || !Arrays.equals(paramTypes, this.parameterTypes[i2])) continue;
            return i2;
        }
        throw new IllegalArgumentException("Unable to find public method: " + methodName + " " + Arrays.toString(paramTypes));
    }

    public int getIndex(String methodName, int paramsCount) {
        int n = this.methodNames.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!this.methodNames[i2].equals(methodName) || this.parameterTypes[i2].length != paramsCount) continue;
            return i2;
        }
        throw new IllegalArgumentException("Unable to find public method: " + methodName + " with " + paramsCount + " params.");
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public Class[][] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class[] getReturnTypes() {
        return this.returnTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodAccess get(Class type2) {
        Class<?> accessClass;
        AccessClassLoader loader;
        ArrayList<Method> methods2 = new ArrayList<Method>();
        boolean isInterface = type2.isInterface();
        if (!isInterface) {
            for (Class nextClass = type2; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                MethodAccess.addDeclaredMethodsToList(nextClass, methods2);
            }
        } else {
            MethodAccess.recursiveAddInterfaceMethodsToList(type2, methods2);
        }
        int n = methods2.size();
        String[] methodNames = new String[n];
        Class[][] parameterTypes = new Class[n][];
        Class[] returnTypes = new Class[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Method method = methods2.get(i2);
            methodNames[i2] = method.getName();
            parameterTypes[i2] = method.getParameterTypes();
            returnTypes[i2] = method.getReturnType();
        }
        String className = type2.getName();
        String accessClassName = className + "MethodAccess";
        if (accessClassName.startsWith("java.")) {
            accessClassName = "reflectasm." + accessClassName;
        }
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type2);
        synchronized (accessClassLoader) {
            try {
                accessClass = loader.loadClass(accessClassName);
            }
            catch (ClassNotFoundException ignored) {
                String accessClassNameInternal = accessClassName.replace('.', '/');
                String classNameInternal = className.replace('.', '/');
                ClassWriter cw = new ClassWriter(1);
                cw.visit(196653, 33, accessClassNameInternal, null, "com/esotericsoftware/reflectasm/MethodAccess", null);
                MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, "com/esotericsoftware/reflectasm/MethodAccess", "<init>", "()V");
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                mv = cw.visitMethod(129, "invoke", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                if (!methods2.isEmpty()) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, classNameInternal);
                    mv.visitVarInsn(58, 4);
                    mv.visitVarInsn(21, 2);
                    Label[] labels = new Label[n];
                    for (int i3 = 0; i3 < n; ++i3) {
                        labels[i3] = new Label();
                    }
                    Label defaultLabel = new Label();
                    mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
                    StringBuilder buffer = new StringBuilder(128);
                    for (int i4 = 0; i4 < n; ++i4) {
                        mv.visitLabel(labels[i4]);
                        if (i4 == 0) {
                            mv.visitFrame(1, 1, new Object[]{classNameInternal}, 0, null);
                        } else {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 4);
                        buffer.setLength(0);
                        buffer.append('(');
                        String methodName = methodNames[i4];
                        Class[] paramTypes = parameterTypes[i4];
                        Class returnType = returnTypes[i4];
                        for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
                            mv.visitVarInsn(25, 3);
                            mv.visitIntInsn(16, paramIndex);
                            mv.visitInsn(50);
                            Type paramType = Type.getType(paramTypes[paramIndex]);
                            switch (paramType.getSort()) {
                                case 1: {
                                    mv.visitTypeInsn(192, "java/lang/Boolean");
                                    mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                                    break;
                                }
                                case 3: {
                                    mv.visitTypeInsn(192, "java/lang/Byte");
                                    mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                                    break;
                                }
                                case 2: {
                                    mv.visitTypeInsn(192, "java/lang/Character");
                                    mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                                    break;
                                }
                                case 4: {
                                    mv.visitTypeInsn(192, "java/lang/Short");
                                    mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                                    break;
                                }
                                case 5: {
                                    mv.visitTypeInsn(192, "java/lang/Integer");
                                    mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                                    break;
                                }
                                case 6: {
                                    mv.visitTypeInsn(192, "java/lang/Float");
                                    mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                                    break;
                                }
                                case 7: {
                                    mv.visitTypeInsn(192, "java/lang/Long");
                                    mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                                    break;
                                }
                                case 8: {
                                    mv.visitTypeInsn(192, "java/lang/Double");
                                    mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                                    break;
                                }
                                case 9: {
                                    mv.visitTypeInsn(192, paramType.getDescriptor());
                                    break;
                                }
                                case 10: {
                                    mv.visitTypeInsn(192, paramType.getInternalName());
                                }
                            }
                            buffer.append(paramType.getDescriptor());
                        }
                        buffer.append(')');
                        buffer.append(Type.getDescriptor(returnType));
                        mv.visitMethodInsn(isInterface ? 185 : 182, classNameInternal, methodName, buffer.toString());
                        switch (Type.getType(returnType).getSort()) {
                            case 0: {
                                mv.visitInsn(1);
                                break;
                            }
                            case 1: {
                                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                                break;
                            }
                            case 3: {
                                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                                break;
                            }
                            case 2: {
                                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                                break;
                            }
                            case 4: {
                                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                                break;
                            }
                            case 5: {
                                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                                break;
                            }
                            case 6: {
                                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                                break;
                            }
                            case 7: {
                                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                                break;
                            }
                            case 8: {
                                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                            }
                        }
                        mv.visitInsn(176);
                    }
                    mv.visitLabel(defaultLabel);
                    mv.visitFrame(3, 0, null, 0, null);
                }
                mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
                mv.visitInsn(89);
                mv.visitTypeInsn(187, "java/lang/StringBuilder");
                mv.visitInsn(89);
                mv.visitLdcInsn("Method not found: ");
                mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
                mv.visitVarInsn(21, 2);
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
                mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
                mv.visitInsn(191);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                cw.visitEnd();
                byte[] data2 = cw.toByteArray();
                accessClass = loader.defineClass(accessClassName, data2);
            }
        }
        try {
            MethodAccess access = (MethodAccess)accessClass.newInstance();
            access.methodNames = methodNames;
            access.parameterTypes = parameterTypes;
            access.returnTypes = returnTypes;
            return access;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error constructing method access class: " + accessClassName, ex);
        }
    }

    private static void addDeclaredMethodsToList(Class type2, ArrayList<Method> methods2) {
        for (Method method : type2.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers)) continue;
            methods2.add(method);
        }
    }

    private static void recursiveAddInterfaceMethodsToList(Class interfaceType, ArrayList<Method> methods2) {
        MethodAccess.addDeclaredMethodsToList(interfaceType, methods2);
        for (Class<?> nextInterface : interfaceType.getInterfaces()) {
            MethodAccess.recursiveAddInterfaceMethodsToList(nextInterface, methods2);
        }
    }
}

