/*
 * Decompiled with CFR 0.152.
 */
package de.hype.bingonet.shared.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lde/hype/bingonet/shared/json/InstantSerializer;", "Lcom/google/gson/JsonSerializer;", "Ljava/time/Instant;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Ljava/time/Instant;", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "serialize", "(Ljava/time/Instant;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;", "1.8.9"})
public final class InstantSerializer
implements JsonSerializer<Instant>,
JsonDeserializer<Instant> {
    @NotNull
    public Instant deserialize(@NotNull JsonElement json2, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context2) {
        Intrinsics.checkNotNullParameter(json2, "json");
        Intrinsics.checkNotNullParameter(typeOfT, "typeOfT");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (json2.isJsonObject()) {
            JsonObject jsonObject = json2.getAsJsonObject();
            long epochSecond = jsonObject.get("epochSecond").getAsLong();
            int nanoAdjustment = jsonObject.get("nanoAdjustment").getAsInt();
            Instant instant = Instant.ofEpochSecond(epochSecond, nanoAdjustment);
            Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(...)");
            return instant;
        }
        long epochMilli = json2.getAsLong();
        Instant instant = Instant.ofEpochMilli(epochMilli);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(...)");
        return instant;
    }

    @NotNull
    public JsonElement serialize(@NotNull Instant src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context2) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(typeOfSrc, "typeOfSrc");
        Intrinsics.checkNotNullParameter(context2, "context");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("epochSecond", (Number)src.getEpochSecond());
        jsonObject.addProperty("nanoAdjustment", (Number)src.getNano());
        jsonObject.addProperty("toString", src.atZone(ZoneId.of("UTC")).toString());
        return (JsonElement)jsonObject;
    }
}

