/*
 * Decompiled with CFR 0.152.
 */
package de.hype.bingonet.shared.objects;

import de.hype.bingonet.shared.objects.Position;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001;B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u0015\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0010J%\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0010J%\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001bJ\u0015\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001e\u00a2\u0006\u0004\b#\u0010!J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010*\u001a\u00020)2\b\u0010(\u001a\u0004\u0018\u00010'H\u0096\u0002\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0018\u0010/\u001a\u00020,2\u0006\u0010(\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b/\u00100J\u0015\u00101\u001a\u00020)2\u0006\u0010(\u001a\u00020\u0000\u00a2\u0006\u0004\b1\u00102J\u0015\u00104\u001a\u00020\u00022\u0006\u00103\u001a\u00020\u0002\u00a2\u0006\u0004\b4\u00105R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00106\u001a\u0004\b7\u00108R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00106\u001a\u0004\b9\u00108R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00106\u001a\u0004\b:\u00108\u00a8\u0006<"}, d2={"Lde/hype/bingonet/shared/objects/Vector3d;", "", "", "x", "y", "z", "<init>", "(DDD)V", "Lde/hype/bingonet/shared/objects/Position;", "pos", "(Lde/hype/bingonet/shared/objects/Position;)V", "", "asLong", "()J", "vec", "subtractReverse", "(Lde/hype/bingonet/shared/objects/Vector3d;)Lde/hype/bingonet/shared/objects/Vector3d;", "normalize", "()Lde/hype/bingonet/shared/objects/Vector3d;", "crossProduct", "subtract", "(DDD)Lde/hype/bingonet/shared/objects/Vector3d;", "add", "addVector", "distanceTo", "(Lde/hype/bingonet/shared/objects/Vector3d;)D", "getIntermediateWithXValue", "(Lde/hype/bingonet/shared/objects/Vector3d;D)Lde/hype/bingonet/shared/objects/Vector3d;", "getIntermediateWithYValue", "getIntermediateWithZValue", "", "pitch", "rotatePitch", "(F)Lde/hype/bingonet/shared/objects/Vector3d;", "yaw", "rotateYaw", "", "toString", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "compareTo", "(Lde/hype/bingonet/shared/objects/Vector3d;)I", "signumEquals", "(Lde/hype/bingonet/shared/objects/Vector3d;)Z", "value", "sqrt", "(D)D", "D", "getX", "()D", "getY", "getZ", "Companion", "1.8.9"})
public final class Vector3d
implements Comparable<Vector3d> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private static final Vector3d NULL_VECTOR = new Vector3d(0.0, 0.0, 0.0);
    @NotNull
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION;
    private static final int SIZE_BITS_X;
    private static final int SIZE_BITS_Z;
    private static final int SIZE_BITS_Y;
    private static final long BITS_Y;
    private static final int BIT_SHIFT_Z;
    private static final int BIT_SHIFT_X;
    private static final long BITS_Z;
    private static final long BITS_X;
    @NotNull
    private static final float[] SIN_TABLE;

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public Vector3d(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        this(pos.x, pos.y, pos.z);
    }

    public final long asLong() {
        long l = 0L;
        l |= ((long)this.x & BITS_X) << BIT_SHIFT_X;
        l |= ((long)this.y & BITS_Y) << 0;
        return l |= ((long)this.z & BITS_Z) << BIT_SHIFT_Z;
    }

    @NotNull
    public final Vector3d subtractReverse(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return new Vector3d(vec.x - this.x, vec.x - this.y, vec.z - this.z);
    }

    @NotNull
    public final Vector3d normalize() {
        double base = this.x * this.x + this.y * this.y + this.z * this.z;
        return base < 1.0E-4 ? new Vector3d(0.0, 0.0, 0.0) : new Vector3d(this.x / base, this.y / base, this.z / base);
    }

    @NotNull
    public final Vector3d crossProduct(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return new Vector3d(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    @NotNull
    public final Vector3d subtract(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return this.subtract(vec.x, vec.y, vec.z);
    }

    @NotNull
    public final Vector3d subtract(double x, double y, double z) {
        return this.addVector(-x, -y, -z);
    }

    @NotNull
    public final Vector3d add(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return this.addVector(vec.x, vec.y, vec.z);
    }

    @NotNull
    public final Vector3d addVector(double x, double y, double z) {
        return new Vector3d(this.x + x, this.y + y, this.z + z);
    }

    public final double distanceTo(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        double d2 = vec.z - this.z;
        return this.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    @Nullable
    public final Vector3d getIntermediateWithXValue(@NotNull Vector3d vec, double x) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        double d2 = vec.z - this.z;
        if (d0 * d0 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (x - this.x) / d0;
        return (0.0 <= d3 ? d3 <= 1.0 : false) ? new Vector3d(this.x + d0 * d3, this.y + d1 * d3, this.z + d2 * d3) : null;
    }

    @Nullable
    public final Vector3d getIntermediateWithYValue(@NotNull Vector3d vec, double y) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        double d2 = vec.z - this.z;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (y - this.y) / d1;
        return (0.0 <= d3 ? d3 <= 1.0 : false) ? new Vector3d(this.x + d0 * d3, this.y + d1 * d3, this.z + d2 * d3) : null;
    }

    @Nullable
    public final Vector3d getIntermediateWithZValue(@NotNull Vector3d vec, double z) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        double d2 = vec.z - this.z;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (z - this.z) / d2;
        return (0.0 <= d3 ? d3 <= 1.0 : false) ? new Vector3d(this.x + d0 * d3, this.y + d1 * d3, this.z + d2 * d3) : null;
    }

    @NotNull
    public final Vector3d rotatePitch(float pitch) {
        float f = Companion.cos(pitch);
        float f1 = Companion.sin(pitch);
        double d0 = this.x;
        double d1 = this.y * (double)f + this.z * (double)f1;
        double d2 = this.z * (double)f - this.y * (double)f1;
        return new Vector3d(d0, d1, d2);
    }

    @NotNull
    public final Vector3d rotateYaw(float yaw) {
        float f = Companion.cos(yaw);
        float f1 = Companion.sin(yaw);
        double d0 = this.x * (double)f + this.z * (double)f1;
        double d1 = this.y;
        double d2 = this.z * (double)f - this.x * (double)f1;
        return new Vector3d(d0, d1, d2);
    }

    @NotNull
    public String toString() {
        return "" + this.x + ' ' + this.y + ' ' + this.z;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3d)) {
            return false;
        }
        return this.x == ((Vector3d)other).x && this.y == ((Vector3d)other).y && this.z == ((Vector3d)other).z;
    }

    public int hashCode() {
        long bits = 1L;
        bits = 31L * bits + Vector3d.Companion.doubleToLongBits(this.x);
        bits = 31L * bits + Vector3d.Companion.doubleToLongBits(this.y);
        bits = 31L * bits + Vector3d.Companion.doubleToLongBits(this.z);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public int compareTo(@NotNull Vector3d other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.y == other.y ? (this.z == other.z ? (int)(this.x - other.x) : (int)(this.z - other.z)) : (int)(this.y - other.y);
    }

    public final boolean signumEquals(@NotNull Vector3d other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.signum(this.x) == Math.signum(other.x) && Math.signum(this.y) == Math.signum(other.y) && Math.signum(this.z) == Math.signum(other.z);
    }

    public final double sqrt(double value) {
        return this.sqrt(value);
    }

    static {
        int[] nArray = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
        MULTIPLY_DE_BRUIJN_BIT_POSITION = nArray;
        SIZE_BITS_Z = SIZE_BITS_X = 1 + Companion.floorLog2(Vector3d.Companion.smallestEncompassingPowerOfTwo(30000000));
        SIZE_BITS_Y = 64 - SIZE_BITS_X - SIZE_BITS_Z;
        BITS_Y = (1L << SIZE_BITS_Y) - 1L;
        BIT_SHIFT_Z = SIZE_BITS_Y;
        BIT_SHIFT_X = SIZE_BITS_Y + SIZE_BITS_Z;
        BITS_Z = (1L << SIZE_BITS_Z) - 1L;
        BITS_X = (1L << SIZE_BITS_X) - 1L;
        SIN_TABLE = new float[65536];
        for (int i2 = 0; i2 < 65536; ++i2) {
            Vector3d.SIN_TABLE[i2] = Companion.sin((float)i2 * (float)Math.PI * 2.0f / 65536.0f);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0010\u0014\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0007J\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0017\u0010\"\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\"\u0010 \u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010 R\u0014\u0010(\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010 R\u0014\u0010)\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010&R\u0014\u0010*\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010&R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lde/hype/bingonet/shared/objects/Vector3d$Companion;", "", "<init>", "()V", "", "value", "smallestEncompassingPowerOfTwo", "(I)I", "floorLog2", "", "isPowerOfTwo", "(I)Z", "ceilLog2", "", "d", "", "doubleToLongBits", "(D)J", "", "f", "sin", "(F)F", "cos", "Lde/hype/bingonet/shared/objects/Vector3d;", "NULL_VECTOR", "Lde/hype/bingonet/shared/objects/Vector3d;", "getNULL_VECTOR", "()Lde/hype/bingonet/shared/objects/Vector3d;", "", "MULTIPLY_DE_BRUIJN_BIT_POSITION", "[I", "SIZE_BITS_X", "I", "SIZE_BITS_Z", "SIZE_BITS_Y", "getSIZE_BITS_Y", "()I", "BITS_Y", "J", "BIT_SHIFT_Z", "BIT_SHIFT_X", "BITS_Z", "BITS_X", "", "SIN_TABLE", "[F", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vector3d getNULL_VECTOR() {
            return NULL_VECTOR;
        }

        public final int getSIZE_BITS_Y() {
            return SIZE_BITS_Y;
        }

        private final int smallestEncompassingPowerOfTwo(int value) {
            int i2 = value - 1;
            i2 |= i2 >> 1;
            i2 |= i2 >> 2;
            i2 |= i2 >> 4;
            i2 |= i2 >> 8;
            i2 |= i2 >> 16;
            return i2 + 1;
        }

        public final int floorLog2(int value) {
            return this.ceilLog2(value) - (this.isPowerOfTwo(value) ? 0 : 1);
        }

        public final boolean isPowerOfTwo(int value) {
            return value != 0 && (value & value - 1) == 0;
        }

        public final int ceilLog2(int value) {
            int v = this.isPowerOfTwo(value) ? value : this.smallestEncompassingPowerOfTwo(value);
            return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)v * 125613361L >> 27) & 0x1F];
        }

        private final long doubleToLongBits(double d) {
            return d == 0.0 ? 0L : Double.doubleToLongBits(d);
        }

        public final float sin(float f) {
            return SIN_TABLE[(int)(f * 10430.378f) & 0xFFFF];
        }

        public final float cos(float value) {
            return SIN_TABLE[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

