/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.KotlinReflectionNotSupportedError;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.KotlinReflectionInternalError;
import kotlin.reflect.jvm.internal.ReflectProperties;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.calls.Caller;
import kotlin.reflect.jvm.internal.calls.ValueClassAwareCaller;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u00018B1\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001b\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010)\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001f\u001a\u0004\b'\u0010(R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010\u0018R\u0014\u0010,\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010/\u001a\u0004\b0\u00101R\u0016\u00103\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001bR\u0014\u00107\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00069"}, d2={"Lkotlin/reflect/jvm/internal/KParameterImpl;", "Lkotlin/reflect/KParameter;", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "callable", "", "index", "Lkotlin/reflect/KParameter$Kind;", "kind", "Lkotlin/Function0;", "Lkotlin/reflect/jvm/internal/impl/descriptors/ParameterDescriptor;", "computeDescriptor", "<init>", "(Lkotlin/reflect/jvm/internal/KCallableImpl;ILkotlin/reflect/KParameter$Kind;Lkotlin/jvm/functions/Function0;)V", "", "Ljava/lang/reflect/Type;", "types", "compoundType", "([Ljava/lang/reflect/Type;)Ljava/lang/reflect/Type;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "", "", "annotations$delegate", "Lkotlin/reflect/jvm/internal/ReflectProperties$LazySoftVal;", "getAnnotations", "()Ljava/util/List;", "annotations", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "getCallable", "()Lkotlin/reflect/jvm/internal/KCallableImpl;", "descriptor$delegate", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "descriptor", "I", "getIndex", "isOptional", "()Z", "isVararg", "Lkotlin/reflect/KParameter$Kind;", "getKind", "()Lkotlin/reflect/KParameter$Kind;", "getName", "name", "Lkotlin/reflect/KType;", "getType", "()Lkotlin/reflect/KType;", "type", "CompoundTypeImpl", "kotlin-reflection"})
@SourceDebugExtension(value={"SMAP\nKParameterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KParameterImpl.kt\nkotlin/reflect/jvm/internal/KParameterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class KParameterImpl
implements KParameter {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final KCallableImpl<?> callable;
    private final int index;
    @NotNull
    private final KParameter.Kind kind;
    @NotNull
    private final ReflectProperties.LazySoftVal descriptor$delegate;
    @NotNull
    private final ReflectProperties.LazySoftVal annotations$delegate;

    public KParameterImpl(@NotNull KCallableImpl<?> callable, int index, @NotNull KParameter.Kind kind, @NotNull Function0<? extends ParameterDescriptor> computeDescriptor) {
        Intrinsics.checkNotNullParameter(callable, "callable");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(computeDescriptor, "computeDescriptor");
        this.callable = callable;
        this.index = index;
        this.kind = kind;
        this.descriptor$delegate = ReflectProperties.lazySoft(computeDescriptor);
        this.annotations$delegate = ReflectProperties.lazySoft((Function0)new Function0<List<? extends Annotation>>(this){
            final /* synthetic */ KParameterImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<Annotation> invoke() {
                return UtilKt.computeAnnotations(KParameterImpl.access$getDescriptor(this.this$0));
            }
        });
    }

    @NotNull
    public final KCallableImpl<?> getCallable() {
        return this.callable;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public KParameter.Kind getKind() {
        return this.kind;
    }

    private final ParameterDescriptor getDescriptor() {
        Object t = this.descriptor$delegate.getValue(this, $$delegatedProperties[0]);
        Intrinsics.checkNotNullExpressionValue(t, "<get-descriptor>(...)");
        return (ParameterDescriptor)t;
    }

    @Override
    @NotNull
    public List<Annotation> getAnnotations() {
        Object t = this.annotations$delegate.getValue(this, $$delegatedProperties[1]);
        Intrinsics.checkNotNullExpressionValue(t, "<get-annotations>(...)");
        return (List)t;
    }

    @Override
    @Nullable
    public String getName() {
        ParameterDescriptor parameterDescriptor = this.getDescriptor();
        ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)parameterDescriptor : null;
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor valueParameter = valueParameterDescriptor;
        if (valueParameter.getContainingDeclaration().hasSynthesizedParameterNames()) {
            return null;
        }
        Name name2 = valueParameter.getName();
        Intrinsics.checkNotNullExpressionValue(name2, "valueParameter.name");
        Name name3 = name2;
        return name3.isSpecial() ? null : name3.asString();
    }

    private final Type compoundType(Type ... types) {
        Type type2;
        switch (types.length) {
            case 0: {
                throw new KotlinReflectionNotSupportedError("Expected at least 1 type for compound type");
            }
            case 1: {
                type2 = ArraysKt.single(types);
                break;
            }
            default: {
                type2 = new CompoundTypeImpl(types);
            }
        }
        return type2;
    }

    @Override
    @NotNull
    public KType getType() {
        KotlinType kotlinType = this.getDescriptor().getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.type");
        return new KTypeImpl(kotlinType, (Function0<? extends Type>)new Function0<Type>(this){
            final /* synthetic */ KParameterImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Type invoke() {
                Type type2;
                ParameterDescriptor descriptor2 = KParameterImpl.access$getDescriptor(this.this$0);
                if (descriptor2 instanceof ReceiverParameterDescriptor && Intrinsics.areEqual(UtilKt.getInstanceReceiverParameter(this.this$0.getCallable().getDescriptor()), descriptor2) && this.this$0.getCallable().getDescriptor().getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    DeclarationDescriptor declarationDescriptor = this.this$0.getCallable().getDescriptor().getContainingDeclaration();
                    Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    Class<?> clazz = UtilKt.toJavaClass((ClassDescriptor)declarationDescriptor);
                    if (clazz == null) {
                        throw new KotlinReflectionInternalError("Cannot determine receiver Java type of inherited declaration: " + descriptor2);
                    }
                    type2 = clazz;
                } else {
                    Caller<?> caller2 = this.this$0.getCallable().getCaller();
                    if (caller2 instanceof ValueClassAwareCaller) {
                        IntRange slice = ((ValueClassAwareCaller)caller2).getRealSlicesOfParameters(this.this$0.getIndex());
                        List<Type> parameterTypes = CollectionsKt.slice(caller2.getParameterTypes(), slice);
                        Collection $this$toTypedArray$iv = parameterTypes;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
                        type2 = KParameterImpl.access$compoundType(this.this$0, Arrays.copyOf(typeArray, typeArray.length));
                    } else if (caller2 instanceof ValueClassAwareCaller.MultiFieldValueClassPrimaryConstructorCaller) {
                        Collection $this$toTypedArray$iv = ((ValueClassAwareCaller.MultiFieldValueClassPrimaryConstructorCaller)caller2).getOriginalParametersGroups().get(this.this$0.getIndex());
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Class[] classArray = thisCollection$iv.toArray(new Class[0]);
                        type2 = KParameterImpl.access$compoundType(this.this$0, Arrays.copyOf(classArray, classArray.length));
                    } else {
                        type2 = caller2.getParameterTypes().get(this.this$0.getIndex());
                    }
                }
                return type2;
            }
        });
    }

    @Override
    public boolean isOptional() {
        ParameterDescriptor parameterDescriptor = this.getDescriptor();
        ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)parameterDescriptor : null;
        return valueParameterDescriptor != null ? DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameterDescriptor) : false;
    }

    @Override
    public boolean isVararg() {
        ParameterDescriptor it = this.getDescriptor();
        boolean bl = false;
        return it instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)it).getVarargElementType() != null;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof KParameterImpl && Intrinsics.areEqual(this.callable, ((KParameterImpl)other).callable) && this.getIndex() == ((KParameterImpl)other).getIndex();
    }

    public int hashCode() {
        return this.callable.hashCode() * 31 + Integer.hashCode(this.getIndex());
    }

    @NotNull
    public String toString() {
        return ReflectionObjectRenderer.INSTANCE.renderParameter(this);
    }

    public static final /* synthetic */ ParameterDescriptor access$getDescriptor(KParameterImpl $this) {
        return $this.getDescriptor();
    }

    public static final /* synthetic */ Type access$compoundType(KParameterImpl $this, Type ... types) {
        return $this.compoundType(types);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KParameterImpl.class), "descriptor", "getDescriptor()Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KParameterImpl.class), "annotations", "getAnnotations()Ljava/util/List;"))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0012R\u001f\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lkotlin/reflect/jvm/internal/KParameterImpl$CompoundTypeImpl;", "Ljava/lang/reflect/Type;", "", "types", "<init>", "([Ljava/lang/reflect/Type;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "getTypeName", "()Ljava/lang/String;", "", "hashCode", "()I", "toString", "I", "[Ljava/lang/reflect/Type;", "getTypes", "()[Ljava/lang/reflect/Type;", "kotlin-reflection"})
    private static final class CompoundTypeImpl
    implements Type {
        @NotNull
        private final Type[] types;
        private final int hashCode;

        public CompoundTypeImpl(@NotNull Type[] types) {
            Intrinsics.checkNotNullParameter(types, "types");
            this.types = types;
            this.hashCode = Arrays.hashCode(this.types);
        }

        @Override
        @NotNull
        public String getTypeName() {
            return ArraysKt.joinToString$default(this.types, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", 0, null, null, 56, null);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof CompoundTypeImpl && Arrays.equals(this.types, ((CompoundTypeImpl)other).types);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @NotNull
        public String toString() {
            return this.getTypeName();
        }
    }
}

