package at.hannibal2.skyhanni.features.gui

import at.hannibal2.skyhanni.SkyHanniMod
import at.hannibal2.skyhanni.api.event.HandleEvent
import at.hannibal2.skyhanni.config.core.config.Position
import at.hannibal2.skyhanni.data.model.TabWidget
import at.hannibal2.skyhanni.events.GuiRenderEvent
import at.hannibal2.skyhanni.events.ProfileJoinEvent
import at.hannibal2.skyhanni.skyhannimodule.SkyHanniModule
import at.hannibal2.skyhanni.test.command.ErrorManager
import at.hannibal2.skyhanni.utils.RenderUtils.renderStrings
import at.hannibal2.skyhanni.utils.SkyBlockUtils
import at.hannibal2.skyhanni.utils.StringUtils.allLettersFirstUppercase

enum class TabWidgetDisplay(
    private val configName: String?,
    vararg val widgets: TabWidget,
) {
    SOULFLOW(null, TabWidget.SOULFLOW),
    COINS("Bank and Interest", TabWidget.BANK, TabWidget.INTEREST),
    SB_LEVEL("Skyblock Level", TabWidget.SB_LEVEL),
    PROFILE(null, TabWidget.PROFILE),
    PLAYER_LIST("Players", TabWidget.PLAYER_LIST),
    PET(null, TabWidget.PET),
    PET_TRAINING("Pet Upgrade Info", TabWidget.PET_SITTER, TabWidget.PET_TRAINING),
    STATS(null, TabWidget.STATS, TabWidget.DUNGEON_SKILLS_AND_STATS),
    DUNGEON_TEAM("Dungeon Info about every person", TabWidget.DUNGEON_PARTY),
    DUNGEON_PUZZLE("Dungeon Info about puzzles", TabWidget.DUNGEON_PUZZLE),
    DUNGEON_OVERALL("Dungeon General Info (very long)", TabWidget.DUNGEON_STATS),
    BESTIARY(null, TabWidget.BESTIARY),
    DRAGON("Dragon Fight Info", TabWidget.DRAGON),
    PROTECTOR("Protector State", TabWidget.PROTECTOR),
    SHEN_RIFT("Shen's Auction inside the Rift", TabWidget.RIFT_SHEN),
    MINION("Minion Info", TabWidget.MINION),
    COLLECTION(null, TabWidget.COLLECTION),
    TIMERS(null, TabWidget.TIMERS),
    FIRE_SALE(null, TabWidget.FIRE_SALE),
    RAIN("Park Rain", TabWidget.RAIN),
    PEST_TRAPS("Pest Traps", TabWidget.PEST_TRAPS, TabWidget.FULL_TRAPS, TabWidget.NO_BAIT),
    FULL_PROFILE_WIDGET(
        "Profile Widget",
        TabWidget.PROFILE,
        TabWidget.SB_LEVEL,
        TabWidget.BANK,
        TabWidget.INTEREST,
        TabWidget.SOULFLOW,
        TabWidget.FAIRY_SOULS,
    ),
    EYES("Eyes placed", TabWidget.EYES_PLACED),
    MOONGLADE_BEACON("Moonglade Beacon", TabWidget.MOONGLADE_BEACON),
    STARBORN_TEMPLE("Starborn Temple", TabWidget.STARBORN_TEMPLE),
    SHARD_TRAPS("Shard Traps", TabWidget.SHARD_TRAPS),
    FOREST_WHISPERS("Forest Whispers", TabWidget.FOREST_WHISPERS),
    AGATHA_CONTEST("Agatha's Contest", TabWidget.AGATHA_CONTEST),
    COMMISSIONS("Mining Commissions", TabWidget.COMMISSIONS),
    SLAYER("Slayer", TabWidget.SLAYER),
    PITY("Pity", TabWidget.PITY),
    PICKAXE_COOLDOWN("Pickaxe Cooldown", TabWidget.PICKAXE_COOLDOWN),
    ;

    val position get() = config.displayPositions[ordinal]

    override fun toString(): String {
        return configName ?: name.lowercase().allLettersFirstUppercase()
    }

    @SkyHanniModule
    companion object {

        private val config get() = SkyHanniMod.feature.gui.tabWidget
        private fun isEnabled() = SkyBlockUtils.inSkyBlock && config.enabled

        @HandleEvent
        fun onRenderOverlay(event: GuiRenderEvent.GuiOverlayRenderEvent) {
            if (!isEnabled()) return
            if (config.displayPositions.isEmpty()) return
            config.display.get().forEach { widget ->
                widget.position.renderStrings(
                    widget.widgets.flatMap { subWidget ->
                        subWidget.lines
                    },
                    posLabel = "Display Widget: ${widget.name}",
                )
            }
        }

        @HandleEvent
        fun onJoin(event: ProfileJoinEvent) {
            // Validation that the displayPositions in the config is correct
            val sizeDiff = TabWidgetDisplay.entries.size - config.displayPositions.size
            if (sizeDiff == 0) return
            if (sizeDiff < 0) {
                ErrorManager.skyHanniError(
                    "Invalid State of config.displayPositions",
                    "Display" to TabWidgetDisplay.entries,
                    "Positions" to config.displayPositions,
                )
            } else {
                config.displayPositions.addAll(List(sizeDiff) { Position() })
            }
        }
    }
}
