package at.hannibal2.skyhanni.features.misc

import at.hannibal2.skyhanni.SkyHanniMod
import at.hannibal2.skyhanni.api.event.HandleEvent
import at.hannibal2.skyhanni.config.enums.OutsideSBFeature
import at.hannibal2.skyhanni.events.GuiRenderEvent
import at.hannibal2.skyhanni.skyhannimodule.SkyHanniModule
import at.hannibal2.skyhanni.utils.BlockUtils.getBlockAt
import at.hannibal2.skyhanni.utils.LocationUtils
import at.hannibal2.skyhanni.utils.LorenzVec
import at.hannibal2.skyhanni.utils.NumberUtil.roundTo
import at.hannibal2.skyhanni.utils.RenderUtils.renderString
import at.hannibal2.skyhanni.utils.SkyBlockUtils
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat
import at.hannibal2.skyhanni.utils.system.PlatformUtils
import net.minecraft.block.Blocks
import kotlin.concurrent.fixedRateTimer

@SkyHanniModule
object MovementSpeedDisplay {

    private val config get() = SkyHanniMod.feature.misc

    private var display = ""
    private val soulSandSpeeds = mutableListOf<Double>()

    /**
     * This speed value represents the movement speed in blocks per second.
     * This has nothing to do with the speed stat.
     */
    var speed = 0.0
    var usingLegacySoulSandSpeed = false

    init {
        // TODO use LorenzTickEvent
        fixedRateTimer(name = "skyhanni-movement-speed-display", period = 250, initialDelay = 1_000) {
            checkSpeed()
        }
    }

    private fun checkSpeed() {
        if (!SkyBlockUtils.onHypixel) return

        speed = with(MinecraftCompat.localPlayer) {
            val oldPos = LorenzVec(lastRenderX, lastRenderY, lastRenderZ)
            val newPos = LorenzVec(pos.x, pos.y, pos.z)

            // Distance from previous tick, multiplied by TPS
            oldPos.distance(newPos) * 20
        }

        // 1.15+ has consistent soul sand speed
        val movingOnSoulSand = PlatformUtils.IS_LEGACY && LocationUtils.playerLocation().getBlockAt() == Blocks.SOUL_SAND && speed > 0.0
        if (movingOnSoulSand) {
            soulSandSpeeds.add(speed)
            if (soulSandSpeeds.size > 6) {
                speed = soulSandSpeeds.average()
                soulSandSpeeds.removeAt(0)
            }
        } else {
            soulSandSpeeds.clear()
        }
        usingLegacySoulSandSpeed = movingOnSoulSand && soulSandSpeeds.size == 6

        if (isEnabled()) {
            display = "Movement Speed: ${speed.roundTo(2)}"
        }
    }

    @HandleEvent
    fun onRenderOverlay(event: GuiRenderEvent.GuiOverlayRenderEvent) {
        if (!isEnabled()) return

        config.playerMovementSpeedPos.renderString(display, posLabel = "Movement Speed")
    }

    fun isEnabled() = SkyBlockUtils.onHypixel &&
        (SkyBlockUtils.inSkyBlock || OutsideSBFeature.MOVEMENT_SPEED.isSelected()) &&
        config.playerMovementSpeed
}
