package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.mixins.hooks.EntityRenderDispatcherHookKt;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//#if MC > 1.21.8
//$$ import net.minecraft.client.render.state.CameraRenderState;
//$$ import net.minecraft.client.render.command.OrderedRenderCommandQueue;
//#endif

@Mixin(class_898.class)
public class MixinEntityRenderDispatcher<E extends class_1297, S extends class_10017> {

    //#if MC < 1.21.9
    @Inject(method = "render(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/EntityRenderer;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/EntityRenderDispatcher;render(Lnet/minecraft/client/render/entity/state/EntityRenderState;DDDLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/EntityRenderer;)V"), cancellable = true)
    public void onRenderPre(E entity, double x, double y, double z, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, class_897<? super E, S> renderer, CallbackInfo ci) {
        if (entity instanceof class_1309 livingEntity) {
            if (new SkyHanniRenderEntityEvent.Pre<>(livingEntity, x, y, z).post()) {
                ci.cancel();
            }
        }
        EntityRenderDispatcherHookKt.setEntity(entity);
        //#else
        //$$ @Inject(method = "render", at = @At(value = "HEAD"), cancellable = true)
        //$$ public void onRenderPre(S renderState, CameraRenderState cameraRenderState, double d, double e, double f, MatrixStack matrixStack, OrderedRenderCommandQueue orderedRenderCommandQueue, CallbackInfo ci) {
        //$$     EntityRenderDispatcherHookKt.setEntity(renderState);
        //$$     Entity entity = EntityRenderDispatcherHookKt.getEntity();
        //$$     if (entity instanceof LivingEntity livingEntity) {
        //$$         // TODO confirm these are the right values for position
        //$$         if (new SkyHanniRenderEntityEvent.Pre<>(livingEntity, d, e, f).post()) {
        //$$             ci.cancel();
        //$$         }
        //$$     }
        //#endif
    }

    //#if MC < 1.21.9
    @Inject(method = "render(Lnet/minecraft/entity/Entity;DDDFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/EntityRenderer;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/EntityRenderDispatcher;render(Lnet/minecraft/client/render/entity/state/EntityRenderState;DDDLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/EntityRenderer;)V", shift = At.Shift.AFTER))
    public void onRenderPost(E entity, double x, double y, double z, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, class_897<? super E, S> renderer, CallbackInfo ci) {
        if (entity instanceof class_1309 livingEntity) {
            new SkyHanniRenderEntityEvent.Post<>(livingEntity, x, y, z).post();
        }
        //#else
        //$$ @Inject(method = "render", at = @At(value = "RETURN"))
        //$$ public void onRenderPost(S renderState, CameraRenderState cameraRenderState, double d, double e, double f, MatrixStack matrixStack, OrderedRenderCommandQueue orderedRenderCommandQueue, CallbackInfo ci) {
        //$$     Entity entity = EntityRenderDispatcherHookKt.getEntity();
        //$$     if (entity instanceof LivingEntity livingEntity) {
        //$$         // TODO confirm these are the right values for position
        //$$         new SkyHanniRenderEntityEvent.Post<>(livingEntity, d, e, f).post();
        //$$     }
        //#endif
        EntityRenderDispatcherHookKt.clearEntity();
    }
}
