package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.data.GlobalRender;
import at.hannibal2.skyhanni.data.GuiData;
import at.hannibal2.skyhanni.data.ToolTipData;
import at.hannibal2.skyhanni.data.model.TextInput;
import at.hannibal2.skyhanni.events.DrawScreenAfterEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.GuiKeyPressEvent;
import at.hannibal2.skyhanni.events.render.gui.DrawBackgroundEvent;
import at.hannibal2.skyhanni.events.render.gui.GuiMouseInputEvent;
import at.hannibal2.skyhanni.features.inventory.BetterContainers;
import at.hannibal2.skyhanni.features.inventory.wardrobe.CustomWardrobe;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
//#if MC > 1.21.8
//$$ import net.minecraft.client.gui.Click;
//$$ import net.minecraft.client.input.KeyInput;
//#endif

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Mixin(class_465.class)
public abstract class MixinHandledScreen {

    @Inject(method = "render", at = @At(value = "HEAD"), cancellable = true)
    private void renderHead(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (GlobalRender.INSTANCE.getRenderDisabled()) return;
        class_465<?> gui = (class_465<?>) (Object) this;
        if (new GuiContainerEvent.PreDraw(context, gui, gui.method_17577(), mouseX, mouseY, deltaTicks).post()) {
            GuiData.INSTANCE.setPreDrawEventCancelled(true);
            ci.cancel();
        } else {
            DelayedRun.INSTANCE.runNextTick(() -> {
                GuiData.INSTANCE.setPreDrawEventCancelled(false);
                return null;
            });
        }
    }

    @Inject(method = "render", at = @At(value = "TAIL"), cancellable = true)
    private void renderTail(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (new DrawScreenAfterEvent(context, mouseX, mouseY, ci).post()) ci.cancel();
    }

    //#if MC < 1.21.6
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;render(Lnet/minecraft/client/gui/DrawContext;IIF)V", shift = At.Shift.AFTER))
    //#else
    //$$ @Inject(method = "renderMain", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/Screen;render(Lnet/minecraft/client/gui/DrawContext;IIF)V", shift = At.Shift.AFTER))
    //#endif
    private void renderBackgroundTexture(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        if (MinecraftCompat.INSTANCE.getLocalWorldExists() && MinecraftCompat.INSTANCE.getLocalPlayerExists()) {
            new DrawBackgroundEvent(context).post();
        }
    }

    @ModifyArg(method = "drawMouseoverTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;Ljava/util/Optional;IILnet/minecraft/util/Identifier;)V"), index = 1)
    private List<class_2561> renderBackground(List<class_2561> textTooltip, @Local class_1799 itemStack, @Local(argsOnly = true) class_332 drawContext) {
        if (CustomWardrobe.shouldHideNormalTooltip()) {
            return new ArrayList<>();
        }
        return ToolTipData.processModernTooltip(drawContext, itemStack, textTooltip);
    }

    @Inject(method = "keyPressed", at = @At(value = "HEAD"), cancellable = true)
    //#if MC < 1.21.9
    private void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        //#else
        //$$ private void keyPressed(KeyInput input, CallbackInfoReturnable<Boolean> cir) {
        //$$     int keyCode = input.getKeycode();
        //#endif
        TextInput.Companion.onGuiInput(cir);
        boolean shouldCancelInventoryClose = KeyboardManager.checkIsInventoryClosure(keyCode);
        if (new GuiKeyPressEvent((class_465<?>) (Object) this).post() || shouldCancelInventoryClose) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method = "mouseClicked", at = @At(value = "HEAD"), cancellable = true)
    //#if MC < 1.21.9
    private void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        //#else
        //$$ private void mouseClicked(Click click, boolean doubled, CallbackInfoReturnable<Boolean> cir) {
        //#endif
        if (new GuiKeyPressEvent((class_465<?>) (Object) this).post()) {
            cir.setReturnValue(false);
        }
        if (new GuiMouseInputEvent((class_465<?>) (Object) this).post()) {
            cir.setReturnValue(false);
        }
    }

    //#if MC < 1.21.6
    @ModifyArg(method = "drawForeground", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIIZ)I"), index = 4)
    //#else
    //$$ @ModifyArg(method = "drawForeground", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIIZ)V"), index = 4)
    //#endif
    private int customForegroundTextColor(int colour) {
        return BetterContainers.getTextColor(colour);
    }

    @Redirect(method = "drawSlotHighlightBack", at = @At(value = "INVOKE", target = "Lnet/minecraft/screen/slot/Slot;canBeHighlighted()Z"))
    private boolean canBeHighlightedBack(class_1735 slot) {
        return BetterContainers.slotCanBeHighlighted(slot);
    }

    @Redirect(method = "drawSlotHighlightFront", at = @At(value = "INVOKE", target = "Lnet/minecraft/screen/slot/Slot;canBeHighlighted()Z"))
    private boolean canBeHighlightedFront(class_1735 slot) {
        return BetterContainers.slotCanBeHighlighted(slot);
    }

}
