package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.mixins.hooks.MinecraftInputHook;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_636;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//#if MC > 1.21
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
//#endif

@Mixin(class_310.class)
public class MixinMinecraftInputs {

    @Shadow
    public class_239 crosshairTarget;

    @Shadow
    private int attackCooldown;

    @Shadow
    @Nullable
    public class_636 interactionManager;

    @Inject(
        at = @At("HEAD"),
        method = "doItemUse",
        cancellable = true
    )
    public void handleRightClickMouse(CallbackInfo ci) {
        if (this.interactionManager.method_2923()) return;

        if (MinecraftInputHook.shouldCancelMouseRightClick(this.crosshairTarget)) ci.cancel();
    }

    @Inject(
        at = @At("HEAD"),
        method = "doAttack",
        cancellable = true
    )
    public void handleLeftClickMouse(
        //#if MC < 1.21
        //$$ CallbackInfo ci
        //#else
        CallbackInfoReturnable<Boolean> cir
        //#endif
    ) {
        if (this.attackCooldown > 0) return;

        if (MinecraftInputHook.shouldCancelMouseLeftClick(this.crosshairTarget))
            //#if MC < 1.21
            //$$ ci.cancel();
        //#else
        cir.setReturnValue(false);
        //#endif
    }

    @ModifyVariable(
        at = @At(value = "HEAD"),
        method = "handleBlockBreaking",
        argsOnly = true
    )
    public boolean handleBlockClick(boolean isLeftClick) {
        if (isLeftClick && this.attackCooldown <= 0) {
            if (MinecraftInputHook.shouldCancelContinuedBlockBreak(
                this.crosshairTarget,
                ((AccessorPlayerControllerMP) this.interactionManager).skyhanni_getCurrentBlock()
            )) return false;
        }
        return isLeftClick;
    }
}
