package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.features.misc.visualwords.ModifyVisualWords;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.List;
import net.minecraft.class_2583;
import net.minecraft.class_5225;
import net.minecraft.class_5348;

@Mixin(class_5225.class)
public class MixinTextHandler {

    @WrapMethod(
        method = "wrapLines(Lnet/minecraft/text/StringVisitable;ILnet/minecraft/text/Style;Lnet/minecraft/text/StringVisitable;)Ljava/util/List;"
    )
    private List<class_5348> dontWrapOtherLines(class_5348 text, int maxWidth, class_2583 style, class_5348 wrappedLinePrefix, Operation<List<class_5348>> original) {
        ModifyVisualWords.INSTANCE.setChangeWords(false);

        List<class_5348> lines = original.call(text, maxWidth, style, wrappedLinePrefix);

        ModifyVisualWords.INSTANCE.setChangeWords(true);
        return lines;
    }

    @WrapMethod(
        method = "wrapLines(Lnet/minecraft/text/StringVisitable;ILnet/minecraft/text/Style;)Ljava/util/List;"
    )
    private List<class_5348> dontWrapOtherLines(class_5348 text, int maxWidth, class_2583 style, Operation<List<class_5348>> original) {
        ModifyVisualWords.INSTANCE.setChangeWords(false);

        List<class_5348> lines = original.call(text, maxWidth, style);

        ModifyVisualWords.INSTANCE.setChangeWords(true);
        return lines;
    }

    @ModifyVariable(
        method = "wrapLines(Lnet/minecraft/text/StringVisitable;ILnet/minecraft/text/Style;Ljava/util/function/BiConsumer;)V",
        at = @At(
            value = "HEAD"
        ),
        index = 1,
        argsOnly = true
    )
    private class_5348 modifyStringVisitable(class_5348 visitable) {

        class_5348 replaced = ModifyVisualWords.INSTANCE.transformStringVisitable(
            visitable
        );

        if (replaced == null) return visitable;
        return replaced;
    }

}
